/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view;

import fuego.directory.DirDeployedProcess;
import fuego.directory.DirectorySession;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.Time;
import oracle.bpm.locale.LocaleSupport;
import oracle.bpm.resources.Msg;
import oracle.bpm.view.ActivityViewImpl;
import oracle.bpm.view.ApplicationsViewImpl;
import oracle.bpm.view.AttachmentsViewImpl;
import oracle.bpm.view.BookmarkViewImpl;
import oracle.bpm.view.ConsultationsViewImpl;
import oracle.bpm.view.FolderViewImpl;
import oracle.bpm.view.HistoryViewImpl;
import oracle.bpm.view.InstancesViewImpl;
import oracle.bpm.view.PresentationType;
import oracle.bpm.view.ViewType;
import org.jetbrains.annotations.NonNls;

public abstract class ViewImpl
implements Serializable {
    protected Collection<String> assignedProcesses;
    protected Collection<String> assignedRoles;
    protected String id;
    protected boolean isCustom;
    protected boolean isHidden;
    protected boolean isReadOnly;
    protected boolean isTransient;
    protected LocaleStringMap labels;
    protected String ownerId;
    protected String presentationId;
    @NonNls
    public static final String APPLICATIONS_DEFAULT_ID = "applications";
    @NonNls
    public static final String ATTACHMENTS_DEFAULT_ID = "working_attachments";
    @NonNls
    public static final String BOOKMARK_DEFAULT_ID = "bookmark_view";
    @NonNls
    public static final String CONSULTATIONS_DEFAUTL_ID = "consultation_view";
    @NonNls
    public static final String DEFAULT_OWNER = "organization";
    @NonNls
    public static final String HISTORY_DEFAULT_ID = "history_view";
    @NonNls
    public static final String HISTORY_TODAY_DEFAULT_ID = "today";
    @NonNls
    public static final String INBOX_DEFAULT_ID = "unified_inbox";
    @NonNls
    public static final String ID_SEPARATOR = "/";
    static final long serialVersionUID = 2850165492872192267L;
    static final long serialCheck = -3927976721878123157L;

    protected ViewImpl(String id, String owner) {
        this.id = id;
        this.ownerId = owner == null ? DEFAULT_OWNER : owner;
        this.labels = LocaleStringMap.create();
        this.assignedProcesses = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.assignedRoles = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.isHidden = false;
        this.isReadOnly = true;
        this.isCustom = true;
        this.isTransient = true;
    }

    public abstract PresentationType getPresentationType();

    public abstract ViewType getType();

    public static ViewImpl create(ViewType viewType, String id) {
        return ViewImpl.create(viewType, id, DEFAULT_OWNER);
    }

    public static ViewImpl create(ViewType viewType, String id, String owner) {
        if (viewType == ViewType.APPLICATIONS) {
            return ViewImpl.createApplicationsView(id, owner);
        }
        if (viewType == ViewType.ATTACHMENTS) {
            return ViewImpl.createAttachmentsView(id, owner);
        }
        if (viewType == ViewType.INSTANCES) {
            return ViewImpl.createInstancesView(id, owner);
        }
        if (viewType == ViewType.ACTIVITY_INSTANCES) {
            return ViewImpl.createActivityView(id, null, owner);
        }
        if (viewType == ViewType.BOOKMARKS) {
            return ViewImpl.createBookmarkView(id);
        }
        if (viewType == ViewType.CONSULTATIONS) {
            return ViewImpl.createConsultationsView(id);
        }
        if (viewType == ViewType.HISTORY) {
            return ViewImpl.createHistoryView(id);
        }
        if (viewType == ViewType.FOLDER) {
            return ViewImpl.createFolderView(id, owner);
        }
        throw new IllegalArgumentException("Invalid ViewType [" + viewType + "]");
    }

    public static ActivityViewImpl createActivityView(String id, String activity) {
        return ViewImpl.createActivityView(id, activity, DEFAULT_OWNER);
    }

    public static ActivityViewImpl createActivityView(String id, String activity, String owner) {
        return new ActivityViewImpl(id, owner, activity);
    }

    public static ApplicationsViewImpl createApplicationsView(String id) {
        return ViewImpl.createApplicationsView(id, DEFAULT_OWNER);
    }

    public static ApplicationsViewImpl createApplicationsView(String id, String owner) {
        return new ApplicationsViewImpl(id, owner);
    }

    public static AttachmentsViewImpl createAttachmentsView(String id) {
        return ViewImpl.createAttachmentsView(id, DEFAULT_OWNER);
    }

    public static AttachmentsViewImpl createAttachmentsView(String id, String owner) {
        return new AttachmentsViewImpl(id, owner);
    }

    public static BookmarkViewImpl createBookmarkView(String id) {
        return new BookmarkViewImpl(id, DEFAULT_OWNER);
    }

    public static BookmarkViewImpl createBookmarkView(String id, String owner) {
        return new BookmarkViewImpl(id, owner);
    }

    public static ConsultationsViewImpl createConsultationsView(String id) {
        return new ConsultationsViewImpl(id, DEFAULT_OWNER);
    }

    public static ConsultationsViewImpl createConsultationsView(String id, String owner) {
        return new ConsultationsViewImpl(id, owner);
    }

    public static FolderViewImpl createFolderView(String id) {
        return ViewImpl.createFolderView(id, DEFAULT_OWNER);
    }

    public static FolderViewImpl createFolderView(String id, String owner) {
        return new FolderViewImpl(id, owner);
    }

    public static HistoryViewImpl createHistoryView(String id) {
        return new HistoryViewImpl(id, DEFAULT_OWNER, Time.now(), Time.now());
    }

    public static HistoryViewImpl createHistoryView(String id, String owner) {
        return new HistoryViewImpl(id, owner, Time.now(), Time.now());
    }

    public static InstancesViewImpl createInstancesView(String id) {
        return ViewImpl.createInstancesView(id, DEFAULT_OWNER);
    }

    public static InstancesViewImpl createInstancesView(String id, String owner) {
        return new InstancesViewImpl(id, owner);
    }

    public static String getParentId(String id) {
        int end = id.lastIndexOf(ID_SEPARATOR);
        if (end != -1) {
            return id.substring(0, end);
        }
        return null;
    }

    public static char[] invalidViewIdCharacters() {
        return DirectorySession.invalidKeyCharacters();
    }

    public void assignProcess(String processId) {
        this.assignedProcesses.add(DirDeployedProcess.getConsolidatedId(processId));
    }

    public void assignProcesses(String[] processIds) {
        if (processIds != null) {
            for (String element : processIds) {
                this.assignProcess(element);
            }
        }
    }

    public void assignRole(String roleId) {
        this.assignedRoles.add(roleId);
    }

    public void assignRoles(String[] roleIds) {
        this.assignedRoles.addAll(Arrays.asList(roleIds));
    }

    public void clearLabels() {
        this.labels.clear();
    }

    public ViewImpl copy() {
        ViewImpl copy = ViewImpl.create(this.getType(), this.id, this.ownerId);
        copy.presentationId = this.presentationId;
        copy.assignedProcesses.addAll(this.assignedProcesses);
        copy.assignedRoles.addAll(this.assignedRoles);
        copy.isCustom = this.isCustom;
        copy.isHidden = this.isHidden;
        copy.isReadOnly = this.isReadOnly;
        copy.isTransient = true;
        copy.labels = this.labels.clone();
        return copy;
    }

    public String[] getAssignedProcesses() {
        return this.assignedProcesses.toArray(new String[this.assignedProcesses.size()]);
    }

    public String[] getAssignedRoles() {
        return this.assignedRoles.toArray(new String[this.assignedRoles.size()]);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel(Locale locale) {
        String label = null;
        if (locale != null) {
            label = this.labels.getString(locale);
        }
        if (label == null || label.trim().equals("")) {
            label = this.labels.getString();
        }
        if (label == null || label.trim().equals("")) {
            label = this.id.substring(this.id.lastIndexOf(ID_SEPARATOR) + 1);
        }
        return label;
    }

    public LocaleStringMap getLabels() {
        return this.labels;
    }

    public String getOwner() {
        return this.ownerId;
    }

    public String getParentId() {
        return ViewImpl.getParentId(this.id);
    }

    public String getPresentation() {
        if (this.presentationId == null) {
            this.presentationId = this.getDefaultPresentation();
        }
        return this.presentationId;
    }

    public boolean hasType(ViewType viewType) {
        return this.getType().isType(viewType);
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public String removeLabel(Locale locale) {
        return this.labels.remove(locale);
    }

    public void setCustom(boolean isCustom) {
        this.isCustom = isCustom;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public void setLabel(String label, Locale locale) {
        this.labels.put(locale, label);
    }

    public void setLabels(Msg labels) {
        for (LocaleSupport locale : Platform.getLocaleService().getSupportedLocales()) {
            String label = labels.getString(locale);
            if (label == null) continue;
            this.setLabel(label, locale.asJavaLocale());
        }
    }

    public void setLabels(LocaleStringMap labels) {
        this.labels = labels;
    }

    public void setOwner(String owner) {
        this.ownerId = owner;
    }

    public void setPresentation(String presentationId) {
        this.presentationId = presentationId;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public String toString() {
        StringBuffer description = new StringBuffer();
        description.append("View\n");
        description.append("\tId '");
        description.append(this.id);
        description.append("'\n");
        description.append("\tType '");
        description.append(this.getType().getString());
        description.append("'\n");
        description.append("\tOwner '");
        description.append(this.ownerId);
        description.append("'\n");
        description.append("\tIs Read Only '");
        description.append(this.isReadOnly);
        description.append("'\n");
        description.append("\tIs Custom '");
        description.append(this.isCustom);
        description.append("'\n");
        description.append("\tIs Hidden '");
        description.append(this.isHidden);
        description.append("'\n");
        description.append("\tPresentation '");
        description.append(this.presentationId);
        description.append("'\n");
        description.append("\tAssigned Processes\n");
        if (this.assignedProcesses != null) {
            for (String string : this.assignedProcesses) {
                description.append("\t\tProcess '");
                description.append(string);
                description.append("'\n");
            }
        }
        description.append("\tAssigned Roles\n");
        if (this.assignedRoles != null) {
            for (String string : this.assignedRoles) {
                description.append("\t\tRole '");
                description.append(string);
                description.append("'\n");
            }
        }
        description.append("\tLabels\n");
        if (this.labels != null) {
            for (Map.Entry entry : this.labels.entrySet()) {
                description.append("\t\tLabel [");
                description.append(((Locale)entry.getKey()).getLanguage());
                description.append("] '");
                description.append((String)entry.getValue());
                description.append("'\n");
            }
        }
        return description.toString();
    }

    public void unassignAllProcesses() {
        this.assignedProcesses.clear();
    }

    public void unassignAllRoles() {
        this.assignedRoles.clear();
    }

    public void unassignProcess(String processId) {
        this.assignedProcesses.remove(DirDeployedProcess.getConsolidatedId(processId));
    }

    public void unassignRole(String roleId) {
        this.assignedRoles.remove(roleId);
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ViewImpl)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        ViewImpl otherView = (ViewImpl)other;
        return this.id.equals(otherView.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected abstract String getDefaultPresentation();
}

