/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view;

import java.util.Locale;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum PresentationType implements I18nProvider
{
    APPLICATIONS(LibMsg.APPLICATIONS, 0),
    ATTACHMENTS(LibMsg.ATTACHMENTS, 1),
    INSTANCES(LibMsg.INSTANCES, 2),
    ACTIVITY(LibMsg.ACTIVITY, 3),
    FOLDER(LibMsg.FOLDER, 4);

    private transient Msg msg;
    private transient int in;

    private PresentationType(Msg msg, int in) {
        this.msg = msg;
        this.in = in;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }

    public static boolean isValid(PresentationType presentationType) {
        PresentationType[] values;
        for (PresentationType type : values = PresentationType.values()) {
            if (!type.isType(presentationType)) continue;
            return true;
        }
        return false;
    }

    public int getIn() {
        return this.in;
    }

    public boolean isType(PresentationType presentationType) {
        return presentationType == this;
    }
}

