/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view;

import java.io.Serializable;
import oracle.bpm.view.ColumnFormat;
import oracle.bpm.view.Ordering;
import oracle.bpm.view.PresentationType;
import oracle.bpm.view.Variable;
import org.jetbrains.annotations.NonNls;

public class PresentationImpl
implements Serializable {
    private Column[] columns;
    private String id;
    private boolean isReadOnly = false;
    private Ordering ordering;
    private String owner;
    private PresentationType type;
    @NonNls
    public static final String DEFAULT_ACTIVITY_ID = "default_activity";
    @NonNls
    public static final String DEFAULT_APPLICATIONS_ID = "default_applications";
    @NonNls
    public static final String DEFAULT_ATTACHMENTS_ID = "default_attachments";
    @NonNls
    public static final String DEFAULT_FOLDER_ID = "default_folder";
    @NonNls
    public static final String DEFAULT_INSTANCES_ID = "default_instances";
    @NonNls
    public static final String DEFAULT_OWNER = "organization";
    static final long serialVersionUID = -3478656211548650668L;
    public static final String DEFAULT_ID = "default";
    public static final String INSTANCES_FDI_CATEGORY = "InstancesPresentation";
    static final long SerialVersionUID = 1L;
    static final long serialCheck = 7408389144124236580L;

    public PresentationImpl(PresentationType type, String id, Column[] columns) {
        this(type, id, columns, DEFAULT_OWNER);
    }

    public PresentationImpl(PresentationType type, String id, Column[] columns, String owner) {
        this.id = id;
        this.type = type;
        this.owner = owner;
        this.columns = columns;
    }

    public void setColumns(Column[] columns) {
        this.columns = columns;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public String getId() {
        return this.id;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner == null ? DEFAULT_OWNER : this.owner;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public PresentationType getType() {
        return this.type;
    }

    public PresentationImpl copy(String newId) {
        PresentationImpl copy = new PresentationImpl(this.type, newId, this.columns, this.owner);
        copy.setReadOnly(this.isReadOnly);
        return copy;
    }

    public void setOrdering(Ordering ordering) {
        this.ordering = ordering;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public static class Column
    implements Serializable {
        private ColumnFormat columnFormatter;
        private int size = -1;
        private transient Object variableObject;
        private String varibleId;
        static final long serialCheck = 6797882371691663108L;
        static final long serialVersionUID = -5543757071050616696L;

        public Column(Variable variable) {
            this.varibleId = variable.getId();
            this.size = variable.getSize();
            this.variableObject = variable;
        }

        public Column(String variable, int size) {
            this.varibleId = variable;
            this.size = size;
        }

        public Column(String variable, int size, ColumnFormat columnFormatter) {
            this.varibleId = variable;
            this.size = size;
            this.columnFormatter = columnFormatter;
        }

        protected Column() {
        }

        public String getId() {
            return this.varibleId;
        }

        public void setVariable(Object variableObject) {
            this.variableObject = variableObject;
        }

        public Object getVariable() {
            return this.variableObject;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public ColumnFormat getColumnFormat() {
            return this.columnFormatter;
        }

        public void setColumnFormat(ColumnFormat columnFormat) {
            this.columnFormatter = columnFormat;
        }
    }
}

