/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Kind;
import oracle.bpm.lang.Time;
import oracle.bpm.view.Comparison;

public class FilterAttributeImpl
implements Serializable {
    private Comparison comparison;
    private boolean isParametric;
    private int kind = -1;
    private Object value;
    private String variableId;
    static final long serialVersionUID = 5989660842789367692L;
    static final long serialCheck = -4167933030556449176L;

    public FilterAttributeImpl() {
    }

    public FilterAttributeImpl(String variableId, Comparison comparison, Object value) {
        this(variableId, FilterAttributeImpl.getKind(value), comparison, value);
    }

    public FilterAttributeImpl(String variableId, int kind, Comparison comparison, Object value) {
        this.setVariableId(variableId);
        this.setKind(kind);
        this.setComparison(comparison);
        this.setValue(value);
    }

    public boolean equals(Object comparator) {
        FilterAttributeImpl attribute;
        if (comparator == this) {
            return true;
        }
        if (comparator != null && comparator instanceof FilterAttributeImpl && this.variableId.equalsIgnoreCase((attribute = (FilterAttributeImpl)comparator).getVariableId()) && this.comparison == attribute.getComparison()) {
            Object currentValue = this.getValue();
            if (currentValue != null) {
                try {
                    return currentValue.equals(attribute.getValue());
                }
                catch (ClassCastException exception) {
                }
            } else {
                return currentValue == attribute.getValue();
            }
        }
        return false;
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    public int getKind() {
        return this.kind;
    }

    public Object getValue() {
        if (this.value == null && this.comparison != Comparison.IS_NULL && this.comparison != Comparison.IS_NOT_NULL) {
            return this.getDefaultValue();
        }
        return this.value;
    }

    public String getVariableId() {
        return this.variableId;
    }

    public int hashCode() {
        int hashCode = 23;
        hashCode = 17 * hashCode + this.variableId.toLowerCase().hashCode();
        hashCode = 17 * hashCode + this.comparison.hashCode();
        hashCode = 17 * hashCode + (this.value == null ? 0 : this.value.hashCode());
        return hashCode;
    }

    public boolean isParametric() {
        return this.isParametric;
    }

    public void setComparison(Comparison comparison) {
        this.checkOperatorType(comparison);
        this.comparison = comparison;
        this.changedValue();
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public void setParametric(boolean isParametric) {
        this.isParametric = isParametric;
    }

    public void setValue(Object value) {
        this.checkValue(value);
        if (value == null && this.comparison != Comparison.IS_NULL && this.comparison != Comparison.IS_NOT_NULL) {
            value = this.getDefaultValue();
        }
        this.value = value;
    }

    public void setVariableId(String variableId) {
        this.variableId = variableId;
    }

    public String toString() {
        StringBuilder description = new StringBuilder("Attribute ");
        description.append(this.variableId);
        description.append(" (");
        description.append(this.kind);
        description.append(") ");
        description.append(this.comparison.name());
        description.append(" ");
        Object _value = this.getValue();
        if (_value == null) {
            description.append("null (null)");
        } else {
            description.append(_value.toString());
            description.append("(");
            description.append(_value.getClass().getName());
            description.append(")");
        }
        description.append(" - Parametric '");
        description.append(this.isParametric);
        description.append("'");
        return description.toString();
    }

    private static int getKind(Object value) {
        Object checkValue = null;
        if (value.getClass().isArray()) {
            Class<?> clazz = value.getClass().getComponentType();
            if (clazz != null) {
                try {
                    checkValue = clazz.newInstance();
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        } else {
            checkValue = value;
        }
        if (checkValue instanceof Integer || checkValue instanceof Long) {
            return 2;
        }
        if (checkValue instanceof Float || checkValue instanceof Double) {
            return 4;
        }
        if (checkValue instanceof BigDecimal || checkValue instanceof Number) {
            return 3;
        }
        if (checkValue instanceof Time || checkValue instanceof Date) {
            return 6;
        }
        if (checkValue instanceof Interval) {
            return 7;
        }
        if (checkValue instanceof Boolean) {
            return 1;
        }
        if (checkValue instanceof String) {
            return 5;
        }
        return -1;
    }

    private void changedValue() {
        Object oldValue = this.value;
        Object newValue = this.getDefaultValue();
        if (oldValue == null || newValue == null) {
            this.value = newValue;
        } else if (oldValue.getClass().isArray() != newValue.getClass().isArray()) {
            this.value = newValue;
        }
    }

    private void checkOperatorType(Comparison operator) {
        boolean isValidOperator = true;
        if (this.kind != -1) {
            switch (this.kind) {
                case 1: {
                    if (operator == Comparison.IS || operator == Comparison.IS_NULL || operator == Comparison.IS_NOT || operator == Comparison.IS_NOT_NULL) break;
                    isValidOperator = false;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    if (!operator.isTextComparisonOnly()) break;
                    isValidOperator = false;
                    break;
                }
                case 5: {
                    isValidOperator = true;
                    break;
                }
                default: {
                    isValidOperator = false;
                }
            }
        }
        if (!isValidOperator) {
            throw new IllegalArgumentException("Invalid comparator");
        }
    }

    private void checkValue(Object _value) {
        if (_value != null) {
            boolean isValidType = true;
            if (this.comparison == Comparison.BETWEEN || this.comparison == Comparison.NOT_BETWEEN) {
                isValidType = _value.getClass().isArray();
                if (isValidType) {
                    Object[] values = (Object[])_value;
                    boolean bl = isValidType = values.length == 2;
                    if (isValidType) {
                        switch (this.kind) {
                            case 2: 
                            case 3: 
                            case 4: {
                                isValidType = Number.class.isAssignableFrom(_value.getClass().getComponentType());
                                break;
                            }
                            case 6: {
                                isValidType = Time.class.isAssignableFrom(_value.getClass().getComponentType());
                                break;
                            }
                            default: {
                                isValidType = false;
                                break;
                            }
                        }
                    } else {
                        throw new IllegalArgumentException("Illegal array size (The size must be 2).");
                    }
                    if (isValidType && ((Comparable)values[0]).compareTo(values[1]) > 0) {
                        throw new IllegalArgumentException("The first value of the array must be lower than the second.");
                    }
                }
            } else if (this.kind != -1) {
                switch (this.kind) {
                    case 1: {
                        if (_value instanceof Boolean) break;
                        isValidType = false;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        if (_value instanceof Number) break;
                        isValidType = false;
                        break;
                    }
                    case 5: {
                        if (_value instanceof String) break;
                        isValidType = false;
                        break;
                    }
                    case 6: {
                        if (_value instanceof Time || _value instanceof Interval) break;
                        isValidType = false;
                        break;
                    }
                    default: {
                        isValidType = false;
                    }
                }
            }
            if (!isValidType) {
                throw new IllegalArgumentException("Invalid object type [kind " + Kind.getName(this.kind) + "] " + _value.getClass().getName());
            }
        }
    }

    private Object getDefaultValue() {
        if (this.comparison == Comparison.IS_NULL || this.comparison == Comparison.IS_NOT_NULL) {
            return null;
        }
        if (this.comparison == Comparison.BETWEEN || this.comparison == Comparison.NOT_BETWEEN) {
            switch (this.kind) {
                case 3: {
                    return new Double[]{0.0, 0.0};
                }
                case 2: 
                case 4: {
                    return new Long[]{0L, 0L};
                }
                case 6: {
                    return new Time[]{Time.now(), Time.now()};
                }
            }
            return null;
        }
        switch (this.kind) {
            case 1: {
                return Boolean.FALSE;
            }
            case 3: {
                return 0.0;
            }
            case 2: 
            case 4: {
                return 0;
            }
            case 5: {
                return "";
            }
            case 6: {
                return Time.now();
            }
            case 7: {
                return new Interval();
            }
        }
        return null;
    }
}

