/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NonNls;

public enum Comparison implements I18nProvider
{
    IS(LibMsg.IS, "=", "=="),
    IS_NOT(LibMsg.IS_NOT, "<>", "!="),
    LESS_THAN(LibMsg.LESS_THAN, "<", "<"),
    LESS_OR_EQUALS(LibMsg.LESS_OR_EQUALS, "<=", "<="),
    GREATER_THAN(LibMsg.GREATER_THAN, ">", ">"),
    GREATER_OR_EQUALS(LibMsg.GREATER_OR_EQUALS, ">=", ">="),
    IS_NULL(LibMsg.IS_NULL, "IS NULL", null),
    IS_NOT_NULL(LibMsg.IS_NOT_NULL, "IS NOT NULL", null),
    BEGIN_WITH(LibMsg.BEGIN_WITH, "LIKE", null, true),
    NOT_BEGIN_WITH(LibMsg.NOT_BEGIN_WITH, "NOT LIKE", null, true),
    END_WITH(LibMsg.END_WITH, "LIKE", null, true),
    NOT_END_WITH(LibMsg.NOT_END_WITH, "NOT LIKE", null, true),
    CONTAINS(LibMsg.CONTAINS, "LIKE", null, true),
    NOT_CONTAINS(LibMsg.NOT_CONTAINS, "NOT LIKE", null, true),
    BEFORE(LibMsg.BEFORE, "<", "<"),
    AFTER(LibMsg.AFTER, ">", ">"),
    BETWEEN(LibMsg.BETWEEN, "BETWEEN", null),
    NOT_BETWEEN(LibMsg.NOT_BETWEEN, "NOT BETWEEN", null);

    private transient Msg msg;
    private transient String expr;
    private transient String cilExpr;
    private transient boolean isTestComparisonOnly;

    private Comparison(@NonNls Msg msg, String expr, String cilExpr) {
        this.msg = msg;
        this.expr = " " + expr + " ";
        this.cilExpr = cilExpr;
    }

    private Comparison(@NonNls Msg msg, String expr, String cilExpr, boolean isTextComparisonOnly) {
        this(msg, expr, cilExpr);
        this.isTestComparisonOnly = isTextComparisonOnly;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }

    public boolean isTextComparisonOnly() {
        return this.isTestComparisonOnly;
    }

    public boolean isTimeComparisonOnly() {
        return this == BEFORE || this == AFTER || this == BETWEEN;
    }

    public String getSQLExpression() {
        return this.expr;
    }

    public String getCilExpression() {
        return this.cilExpr;
    }

    public static List<Comparison> getNumericalComparisons() {
        ArrayList<Comparison> operators = new ArrayList<Comparison>();
        operators.add(IS);
        operators.add(IS_NOT);
        operators.add(LESS_THAN);
        operators.add(LESS_OR_EQUALS);
        operators.add(GREATER_THAN);
        operators.add(GREATER_OR_EQUALS);
        operators.add(IS_NULL);
        operators.add(IS_NOT_NULL);
        operators.add(BETWEEN);
        operators.add(NOT_BETWEEN);
        return operators;
    }

    public static List<Comparison> getAlfanumericComparisons() {
        ArrayList<Comparison> operators = new ArrayList<Comparison>();
        operators.add(IS);
        operators.add(IS_NOT);
        operators.add(CONTAINS);
        operators.add(NOT_CONTAINS);
        operators.add(BEGIN_WITH);
        operators.add(NOT_BEGIN_WITH);
        operators.add(END_WITH);
        operators.add(NOT_END_WITH);
        operators.add(IS_NULL);
        operators.add(IS_NOT_NULL);
        return operators;
    }

    public static List<Comparison> getBooleanComparisons() {
        ArrayList<Comparison> operators = new ArrayList<Comparison>();
        operators.add(IS);
        operators.add(IS_NOT);
        operators.add(IS_NULL);
        operators.add(IS_NOT_NULL);
        return operators;
    }

    public static List<Comparison> getTimeComparisons() {
        ArrayList<Comparison> operators = new ArrayList<Comparison>();
        operators.add(IS);
        operators.add(IS_NOT);
        operators.add(BEFORE);
        operators.add(AFTER);
        operators.add(IS_NULL);
        operators.add(IS_NOT_NULL);
        operators.add(BETWEEN);
        operators.add(NOT_BETWEEN);
        return operators;
    }

    public static List<Comparison> getCilNumericalComparisons() {
        ArrayList<Comparison> operators = new ArrayList<Comparison>();
        operators.add(IS);
        operators.add(IS_NOT);
        operators.add(LESS_THAN);
        operators.add(LESS_OR_EQUALS);
        operators.add(GREATER_THAN);
        operators.add(GREATER_OR_EQUALS);
        return operators;
    }

    public static List<Comparison> getCilAlfanumericComparisons() {
        ArrayList<Comparison> operators = new ArrayList<Comparison>();
        operators.add(IS);
        operators.add(IS_NOT);
        return operators;
    }

    public static List<Comparison> getCilBooleanComparisons() {
        ArrayList<Comparison> operators = new ArrayList<Comparison>();
        operators.add(IS);
        operators.add(IS_NOT);
        return operators;
    }

    public static List<Comparison> getCilTimeComparisons() {
        ArrayList<Comparison> operators = new ArrayList<Comparison>();
        operators.add(IS);
        operators.add(IS_NOT);
        operators.add(BEFORE);
        operators.add(AFTER);
        return operators;
    }
}

