/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpm.lang.Time;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum ColumnFormatType implements I18nProvider
{
    DEFAULT(LibMsg.DEFAULT){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getDateInstance(0, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    DATE_FULL(LibMsg.DATE_FULL){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getDateInstance(0, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    DATE_LONG(LibMsg.DATE_LONG){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getDateInstance(1, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    DATE_MEDIUM(LibMsg.DATE_MEDIUM){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getDateInstance(2, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    DATE_SHORT(LibMsg.DATE_SHORT){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getDateInstance(3, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    DATE_TIME_FULL(LibMsg.DATE_TIME_FULL){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getDateTimeInstance(0, 0, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    DATE_TIME_LONG(LibMsg.DATE_TIME_LONG){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getDateTimeInstance(1, 1, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    DATE_TIME_MEDIUM(LibMsg.DATE_TIME_MEDIUM){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getDateTimeInstance(2, 2, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    DATE_TIME_SHORT(LibMsg.DATE_TIME_SHORT){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getDateTimeInstance(3, 3, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    DATE_CUSTOM(LibMsg.DATE_CUSTOM){

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getDateTimeInstance(2, 2, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    TIME_FULL(LibMsg.TIME_FULL){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getTimeInstance(0, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    TIME_LONG(LibMsg.TIME_LONG){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getTimeInstance(1, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    TIME_MEDIUM(LibMsg.TIME_MEDIUM){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getTimeInstance(2, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    TIME_SHORT(LibMsg.TIME_SHORT){

        @Override
        public Format getFormat(Locale locale) {
            return DateFormat.getTimeInstance(3, locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new SimpleDateFormat(pattern, locale);
        }

        @Override
        Object getPreviewObject() {
            return Time.now().dateValue();
        }
    }
    ,
    NUMBER_INTEGER(LibMsg.NUMBER_INTEGER){

        @Override
        public Format getFormat(Locale locale) {
            return NumberFormat.getIntegerInstance(locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new DecimalFormat(pattern, new DecimalFormatSymbols(locale));
        }

        @Override
        Object getPreviewObject() {
            return 1.2345;
        }
    }
    ,
    NUMBER_DECIMAL(LibMsg.NUMBER_DECIMAL){

        @Override
        public Format getFormat(Locale locale) {
            return NumberFormat.getInstance(locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new DecimalFormat(pattern, new DecimalFormatSymbols(locale));
        }

        @Override
        Object getPreviewObject() {
            return 1.2345;
        }
    }
    ,
    NUMBER_CURRENCY(LibMsg.NUMBER_CURRENCY){

        @Override
        public Format getFormat(Locale locale) {
            return NumberFormat.getCurrencyInstance(locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new DecimalFormat(pattern, new DecimalFormatSymbols(locale));
        }

        @Override
        Object getPreviewObject() {
            return 1.2345;
        }
    }
    ,
    NUMBER_PERCENT(LibMsg.NUMBER_PERCENT){

        @Override
        public Format getFormat(Locale locale) {
            return NumberFormat.getPercentInstance(locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new DecimalFormat(pattern, new DecimalFormatSymbols(locale));
        }

        @Override
        Object getPreviewObject() {
            return 1.2345;
        }
    }
    ,
    NUMBER_CUSTOM(LibMsg.NUMBER_CUSTOM){

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public Format getFormat(Locale locale) {
            return NumberFormat.getInstance(locale);
        }

        @Override
        public Format getFormat(Locale locale, String pattern) {
            return new DecimalFormat(pattern, new DecimalFormatSymbols(locale));
        }

        @Override
        Object getPreviewObject() {
            return 1.2345;
        }
    };

    private transient Msg msg;

    private ColumnFormatType(Msg msg) {
        this.msg = msg;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }

    public Format getFormat(Locale locale) {
        return null;
    }

    public Format getFormat(Locale locale, String pattern) {
        return null;
    }

    public boolean isCustom() {
        return false;
    }

    Object getPreviewObject() {
        return null;
    }

    public String getFormatPreview(Locale locale) {
        return this.getFormat(locale).format(this.getPreviewObject());
    }

    public String getFormatPreview(Locale locale, String pattern) {
        return this.getFormat(locale, pattern).format(this.getPreviewObject());
    }

    public static List<ColumnFormatType> getTimeFormatTypes() {
        ArrayList<ColumnFormatType> types = new ArrayList<ColumnFormatType>();
        types.add(DEFAULT);
        types.add(DATE_FULL);
        types.add(DATE_LONG);
        types.add(DATE_MEDIUM);
        types.add(DATE_SHORT);
        types.add(TIME_FULL);
        types.add(TIME_LONG);
        types.add(TIME_MEDIUM);
        types.add(TIME_SHORT);
        types.add(DATE_TIME_FULL);
        types.add(DATE_TIME_LONG);
        types.add(DATE_TIME_MEDIUM);
        types.add(DATE_TIME_SHORT);
        types.add(DATE_CUSTOM);
        return types;
    }

    public static List<ColumnFormatType> getNumericalFormatTypes() {
        ArrayList<ColumnFormatType> types = new ArrayList<ColumnFormatType>();
        types.add(NUMBER_INTEGER);
        types.add(NUMBER_DECIMAL);
        types.add(NUMBER_CURRENCY);
        types.add(NUMBER_PERCENT);
        types.add(NUMBER_CUSTOM);
        return types;
    }
}

