/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view;

import fuego.papi.Ordering;
import fuego.papi.Presentation;
import fuego.papi.VarDefinition;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.view.ColumnFormat;
import oracle.bpm.view.ColumnFormatType;
import oracle.bpm.view.Comparison;
import oracle.bpm.view.DefaultVariable;
import oracle.bpm.view.Ordering;
import oracle.bpm.view.ParticipantScope;
import oracle.bpm.view.PresentationImpl;
import oracle.bpm.view.PresentationType;
import oracle.bpm.view.SearchScope;
import oracle.bpm.view.StatusScope;
import oracle.bpm.view.Variable;
import oracle.bpm.view.ViewsGenerationType;

public class AdapterUtils {
    public static Ordering valueOf(fuego.papi.Ordering ordering) {
        Ordering _ordering = new Ordering();
        if (ordering != null) {
            int size = ordering.getEntryCount();
            for (int i = 0; i < size; ++i) {
                Ordering.Entry entry = ordering.getEntry(i);
                _ordering.add(entry.getVariableId(), entry.isAscending());
            }
        }
        return _ordering;
    }

    public static fuego.papi.Ordering valueOf(Ordering ordering) {
        fuego.papi.Ordering _ordering = new fuego.papi.Ordering();
        if (ordering != null) {
            int size = ordering.getEntryCount();
            for (int i = 0; i < size; ++i) {
                Ordering.Entry entry = ordering.getEntry(i);
                _ordering.add(entry.getVariableId(), entry.isAscending());
            }
        }
        return _ordering;
    }

    public static PresentationImpl.Column[] valueOf(Presentation.Column[] columns) {
        PresentationImpl.Column[] result = new PresentationImpl.Column[]{};
        if (columns != null) {
            result = new PresentationImpl.Column[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                result[i] = AdapterUtils.valueOf(columns[i]);
            }
        }
        return result;
    }

    public static PresentationImpl.Column valueOf(Presentation.Column column) {
        PresentationImpl.Column newColumn = new PresentationImpl.Column(column.getVarDefinition().getId(), column.getSize(), AdapterUtils.valueOf(column.getColumnFormat()));
        newColumn.setVariable(AdapterUtils.valueOf(column.getVarDefinition()));
        return newColumn;
    }

    public static ColumnFormat valueOf(fuego.papi.ColumnFormat columnFormat) {
        ColumnFormatType columnFormatType;
        if (columnFormat == null || ColumnFormatType.DEFAULT.equals(columnFormat.getType())) {
            return null;
        }
        switch (columnFormat.getType()) {
            case DATE_CUSTOM: {
                columnFormatType = ColumnFormatType.DATE_CUSTOM;
                break;
            }
            case DATE_FULL: {
                columnFormatType = ColumnFormatType.DATE_FULL;
                break;
            }
            case DATE_LONG: {
                columnFormatType = ColumnFormatType.DATE_LONG;
                break;
            }
            case DATE_MEDIUM: {
                columnFormatType = ColumnFormatType.DATE_MEDIUM;
                break;
            }
            case DATE_SHORT: {
                columnFormatType = ColumnFormatType.DATE_SHORT;
                break;
            }
            case DATE_TIME_FULL: {
                columnFormatType = ColumnFormatType.DATE_TIME_FULL;
                break;
            }
            case DATE_TIME_LONG: {
                columnFormatType = ColumnFormatType.DATE_TIME_LONG;
                break;
            }
            case DATE_TIME_MEDIUM: {
                columnFormatType = ColumnFormatType.DATE_TIME_MEDIUM;
                break;
            }
            case DATE_TIME_SHORT: {
                columnFormatType = ColumnFormatType.DATE_TIME_SHORT;
                break;
            }
            case NUMBER_CURRENCY: {
                columnFormatType = ColumnFormatType.NUMBER_CURRENCY;
                break;
            }
            case NUMBER_CUSTOM: {
                columnFormatType = ColumnFormatType.NUMBER_CUSTOM;
                break;
            }
            case NUMBER_DECIMAL: {
                columnFormatType = ColumnFormatType.NUMBER_DECIMAL;
                break;
            }
            case NUMBER_INTEGER: {
                columnFormatType = ColumnFormatType.NUMBER_INTEGER;
                break;
            }
            case NUMBER_PERCENT: {
                columnFormatType = ColumnFormatType.NUMBER_PERCENT;
                break;
            }
            case TIME_FULL: {
                columnFormatType = ColumnFormatType.TIME_FULL;
                break;
            }
            case TIME_LONG: {
                columnFormatType = ColumnFormatType.TIME_LONG;
                break;
            }
            case TIME_MEDIUM: {
                columnFormatType = ColumnFormatType.TIME_MEDIUM;
                break;
            }
            case TIME_SHORT: {
                columnFormatType = ColumnFormatType.TIME_SHORT;
                break;
            }
            default: {
                columnFormatType = ColumnFormatType.NUMBER_CUSTOM;
            }
        }
        return ColumnFormat.getInstance(columnFormatType, columnFormat.getPattern());
    }

    public static Presentation.Column valueOf(PresentationImpl.Column column) {
        Presentation.Column result = new Presentation.Column(column.getId(), column.getSize(), AdapterUtils.valueOf(column.getColumnFormat()));
        if (column.getVariable() != null) {
            if (column.getVariable() instanceof Variable) {
                result.setVarDefinition(AdapterUtils.valueOf((Variable)column.getVariable()));
            } else {
                result.setVarDefinition((VarDefinition)column.getVariable());
            }
        }
        return result;
    }

    public static fuego.papi.ColumnFormat valueOf(ColumnFormat columnFormat) {
        fuego.papi.ColumnFormatType columnFormatType;
        if (columnFormat == null || ColumnFormatType.DEFAULT.equals(columnFormat.getType())) {
            return null;
        }
        switch (columnFormat.getType()) {
            case DATE_CUSTOM: {
                columnFormatType = fuego.papi.ColumnFormatType.DATE_CUSTOM;
                break;
            }
            case DATE_FULL: {
                columnFormatType = fuego.papi.ColumnFormatType.DATE_FULL;
                break;
            }
            case DATE_LONG: {
                columnFormatType = fuego.papi.ColumnFormatType.DATE_LONG;
                break;
            }
            case DATE_MEDIUM: {
                columnFormatType = fuego.papi.ColumnFormatType.DATE_MEDIUM;
                break;
            }
            case DATE_SHORT: {
                columnFormatType = fuego.papi.ColumnFormatType.DATE_SHORT;
                break;
            }
            case DATE_TIME_FULL: {
                columnFormatType = fuego.papi.ColumnFormatType.DATE_TIME_FULL;
                break;
            }
            case DATE_TIME_LONG: {
                columnFormatType = fuego.papi.ColumnFormatType.DATE_TIME_LONG;
                break;
            }
            case DATE_TIME_MEDIUM: {
                columnFormatType = fuego.papi.ColumnFormatType.DATE_TIME_MEDIUM;
                break;
            }
            case DATE_TIME_SHORT: {
                columnFormatType = fuego.papi.ColumnFormatType.DATE_TIME_SHORT;
                break;
            }
            case NUMBER_CURRENCY: {
                columnFormatType = fuego.papi.ColumnFormatType.NUMBER_CURRENCY;
                break;
            }
            case NUMBER_CUSTOM: {
                columnFormatType = fuego.papi.ColumnFormatType.NUMBER_CUSTOM;
                break;
            }
            case NUMBER_DECIMAL: {
                columnFormatType = fuego.papi.ColumnFormatType.NUMBER_DECIMAL;
                break;
            }
            case NUMBER_INTEGER: {
                columnFormatType = fuego.papi.ColumnFormatType.NUMBER_INTEGER;
                break;
            }
            case NUMBER_PERCENT: {
                columnFormatType = fuego.papi.ColumnFormatType.NUMBER_PERCENT;
                break;
            }
            case TIME_FULL: {
                columnFormatType = fuego.papi.ColumnFormatType.TIME_FULL;
                break;
            }
            case TIME_LONG: {
                columnFormatType = fuego.papi.ColumnFormatType.TIME_LONG;
                break;
            }
            case TIME_MEDIUM: {
                columnFormatType = fuego.papi.ColumnFormatType.TIME_MEDIUM;
                break;
            }
            case TIME_SHORT: {
                columnFormatType = fuego.papi.ColumnFormatType.TIME_SHORT;
                break;
            }
            default: {
                columnFormatType = fuego.papi.ColumnFormatType.NUMBER_CUSTOM;
            }
        }
        return fuego.papi.ColumnFormat.getInstance(columnFormatType, columnFormat.getPattern());
    }

    public static fuego.papi.PresentationType valueOf(PresentationType presentationType) {
        switch (presentationType) {
            case ACTIVITY: {
                return fuego.papi.PresentationType.ACTIVITY;
            }
            case APPLICATIONS: {
                return fuego.papi.PresentationType.APPLICATIONS;
            }
            case ATTACHMENTS: {
                return fuego.papi.PresentationType.ATTACHMENTS;
            }
            case FOLDER: {
                return fuego.papi.PresentationType.FOLDER;
            }
            case INSTANCES: {
                return fuego.papi.PresentationType.INSTANCES;
            }
        }
        return fuego.papi.PresentationType.INSTANCES;
    }

    public static PresentationType valueOf(fuego.papi.PresentationType presentationType) {
        switch (presentationType) {
            case ACTIVITY: {
                return PresentationType.ACTIVITY;
            }
            case APPLICATIONS: {
                return PresentationType.APPLICATIONS;
            }
            case ATTACHMENTS: {
                return PresentationType.ATTACHMENTS;
            }
            case FOLDER: {
                return PresentationType.FOLDER;
            }
            case INSTANCES: {
                return PresentationType.INSTANCES;
            }
        }
        return PresentationType.INSTANCES;
    }

    public static fuego.papi.SearchScope valueOf(SearchScope searchScope) {
        return new fuego.papi.SearchScope(AdapterUtils.valueOf(searchScope.getParticipantScope()), AdapterUtils.valueOf(searchScope.getStatusScope()), searchScope.getActivityScope());
    }

    public static SearchScope valueOf(fuego.papi.SearchScope searchScope) {
        return new SearchScope(AdapterUtils.valueOf(searchScope.getParticipantScope()), AdapterUtils.valueOf(searchScope.getStatusScope()), searchScope.getActivityScope());
    }

    public static fuego.papi.ParticipantScope valueOf(ParticipantScope participantScope) {
        switch (participantScope) {
            case ALL: {
                return fuego.papi.ParticipantScope.ALL;
            }
            case PROCESS_ROLES: {
                return fuego.papi.ParticipantScope.PROCESS_ROLES;
            }
            case ALL_IN_ROLE: {
                return fuego.papi.ParticipantScope.ALL_IN_ROLE;
            }
            case PARTICIPANT: {
                return fuego.papi.ParticipantScope.PARTICIPANT;
            }
            case PARTICIPANT_ROLES: {
                return fuego.papi.ParticipantScope.PARTICIPANT_ROLES;
            }
        }
        return fuego.papi.ParticipantScope.PARTICIPANT_ROLES;
    }

    public static ParticipantScope valueOf(fuego.papi.ParticipantScope participantScope) {
        switch (participantScope) {
            case ALL: {
                return ParticipantScope.ALL;
            }
            case PROCESS_ROLES: {
                return ParticipantScope.PROCESS_ROLES;
            }
            case ALL_IN_ROLE: {
                return ParticipantScope.ALL_IN_ROLE;
            }
            case PARTICIPANT: {
                return ParticipantScope.PARTICIPANT;
            }
            case PARTICIPANT_ROLES: {
                return ParticipantScope.PARTICIPANT_ROLES;
            }
        }
        return ParticipantScope.PARTICIPANT_ROLES;
    }

    public static fuego.papi.StatusScope valueOf(StatusScope statusScope) {
        switch (statusScope) {
            case ABORTED_AND_COMPLETED: {
                return fuego.papi.StatusScope.ABORTED_AND_COMPLETED;
            }
            case ALL: {
                return fuego.papi.StatusScope.ALL;
            }
            case INPROCESS_AND_ABORTED: {
                return fuego.papi.StatusScope.INPROCESS_AND_ABORTED;
            }
            case INPROCESS_AND_COMPLETED: {
                return fuego.papi.StatusScope.INPROCESS_AND_COMPLETED;
            }
            case ONLY_ABORTED: {
                return fuego.papi.StatusScope.ONLY_ABORTED;
            }
            case ONLY_COMPLETED: {
                return fuego.papi.StatusScope.ONLY_COMPLETED;
            }
            case ONLY_INPROCESS: {
                return fuego.papi.StatusScope.ONLY_INPROCESS;
            }
        }
        return fuego.papi.StatusScope.ONLY_INPROCESS;
    }

    public static StatusScope valueOf(fuego.papi.StatusScope statusScope) {
        switch (statusScope) {
            case ABORTED_AND_COMPLETED: {
                return StatusScope.ABORTED_AND_COMPLETED;
            }
            case ALL: {
                return StatusScope.ALL;
            }
            case INPROCESS_AND_ABORTED: {
                return StatusScope.INPROCESS_AND_ABORTED;
            }
            case INPROCESS_AND_COMPLETED: {
                return StatusScope.INPROCESS_AND_COMPLETED;
            }
            case ONLY_ABORTED: {
                return StatusScope.ONLY_ABORTED;
            }
            case ONLY_COMPLETED: {
                return StatusScope.ONLY_COMPLETED;
            }
            case ONLY_INPROCESS: {
                return StatusScope.ONLY_INPROCESS;
            }
        }
        return StatusScope.ONLY_INPROCESS;
    }

    public static fuego.papi.Comparison valueOf(Comparison comparison) {
        switch (comparison) {
            case AFTER: {
                return fuego.papi.Comparison.AFTER;
            }
            case BEFORE: {
                return fuego.papi.Comparison.BEFORE;
            }
            case BEGIN_WITH: {
                return fuego.papi.Comparison.BEGIN_WITH;
            }
            case BETWEEN: {
                return fuego.papi.Comparison.BETWEEN;
            }
            case CONTAINS: {
                return fuego.papi.Comparison.CONTAINS;
            }
            case END_WITH: {
                return fuego.papi.Comparison.CONTAINS;
            }
            case GREATER_OR_EQUALS: {
                return fuego.papi.Comparison.GREATER_OR_EQUALS;
            }
            case GREATER_THAN: {
                return fuego.papi.Comparison.GREATER_THAN;
            }
            case IS: {
                return fuego.papi.Comparison.IS;
            }
            case IS_NOT: {
                return fuego.papi.Comparison.IS_NOT;
            }
            case IS_NOT_NULL: {
                return fuego.papi.Comparison.IS_NOT_NULL;
            }
            case IS_NULL: {
                return fuego.papi.Comparison.IS_NULL;
            }
            case LESS_OR_EQUALS: {
                return fuego.papi.Comparison.LESS_OR_EQUALS;
            }
            case LESS_THAN: {
                return fuego.papi.Comparison.LESS_THAN;
            }
            case NOT_BEGIN_WITH: {
                return fuego.papi.Comparison.NOT_BEGIN_WITH;
            }
            case NOT_BETWEEN: {
                return fuego.papi.Comparison.NOT_BETWEEN;
            }
            case NOT_CONTAINS: {
                return fuego.papi.Comparison.NOT_CONTAINS;
            }
            case NOT_END_WITH: {
                return fuego.papi.Comparison.NOT_END_WITH;
            }
        }
        return fuego.papi.Comparison.IS;
    }

    public static Comparison valueOf(fuego.papi.Comparison comparison) {
        switch (comparison) {
            case AFTER: {
                return Comparison.AFTER;
            }
            case BEFORE: {
                return Comparison.BEFORE;
            }
            case BEGIN_WITH: {
                return Comparison.BEGIN_WITH;
            }
            case BETWEEN: {
                return Comparison.BETWEEN;
            }
            case CONTAINS: {
                return Comparison.CONTAINS;
            }
            case END_WITH: {
                return Comparison.CONTAINS;
            }
            case GREATER_OR_EQUALS: {
                return Comparison.GREATER_OR_EQUALS;
            }
            case GREATER_THAN: {
                return Comparison.GREATER_THAN;
            }
            case IS: {
                return Comparison.IS;
            }
            case IS_NOT: {
                return Comparison.IS_NOT;
            }
            case IS_NOT_NULL: {
                return Comparison.IS_NOT_NULL;
            }
            case IS_NULL: {
                return Comparison.IS_NULL;
            }
            case LESS_OR_EQUALS: {
                return Comparison.LESS_OR_EQUALS;
            }
            case LESS_THAN: {
                return Comparison.LESS_THAN;
            }
            case NOT_BEGIN_WITH: {
                return Comparison.NOT_BEGIN_WITH;
            }
            case NOT_BETWEEN: {
                return Comparison.NOT_BETWEEN;
            }
            case NOT_CONTAINS: {
                return Comparison.NOT_CONTAINS;
            }
            case NOT_END_WITH: {
                return Comparison.NOT_END_WITH;
            }
        }
        return Comparison.IS;
    }

    public static ViewsGenerationType valueOf(fuego.papi.view.ViewsGenerationType viewGenerationType) {
        switch (viewGenerationType) {
            case BY_PROCESS: {
                return ViewsGenerationType.BY_PROCESS;
            }
            case BY_PROCESS_AND_ACTIVITY: {
                return ViewsGenerationType.BY_PROCESS_AND_ACTIVITY;
            }
            case UNIFIED_INBOX: {
                return ViewsGenerationType.UNIFIED_INBOX;
            }
        }
        return ViewsGenerationType.NONE;
    }

    public static fuego.papi.view.ViewsGenerationType valueOf(ViewsGenerationType viewGenerationType) {
        switch (viewGenerationType) {
            case BY_PROCESS: {
                return fuego.papi.view.ViewsGenerationType.BY_PROCESS;
            }
            case BY_PROCESS_AND_ACTIVITY: {
                return fuego.papi.view.ViewsGenerationType.BY_PROCESS_AND_ACTIVITY;
            }
            case UNIFIED_INBOX: {
                return fuego.papi.view.ViewsGenerationType.UNIFIED_INBOX;
            }
        }
        return fuego.papi.view.ViewsGenerationType.NONE;
    }

    public static VarDefinition valueOf(Variable variable) {
        if (variable.isDefault()) {
            return VarDefinition.getDefaultVarDefinition(variable.getId());
        }
        HashMap<String, String> lables = new HashMap<String, String>();
        for (Map.Entry<Locale, String> entry : variable.getLabels().entrySet()) {
            lables.put(entry.getKey().getLanguage(), entry.getValue());
        }
        return new VarDefinition(variable.getId(), variable.getKind(), variable.getMask(), variable.getSize(), variable.getFractionSize(), lables);
    }

    public static Variable valueOf(VarDefinition varDefinition) {
        Variable variable;
        if (varDefinition.isExternal()) {
            variable = Variable.create(varDefinition.getId(), varDefinition.getKind());
            variable.setSize(varDefinition.getSize(), varDefinition.getFractionSize());
            variable.setMask(varDefinition.getMask());
            for (Map.Entry<String, String> entry : varDefinition.getLabels().entrySet()) {
                Locale locale = null;
                if (entry.getKey() instanceof String) {
                    locale = new Locale(entry.getKey());
                } else if (entry.getKey() instanceof Locale) {
                    locale = (Locale)((Object)entry.getKey());
                }
                String label = null;
                if (entry.getValue() instanceof String) {
                    label = entry.getValue();
                }
                if (label == null || locale == null) continue;
                variable.setLabel(label, locale);
            }
        } else {
            variable = new DefaultVariable(varDefinition.getId(), varDefinition.getKind(), varDefinition.getSize(), varDefinition.getFractionSize(), varDefinition.getMask(), varDefinition.getMsg());
        }
        return variable;
    }
}

