/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view;

import oracle.bpm.view.FilterImpl;
import oracle.bpm.view.InstancesViewImpl;
import oracle.bpm.view.SearchScope;
import oracle.bpm.view.ViewImpl;
import oracle.bpm.view.ViewType;

public class ActivityViewImpl
extends InstancesViewImpl {
    private String activity;
    private int activityType;
    public static final String DEFAULT_PRESENTATION = "default_activity";
    static final long serialVersionUID = -8741757670456694300L;
    static final long serialCheck = 7226943878882129892L;

    public ActivityViewImpl(String id, String owner, String activity) {
        super(id, owner);
        if (activity != null) {
            this.activity = activity;
        }
    }

    public void setActivityName(String activityName) {
        this.activity = activityName;
    }

    public String getActivityName() {
        return this.activity;
    }

    public void setActivityType(int activityType) {
        this.activityType = activityType;
    }

    public int getActivityType() {
        return this.activityType;
    }

    @Override
    public FilterImpl getFilter() {
        FilterImpl copy = super.getFilter();
        copy.setSearchScope(new SearchScope(this.filter.getSearchScope().getParticipantScope(), this.filter.getSearchScope().getStatusScope(), this.activity));
        return copy;
    }

    @Override
    public ViewType getType() {
        return ViewType.ACTIVITY_INSTANCES;
    }

    @Override
    public ViewImpl copy() {
        ActivityViewImpl copy = (ActivityViewImpl)super.copy();
        copy.activity = this.activity;
        return copy;
    }

    @Override
    public String toString() {
        StringBuffer description = new StringBuffer(super.toString());
        description.append("\n");
        description.append("\tActivity Name '");
        description.append(this.activity);
        description.append("'\n");
        description.append("\tActivity Type '");
        description.append(this.activityType);
        description.append("'\n");
        return description.toString();
    }

    @Override
    protected String getDefaultPresentation() {
        return DEFAULT_PRESENTATION;
    }
}

