/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpm.lang.Literals;
import oracle.bpm.util.NameParser;

public class NetURL
extends NameParser {
    private List<Attribute> attributeList;
    private Map<String, Attribute> attributeMap = new HashMap<String, Attribute>();
    private String file_d;
    private String host_d;
    private String lastName_d;
    private String password_d;
    private int port_d = -1;
    private String protocol_d;
    private String subProtocol_d;
    private String user_d;
    private static final int PROTOCOL = 1;
    private static final int USER = 2;
    private static final int PASSWORD = 3;
    private static final int HOST = 4;
    private static final int PORT = 5;
    private static final int NAME = 6;
    private static final int VALUE = 7;
    private static final int SUB_PROTOCOL = 8;
    private static final int FILE = 9;
    private static final NameParser.R[][] RULES = new NameParser.R[][]{{new NameParser.R(null, "://", 7), new NameParser.R("://", null, 5)}, {new NameParser.R(null, "@", 2), new NameParser.R("@", null, 6), new NameParser.R(null, null, 6)}, {new NameParser.R(null, ":", -1, 2), new NameParser.R(":", null, -1, 3), new NameParser.R(null, null, -1, 2)}, {new NameParser.R(null, ",", 4), new NameParser.R(",", ",", 4), new NameParser.R(",", null, 4), new NameParser.R(null, null, 4)}, {new NameParser.R(null, "=", -1, 6), new NameParser.R("=", null, -1, 7)}, {new NameParser.R(null, "/", 1), new NameParser.R("/", "?", -1, 9, 8), new NameParser.R("/", "/", -1, 9), new NameParser.R("/", "=", -1, 6, 9), new NameParser.R("/", null, -1, 9), new NameParser.R(null, null, 1)}, {new NameParser.R(null, ":", -1, 4), new NameParser.R(":", null, -1, 5), new NameParser.R(null, null, -1, 4)}, {new NameParser.R(null, ":", -1, 1), new NameParser.R(":", null, -1, 8), new NameParser.R(null, null, -1, 1)}, {new NameParser.R("?", null, 3)}, {new NameParser.R("=", ",", -1, 7, 3), new NameParser.R("=", null, -1, 7)}};

    public NetURL() {
        super(RULES);
        this.attributeList = new ArrayList<Attribute>();
    }

    public NetURL(String url) {
        this();
        try {
            this.parse(url, 0);
        }
        catch (NameParser.ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public NetURL(URL url) {
        this(url.toString());
    }

    public static NetURL create(String url) {
        try {
            return new NetURL(url);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static NetURL create(URL url) {
        try {
            return new NetURL(url);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public Attribute getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    public Attribute getAttribute(int index) {
        return this.attributeList.get(index);
    }

    public void setAttributeValue(String name, String value) {
        Attribute attr = this.getAttribute(name);
        if (attr == null) {
            this.addAttribute(name, value);
        } else {
            attr.setValue(value);
        }
    }

    public String getAttributeValue(String name) {
        Attribute attr = this.getAttribute(name);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public String getFile() {
        return this.file_d;
    }

    public void setHost(String host) {
        this.host_d = host;
    }

    public String getHost() {
        return this.host_d;
    }

    public void setPassword(String password) {
        this.password_d = password;
    }

    public String getPassword() {
        return this.password_d;
    }

    public void setPort(int port) {
        this.port_d = port;
    }

    public int getPort() {
        return this.port_d;
    }

    public String getProtocol() {
        return this.protocol_d;
    }

    public void setUser(String user) {
        this.user_d = user;
    }

    public String getUser() {
        return this.user_d;
    }

    public void addAttribute(String name, String value) {
        Attribute attr = new Attribute(name, value);
        this.attributeMap.put(name, attr);
        this.attributeList.add(attr);
    }

    public Iterator attributeIterator() {
        final Iterator<Attribute> it = this.attributeList.iterator();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            public Object next() {
                return it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported");
            }
        };
    }

    public Attribute removeAttribute(int index) {
        Attribute attr = this.getAttribute(index);
        if (attr == null) {
            return null;
        }
        this.attributeMap.remove(attr.getName());
        this.attributeList.remove(index);
        return attr;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.protocol_d == null ? "unknown" : this.protocol_d);
        if (this.subProtocol_d != null) {
            buff.append(":");
            buff.append(this.subProtocol_d);
        }
        buff.append("://");
        if (this.user_d != null) {
            buff.append(this.user_d);
        }
        if (this.password_d != null) {
            buff.append(":");
            buff.append(this.password_d);
            if (this.host_d != null) {
                buff.append("@");
            }
        }
        if (this.host_d != null) {
            buff.append(this.host_d);
        }
        if (this.port_d != -1) {
            buff.append(":");
            buff.append(this.port_d);
        }
        Iterator it = this.attributeIterator();
        if (this.file_d != null) {
            buff.append("/");
            buff.append(this.file_d);
        }
        if (it.hasNext()) {
            if (this.file_d == null) {
                buff.append("/");
            } else {
                buff.append("?");
            }
        }
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            try {
                buff.append(URLEncoder.encode(attr.getName(), Literals.DEFAULT_ENCODING));
                buff.append("=");
                buff.append(URLEncoder.encode(attr.getValue(), Literals.DEFAULT_ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            if (!it.hasNext()) continue;
            buff.append(",");
        }
        return buff.toString();
    }

    @Override
    protected void doAction(int action, String name) {
        switch (action) {
            case 1: {
                this.protocol_d = name;
                break;
            }
            case 8: {
                this.subProtocol_d = name;
                break;
            }
            case 2: {
                this.user_d = name;
                break;
            }
            case 3: {
                this.password_d = name;
                break;
            }
            case 4: {
                this.host_d = name;
                break;
            }
            case 5: {
                try {
                    this.port_d = Integer.parseInt(name);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Port number is invalid. Please check the url.");
                }
            }
            case 9: {
                this.file_d = this.file_d == null ? name : this.file_d + "/" + name;
                break;
            }
            case 6: {
                this.lastName_d = name;
                break;
            }
            case 7: {
                if (this.lastName_d == null) {
                    throw new IllegalArgumentException("attribute name is null");
                }
                try {
                    this.addAttribute(URLDecoder.decode(this.lastName_d, Literals.DEFAULT_ENCODING).trim(), URLDecoder.decode(name, Literals.DEFAULT_ENCODING));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown action: " + action);
            }
        }
    }

    public class Attribute {
        private String name_d;
        private String value_d;

        Attribute(String name, String value) {
            this.name_d = name;
            this.value_d = value;
        }

        public void setName(String name) {
            Attribute attr = NetURL.this.getAttribute(name);
            if (attr != null) {
                NetURL.this.attributeMap.put(name, this);
            }
            this.name_d = name;
        }

        public String getName() {
            return this.name_d;
        }

        public void setValue(String value) {
            this.value_d = value;
        }

        public String getValue() {
            return this.value_d;
        }
    }
}

