/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.lang.reflect.InvocationTargetException;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.RuntimeExceptionShell;

public class MemberUtils {
    public static Object getAttribute(Object target, String signature) {
        return MemberUtils.get(null, target, signature, null);
    }

    public static Object getAttribute(Object target, String signature, String setter) {
        return MemberUtils.get(null, target, signature, setter);
    }

    public static Object getAttribute(Class clazz, String signature) {
        return MemberUtils.get(clazz, null, signature, null);
    }

    public static Object get(Class clazz, Object target, String signature, String setter) {
        Object ret;
        char type = signature.charAt(0);
        if (clazz == null && target == null) {
            int index = signature.indexOf("(");
            String fieldName = Character.toLowerCase(signature.charAt(4)) + signature.substring(5, index);
            throw new NullPointerException("The attribute " + fieldName + " is null, it must be initialized");
        }
        Class clazz2 = clazz = clazz == null ? target.getClass() : clazz;
        if (type == 'L') {
            clazz = MemberUtils.delegateCall(signature, clazz);
            signature = signature.substring(signature.indexOf(";") + 1);
            JavaClass javaClass = JavaClass.fromClass(clazz);
            try {
                ret = javaClass.invokeMethod(target, signature, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeExceptionShell(e, MemberUtils.msg(signature, null, target));
            }
            catch (InvocationTargetException e) {
                throw new RuntimeExceptionShell(e, MemberUtils.msg(signature, null, target));
            }
        } else {
            JavaClass<?> javaClass = JavaClass.fromClass(clazz);
            ret = javaClass.getAttributeValue(signature, setter, target);
        }
        return ret;
    }

    public static Class delegateCall(String signature, Class target) {
        String clazz = signature.substring(1, signature.indexOf(";"));
        ClassLoader loader = target.getClassLoader();
        if (loader == null) {
            loader = MemberUtils.class.getClassLoader();
        }
        try {
            target = loader.loadClass(clazz);
        }
        catch (ClassNotFoundException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Could not load the class " + clazz + ",Signature:" + signature);
            iae.initCause(e);
            throw iae;
        }
        return target;
    }

    private static String msg(String signature, Object value, Object target) {
        StringBuffer msg = new StringBuffer();
        msg.append("signature = ");
        msg.append(signature);
        msg.append(", value = ");
        if (value == null) {
            msg.append("null");
        } else {
            msg.append(value.toString());
            msg.append('(');
            msg.append(value.getClass().getName());
            msg.append(')');
        }
        msg.append(", target = ");
        if (target == null) {
            msg.append("null");
        } else {
            msg.append(target.toString());
            msg.append('(');
            msg.append(target.getClass().getName());
            msg.append(')');
        }
        return msg.toString();
    }
}

