/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.component.Component;
import oracle.bpm.connector.JavaLibrariesHelper;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.util.CatalogClassLoader;
import oracle.bpm.util.ObjectStreamReplacer;

public class FuegoObjectCatalog {
    private int catalogIN;
    private ClassLoader classLoader;
    private String directoryId;
    private ReferenceQueue<Object> referenceQueue;
    private final Map<String, ResourceReference> resourceCache;
    private static final ObjectStreamReplacer SERIAL_UID_REPLACER = new ObjectStreamReplacer();

    FuegoObjectCatalog(ClassLoader loader, int catalogIN, String directoryId) {
        this.classLoader = loader;
        this.catalogIN = catalogIN;
        this.directoryId = directoryId;
        this.referenceQueue = new ReferenceQueue();
        this.resourceCache = new HashMap<String, ResourceReference>();
    }

    public static ClassLoader createLoader(int catalogIN, String directoryId, File[] files) {
        URL[] url = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                url[i] = file.toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new Error("Unexpected exception", e);
            }
        }
        ClassLoader parent = FuegoObjectCatalog.parentForClassLoader();
        return new CatalogClassLoader(catalogIN, directoryId, url, parent);
    }

    public static Object instantiate(ClassLoader classLoader, String beanName) throws IOException, ClassNotFoundException {
        Object result = null;
        String serializedName = FuegoObjectCatalog.serializedName(beanName);
        InputStream in = FuegoObjectCatalog.openStream(serializedName, classLoader);
        IOException exception = null;
        if (in != null) {
            try {
                result = FuegoObjectCatalog.readRuntimeInfo(classLoader, in);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                in.close();
                exception = ex;
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
                in.close();
                throw ex;
            }
        }
        if (result == null) {
            result = FuegoObjectCatalog.newInstance(classLoader, beanName, exception);
        }
        return result;
    }

    public static FuegoObjectCatalog getFrom(ClassLoader classLoader) {
        FuegoObjectCatalog result = null;
        if (classLoader instanceof CatalogClassLoader) {
            CatalogClassLoader catalogLoader = (CatalogClassLoader)classLoader;
            result = catalogLoader.getCatalog();
        }
        return result;
    }

    public int getCatalogIN() {
        return this.catalogIN;
    }

    public String getDirectoryId() {
        return this.directoryId;
    }

    public Object instantiate(String beanName) throws IOException, ClassNotFoundException {
        return FuegoObjectCatalog.instantiate(this.classLoader, beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResource(String name) throws ClassNotFoundException, IOException {
        Object resource = null;
        Map<String, ResourceReference> map = this.resourceCache;
        synchronized (map) {
            ResourceReference value = this.resourceCache.get(name);
            if (value != null) {
                Reference ref = value;
                resource = ref.get();
            }
        }
        if (resource == null) {
            resource = FuegoObjectCatalog.instantiate(this.classLoader, name);
            map = this.resourceCache;
            synchronized (map) {
                if (!this.resourceCache.containsKey(name)) {
                    this.resourceCache.put(name, new ResourceReference(name, resource, this.referenceQueue));
                }
            }
        }
        return resource;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FuegoObjectCatalog(catalogIn: ");
        builder.append(this.getCatalogIN());
        builder.append(", directoryId: ");
        builder.append(this.getDirectoryId());
        builder.append(")");
        return builder.toString();
    }

    private static ClassLoader parentForClassLoader() {
        return Component.isRunningOnClientSide() ? FuegoObjectCatalog.class.getClassLoader() : JavaLibrariesHelper.getClassLoader();
    }

    private static Object newInstance(ClassLoader classLoader, String beanName, IOException previousException) throws IOException, ClassNotFoundException {
        Object result;
        Class<?> cl;
        try {
            cl = classLoader.loadClass(beanName);
        }
        catch (ClassNotFoundException ex) {
            if (previousException != null) {
                throw previousException;
            }
            throw ex;
        }
        try {
            result = cl.newInstance();
        }
        catch (Exception ex) {
            throw new ClassNotFoundException("" + cl + " : " + ex);
        }
        return result;
    }

    private static Object readRuntimeInfo(ClassLoader classLoader, InputStream in) throws IOException, ClassNotFoundException {
        byte[] data = StreamUtils.readBytes(in);
        try {
            return FuegoObjectCatalog.deserializeInfo(new ByteArrayInputStream(data), classLoader);
        }
        catch (InvalidClassException exc) {
            data = SERIAL_UID_REPLACER.replace(data);
            return FuegoObjectCatalog.deserializeInfo(new ByteArrayInputStream(data), classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object deserializeInfo(InputStream inputStream, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        RuntimeInfoStream rin = new RuntimeInfoStream(inputStream, classLoader);
        try {
            Object object = rin.readObject();
            return object;
        }
        finally {
            rin.close();
        }
    }

    private static String serializedName(String beanName) {
        String serializedName = beanName.replace('.', '/').concat(".ser");
        return serializedName;
    }

    private static InputStream openStream(final String serializedName, final ClassLoader loader) {
        InputStream in = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return loader.getResourceAsStream(serializedName);
            }
        });
        return in;
    }

    static {
        SERIAL_UID_REPLACER.addSubstitution(XObjectTypeDescription.ResourceValue.class.getName(), 5133566709499885586L, -2481154473843470830L);
        SERIAL_UID_REPLACER.build();
    }

    private static class RuntimeInfoStream
    extends ObjectInputStream {
        private ClassLoader loader;

        public RuntimeInfoStream(InputStream i, ClassLoader cLoader) throws IOException {
            super(i);
            this.loader = cLoader;
        }

        public Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            Class<?> clazz;
            String className = v.getName();
            if (className.equals("oracle.bpm.xobject.runtime.XORuntimeInfo")) {
                className = "oracle.bpm.xobject.XORuntimeInfo";
            } else if (className.startsWith("oracle.bpm.xobject.runtime.XORuntimeInfo$AttInfo")) {
                className = "oracle.bpm.xobject.XORuntimeInfo$AttInfo";
            }
            try {
                clazz = this.loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                clazz = super.resolveClass(v);
            }
            return clazz;
        }
    }

    private static class ResourceReference
    extends SoftReference<Object> {
        private Object key_d;

        public ResourceReference(Object key, Object referent, ReferenceQueue<Object> q) {
            super(referent, q);
            this.key_d = key;
        }

        public Object getKey() {
            return this.key_d;
        }
    }
}

