/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.util.FileException;
import oracle.bpm.util.ProgressMonitor;
import oracle.bpm.util.SystemInfo;
import org.jetbrains.annotations.Nullable;

public class FileUtils {
    private static final String JDK_HOME = System.getProperty("java.home") + File.separator + "..";
    private static int currentCount;
    private static int totalCount;
    public static final String SYSTEM_BASE_DIR = "fuego.user.dir";
    public static final String DEFAULT_SYSTEM_BASE_DIR = "user.dir";

    public static String getBootClassPath() {
        StringBuilder bootClassPath = new StringBuilder(System.getProperty("sun.boot.class.path"));
        if (SystemInfo.isSunJDK()) {
            bootClassPath.append((CharSequence)bootClassPath).append(File.pathSeparatorChar).append(JDK_HOME).append(File.separatorChar).append("lib/tools.jar");
        }
        return bootClassPath.toString();
    }

    public static String getCannonicalPath(String pathToFix, String referencePath) {
        File f = new File(referencePath);
        String file = pathToFix;
        if (file == null) {
            return null;
        }
        if (!f.isAbsolute()) {
            String myfile = File.separator.equals("\\") ? file.replace('/', '\\') : file.replace('\\', '/');
            String parent = new File(myfile).getParent();
            if (parent != null) {
                pathToFix = parent + '/' + pathToFix;
            }
        } else {
            return pathToFix;
        }
        f = new File(pathToFix);
        try {
            String canonicalPath = File.separator.equals("\\") ? f.getCanonicalPath().replace('/', '\\') : f.getCanonicalPath().replace('\\', '/');
            return canonicalPath;
        }
        catch (IOException ioe) {
            Log.logSevere(ioe);
            return null;
        }
    }

    public static FileFilter getExtFilter(final String extension) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().toLowerCase().endsWith(extension);
            }
        };
    }

    public static String getExtension(File file) {
        return FileUtils.getExtension(file.getName());
    }

    public static String getName(File file) {
        String fileExtension = FileUtils.getExtension(file);
        return file.getName().replace(fileExtension, "");
    }

    public static String getExtension(String fileName) {
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos == -1) {
            return null;
        }
        return fileName.substring(dotPos, fileName.length());
    }

    public static FileFilter getExtensionFilter(final String extension) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().toLowerCase().endsWith(extension);
            }

            public String getDescription() {
                String extensionStr = extension.replaceAll("\\.", "");
                return extensionStr.toUpperCase() + " (*." + extensionStr + ')';
            }
        };
    }

    public static List<File> getFilesRecursively(File directory, FileFilter filter, boolean includeDirectories) {
        return FileUtils.getFilesRecursively(directory, filter, includeDirectories, true);
    }

    public static List<File> getFilesRecursively(File directory, boolean includeDirectories) {
        return FileUtils.getFilesRecursively(directory, null, includeDirectories, true);
    }

    public static List<File> getFilesRecursively(File directory, FileFilter filter, boolean includeDirectories, boolean includeRootDirectory) {
        ArrayList<File> filesList = new ArrayList<File>();
        if (includeDirectories && includeRootDirectory) {
            filesList.add(directory);
        }
        if (directory.isDirectory()) {
            for (File innerFile : directory.listFiles(filter)) {
                if (innerFile.isDirectory()) {
                    filesList.addAll(FileUtils.getFilesRecursively(innerFile, filter, includeDirectories, true));
                    continue;
                }
                filesList.add(innerFile);
            }
        }
        return filesList;
    }

    public static List<File> getFilesRecursively(File directory, FileFilter filter) {
        return FileUtils.getFilesRecursively(directory, filter, true);
    }

    public static File[] getFilesRecursivelyAsArray(File directory, FileFilter filter, boolean includeDirectories, boolean includeRootDirectory) {
        return FileUtils.toFileArray(FileUtils.getFilesRecursively(directory, filter, includeDirectories, includeRootDirectory));
    }

    public static File[] getFilesRecursivelyAsArray(File directory, FileFilter filter, boolean includeDirectories) {
        return FileUtils.toFileArray(FileUtils.getFilesRecursively(directory, filter, includeDirectories));
    }

    public static boolean _dirCopy(File source, File destination, @Nullable FileFilter ext, ProgressMonitor monitor, boolean includePassedDir) {
        File[] files;
        if (includePassedDir) {
            File file = new File(destination, source.getName());
            file.mkdirs();
            return FileUtils._dirCopy(source, file, ext, monitor, false);
        }
        if (!source.isDirectory()) {
            return false;
        }
        if (!destination.exists() && !destination.mkdirs()) {
            return false;
        }
        if (!destination.isDirectory()) {
            return false;
        }
        for (File file : files = source.listFiles(ext)) {
            File newFile = new File(destination, file.getName());
            if (!file.isDirectory()) {
                if (monitor != null) {
                    monitor.progress(++currentCount * 100 / totalCount);
                    monitor.info(CoreMsg.COPYING_INTO(file.getName(), newFile.getParent()));
                }
                FileUtils.fileCopy(file, newFile);
                continue;
            }
            FileUtils._dirCopy(file, newFile, ext, monitor, includePassedDir);
        }
        return true;
    }

    public static boolean canWriteFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.isFile()) {
            return file.exists() ? FileUtils.canWriteFile(file.getParentFile()) : file.canWrite();
        }
        if (file.isDirectory()) {
            File tmpFile = file.exists() ? new File(file, new Random().nextInt() + "tmp") : file;
            try {
                tmpFile.createNewFile();
                tmpFile.delete();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return FileUtils.canWriteFile(file.getParentFile());
    }

    public static File changeExtension(File file, String extension) {
        String fileName = file.getName();
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos != -1) {
            fileName = fileName.substring(0, dotPos);
        }
        if (Str.isEmpty(extension)) {
            return new File(file.getParentFile(), fileName);
        }
        if (extension.startsWith(".")) {
            return new File(file.getParentFile(), fileName + extension);
        }
        return new File(file.getParentFile(), fileName + '.' + extension);
    }

    public static File changePath(File path, File pathToBeRemoved, File pathToBeAdded) throws FileException {
        try {
            return FileUtils.changePath(path.getCanonicalPath(), pathToBeRemoved.getCanonicalPath(), pathToBeAdded.getCanonicalPath());
        }
        catch (IOException exc) {
            Log.logWarning(exc);
            return null;
        }
    }

    public static File changePathAndExtension(File newPath, File file, String extension) {
        return new File(newPath, FileUtils.changeExtension(file, extension).getName());
    }

    public static boolean copyFileOrDirectory(File source, File destination) {
        return FileUtils.copyFileOrDirectory(source, destination, null);
    }

    public static boolean copyFileOrDirectory(File source, File destination, @Nullable FileFilter filter) {
        boolean successful = false;
        if (source.isDirectory()) {
            successful = FileUtils._dirCopy(source, destination, filter, null, false);
        } else {
            boolean accepted;
            boolean bl = accepted = filter == null || filter.accept(source);
            if (accepted) {
                successful = FileUtils.fileCopy(source, !destination.isDirectory() ? destination : new File(destination, source.getName()));
            }
        }
        return successful;
    }

    public static void copyFiles(File[] filesToCopy, File destination, @Nullable FileFilter filter) {
        if (filesToCopy != null) {
            for (File jspToCopy : filesToCopy) {
                if (jspToCopy.isDirectory()) continue;
                FileUtils.copyFileOrDirectory(jspToCopy, destination, filter);
            }
        }
    }

    public static int countFiles(File source, FileFilter ext) {
        currentCount = 0;
        FileUtils._countFiles(source, ext);
        return currentCount;
    }

    public static void delete(File file) throws FileException {
        if (file.isDirectory()) {
            if (!FileUtils.deleteDirectory(file)) {
                throw new FileException(LibMsg.FE_0005(file));
            }
            return;
        }
        if (!file.delete()) {
            throw new FileException(LibMsg.FE_0005(file));
        }
    }

    public static boolean deleteDirectory(File dirToDelete) {
        return FileUtils.deleteDirectory(dirToDelete, true);
    }

    public static boolean deleteDirectory(File dirToDelete, boolean delDir) {
        boolean result = true;
        File[] content = dirToDelete.listFiles();
        if (content != null) {
            for (File file : content) {
                result &= FileUtils.deleteDirectory(file, delDir);
            }
        } else if (dirToDelete.isFile()) {
            delDir = true;
        } else if (!dirToDelete.exists()) {
            return false;
        }
        if (delDir) {
            result &= dirToDelete.delete();
        }
        return result;
    }

    public static boolean dirCopy(File source, File destination) {
        return FileUtils.dirCopy(source, destination, null);
    }

    public static boolean dirCopy(File source, File destination, FileFilter ext) {
        return FileUtils.dirCopy(source, destination, ext, null);
    }

    public static boolean dirCopy(File source, File destination, FileFilter ext, ProgressMonitor monitor) {
        totalCount = FileUtils.countFiles(source, ext);
        currentCount = 0;
        return FileUtils._dirCopy(source, destination, ext, monitor, false);
    }

    public static File eraseExtension(File file) {
        return FileUtils.changeExtension(file, null);
    }

    public static String removeExtension(File file, String extension) {
        if (file.getName().lastIndexOf(extension) != -1) {
            return file.getName().substring(0, file.getName().lastIndexOf(extension));
        }
        return file.getName();
    }

    public static String removeExtension(File file) {
        return FileUtils.removeExtension(file.getName());
    }

    public static String removeExtension(String fileName) {
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos != -1) {
            fileName = fileName.substring(0, dotPos);
        }
        return fileName;
    }

    public static boolean fileCopy(String source, String destination) {
        return FileUtils.fileCopy(new File(source), new File(destination));
    }

    public static boolean fileCopy(File source, File destination) {
        FileInputStream in;
        try {
            in = new FileInputStream(source);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        if (!FileUtils.fileCopy((InputStream)in, destination)) {
            return false;
        }
        long time = source.lastModified();
        if (time > 0L) {
            destination.setLastModified(time);
        }
        return true;
    }

    public static boolean fileCopy(InputStream source, String destination) {
        return FileUtils.fileCopy(source, new File(destination));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fileCopy(InputStream source, File destination) {
        try {
            try {
                FileOutputStream out = new FileOutputStream(destination);
                try {
                    StreamUtils.copy(source, out);
                }
                finally {
                    out.close();
                }
            }
            finally {
                source.close();
            }
            return true;
        }
        catch (IOException exc) {
            Log.logDebug(exc);
            return false;
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println("makePathRelativeTo(" + args[0] + ", " + args[1] + ") = " + FileUtils.makePathRelativeTo(args[0], args[1]));
    }

    public static String makePathRelativeTo(String pathToFix, String referencePath) throws IOException {
        File referenceDir = new File(referencePath).getCanonicalFile();
        referencePath = referenceDir.isDirectory() ? referenceDir.getPath() : referenceDir.getParent();
        if (!(pathToFix = new File(pathToFix).getCanonicalPath()).startsWith(referencePath)) {
            throw new IllegalArgumentException(pathToFix + " doesn't start with " + referencePath);
        }
        return pathToFix.substring(referencePath.length() + 1);
    }

    public static byte[] readBytes(File file) throws IOException {
        return StreamUtils.readBytes(new FileInputStream(file));
    }

    public static String readFile(File file, String charsetName) throws IOException {
        StringWriter stringWriter = new StringWriter();
        FileUtils.readFile(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName)), stringWriter);
        return stringWriter.toString();
    }

    public static String readUTF8File(File file) throws IOException {
        return FileUtils.readFile(file, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readFile(BufferedReader br, Writer writer) throws IOException {
        try {
            String line = br.readLine();
            if (line != null) {
                writer.append(line);
                while ((line = br.readLine()) != null) {
                    writer.append('\n').append(line);
                }
            }
        }
        catch (Throwable throwable) {
            StreamUtils.close(br, writer);
            throw throwable;
        }
        StreamUtils.close(br, writer);
    }

    public static void rename(File original, File destination) throws FileException {
        if (!original.renameTo(destination)) {
            throw new FileException(LibMsg.FE_0004(original.getAbsolutePath(), destination.getAbsolutePath()));
        }
    }

    public static File changeFileName(File file, String name) {
        String extension = FileUtils.getExtension(file);
        return new File(file.getParentFile(), name + extension);
    }

    public static File[] toFileArray(List<File> fileList) {
        return fileList.toArray(new File[fileList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFile(InputStream is, String destPath) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipFile = new ZipInputStream(is);
        while ((zipEntry = zipFile.getNextEntry()) != null) {
            String fileName = zipEntry.getName();
            File toWriteFile = new File(destPath, fileName);
            if (zipEntry.isDirectory()) {
                toWriteFile.mkdirs();
                continue;
            }
            toWriteFile.getParentFile().mkdirs();
            FileOutputStream toWrite = new FileOutputStream(toWriteFile);
            try {
                StreamUtils.copy(zipFile, toWrite);
            }
            finally {
                toWrite.close();
            }
        }
        zipFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytes(File file, byte[] bytes) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            fos.write(bytes);
        }
        catch (Throwable throwable) {
            StreamUtils.close(fos);
            throw throwable;
        }
        StreamUtils.close(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(File file, String content) throws IOException {
        FileWriter writer = new FileWriter(file);
        try {
            writer.write(content);
        }
        catch (Throwable throwable) {
            StreamUtils.close(writer);
            throw throwable;
        }
        StreamUtils.close(writer);
    }

    public static void zipDirectory(String dir, String zipfile) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfile));
        FileUtils.zipDirectoryInternal(dir, new File(dir), out);
        out.close();
    }

    public static void dirCopy(File source, File targetDir, boolean includePassedDir, @Nullable FileFilter ext) {
        FileUtils._dirCopy(source, targetDir, ext, null, includePassedDir);
    }

    public static void dirCopy(File source, File targetDir, boolean includePassedDir) {
        FileUtils.dirCopy(source, targetDir, includePassedDir, null);
    }

    public static String getCannonicalPath(String fullPath) {
        if (fullPath == null) {
            return fullPath;
        }
        File file = new File(fullPath);
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException ignore) {
            Log.logWarning(ignore);
        }
        return file.getAbsolutePath();
    }

    public static void createFoldersIfNotExists(File ... folders) {
        for (File folder : folders) {
            if (folder.exists()) continue;
            folder.mkdirs();
        }
    }

    public static String createFoldersIfNotExists(String folderPath) {
        File tmpDirFile = new File(folderPath);
        if (!tmpDirFile.exists()) {
            tmpDirFile.mkdir();
        }
        return tmpDirFile.getPath();
    }

    public static boolean isWritableDir(String directory) {
        File dirFile = directory != null ? new File(directory) : null;
        return dirFile != null && dirFile.isDirectory() && dirFile.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeFile(InputStream io, String fileName) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileName);
        try {
            StreamUtils.copy(io, fos);
        }
        finally {
            fos.close();
        }
        return new File(fileName);
    }

    public static List<String> getParts(File file) {
        if (file.getParent() == null || file.getParentFile() != null && "".equals(file.getParentFile().getName())) {
            ArrayList<String> parts = new ArrayList<String>();
            parts.add(file.getName());
            return parts;
        }
        List<String> parts = FileUtils.getParts(file.getParentFile());
        parts.add(file.getName());
        return parts;
    }

    public static String removeExtension(String fileName, String extension) {
        int dotPos = fileName.lastIndexOf(extension);
        if (dotPos != -1) {
            fileName = fileName.substring(0, dotPos);
        }
        return fileName;
    }

    private static void _countFiles(File source, FileFilter ext) {
        File[] files;
        File[] fileArray = files = ext == null ? source.listFiles() : source.listFiles(ext);
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.isDirectory()) {
                ++currentCount;
                continue;
            }
            FileUtils._countFiles(file, ext);
        }
    }

    private static File changePath(String path, String pathToBeRemoved, String pathToBeAdded) throws FileException {
        if (path.indexOf(pathToBeRemoved) != 0) {
            throw new FileException(LibMsg.FE_0003(path, pathToBeRemoved));
        }
        return new File(pathToBeAdded, path.substring(pathToBeRemoved.length() + 1, path.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipDirectoryInternal(String baseDir, File d, ZipOutputStream out) throws IOException {
        for (String element : d.list()) {
            File f = new File(d, element);
            if (f.isDirectory()) {
                FileUtils.zipDirectoryInternal(baseDir, f, out);
                continue;
            }
            String fileName = f.getPath().substring(baseDir.length() + 1, f.getPath().length());
            ZipEntry entry = new ZipEntry(fileName);
            out.putNextEntry(entry);
            FileInputStream in = new FileInputStream(f);
            try {
                StreamUtils.copy(in, out);
            }
            finally {
                in.close();
            }
        }
    }
}

