/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import oracle.bpm.http.AbstractHttpCommand;
import oracle.bpm.http.HttpCommandServer;
import oracle.bpm.http.HttpRequest;
import oracle.bpm.http.HttpResponse;
import oracle.bpm.lang.FuegoClassLoader;
import oracle.bpm.lang.Str;
import oracle.bpm.util.ObjectWatch;
import oracle.bpm.util.StringTokenizer;
import oracle.bpm.util.SystemInfo;

public class Dump {
    private static OutputWatch stdOutput_sd;
    private static OutputWatch stdError_sd;
    private static String spaces;
    private static final String DEFAULT_PREFIX = "    ";
    private static final String GROUP = " virtual machine environmnet";

    public static String all() {
        StringBuffer buffer = new StringBuffer(4096);
        buffer.append(Dump.separator("date"));
        buffer.append(Dump.date() + "\n");
        buffer.append(Dump.separator("local host"));
        buffer.append(Dump.localhost() + "\n");
        buffer.append(Dump.separator("classpath"));
        buffer.append(Dump.classpath());
        buffer.append(Dump.separator("jars"));
        buffer.append(Dump.jars());
        buffer.append(Dump.separator("packages currently known for the caller's class loader."));
        buffer.append(Dump.packages());
        buffer.append(Dump.separator("threads"));
        buffer.append(Dump.threads(false));
        buffer.append(Dump.separator("properties"));
        buffer.append(Dump.properties());
        buffer.append(Dump.separator("memory"));
        buffer.append(Dump.memory());
        buffer.append(Dump.separator("security manager"));
        buffer.append(Dump.securitymanager());
        buffer.append(Dump.separator("classloaders"));
        buffer.append(Dump.classloaders());
        buffer.append(Dump.separator("jdbc"));
        buffer.append(Dump.jdbc(false));
        buffer.append(Dump.separator("locale"));
        buffer.append(Dump.locale());
        buffer.append(Dump.separator("available locales"));
        buffer.append(Dump.locale());
        return buffer.toString();
    }

    public static String classloaders() {
        Map<ClassLoader, String> loaders = FuegoClassLoader.getRegisteredClassLoaders();
        StringBuilder buffer = new StringBuilder(256);
        for (ClassLoader loader : loaders.keySet()) {
            buffer.append(Dump.minlength(loader.getClass().getName(), 35));
            buffer.append(" : ");
            buffer.append(loader.toString()).append("\n");
        }
        return buffer.toString();
    }

    public static String classpath() {
        String classpath = System.getProperty("java.class.path");
        StringBuffer buffer = new StringBuffer(256);
        StringTokenizer paths = new StringTokenizer(classpath, File.pathSeparator);
        while (paths.hasMoreTokens()) {
            buffer.append(paths.nextToken() + "\n");
        }
        return buffer.toString();
    }

    public static String classsource(String name) {
        try {
            Class<?> cl = Class.forName(name);
            return Dump.classsource(cl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static String classsource(Class cl) {
        String name = cl.getName();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            name = name.substring(index + 1);
        }
        URL url = cl.getResource(name + ".class");
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("source      : " + String.valueOf(url) + "\n");
        buffer.append("classloader : " + cl.getClassLoader() + "\n");
        return buffer.toString();
    }

    public static String date() {
        Date date = new Date(System.currentTimeMillis());
        return date.toString();
    }

    public static String fields(Class cl) {
        StringBuffer buffer = new StringBuffer();
        Field[] fields = cl.getFields();
        for (int i = 0; i < fields.length; ++i) {
            buffer.append(fields[i].toString() + "\n");
        }
        return buffer.toString();
    }

    public static boolean isHttpDebuggerRunning() {
        if (!SystemInfo.isDebuggingMode()) {
            return false;
        }
        HttpCommandServer server = HttpCommandServer.getDefault();
        return server.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String jars() {
        String classpath = System.getProperty("java.class.path");
        StringBuffer buffer = new StringBuffer(1024);
        StringTokenizer paths = new StringTokenizer(classpath, File.pathSeparator);
        while (paths.hasMoreTokens()) {
            String jar = paths.nextToken();
            if (!jar.endsWith(".jar") && !jar.endsWith(".zip")) continue;
            buffer.append("jar: " + jar);
            File file = new File(jar);
            if (!file.exists()) {
                buffer.append(" [FILE NOT EXISTS!]\n");
            } else if (jar.endsWith(".jar")) {
                buffer.append("\n");
                try {
                    JarFile jarFile = null;
                    try {
                        jarFile = new JarFile(jar);
                        Manifest manifest = jarFile.getManifest();
                        if (manifest != null) {
                            Attributes attributes = manifest.getMainAttributes();
                            for (Map.Entry entry : attributes.entrySet()) {
                                String name = String.valueOf(entry.getKey());
                                String value = String.valueOf(entry.getValue());
                                if (name.length() < 25) {
                                    name = Str.pad(name, 25);
                                }
                                buffer.append("  " + name);
                                buffer.append(" : ");
                                buffer.append(value);
                                buffer.append('\n');
                            }
                        }
                    }
                    finally {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                }
                catch (IOException e) {
                    buffer.append(e.toString());
                }
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static String jdbc() {
        return Dump.jdbc(true);
    }

    public static String jdbc(boolean html) {
        StringBuffer buffer = new StringBuffer(256);
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            String name = driver.getClass().getName();
            if (html) {
                name = ObjectWatch.getDefault().getId(driver, "jdbc", name);
            }
            buffer.append("driver class  : " + name + "\n");
            buffer.append("major version : " + driver.getMajorVersion() + "\n");
            buffer.append("minor version : " + driver.getMinorVersion() + "\n");
            buffer.append("jdbcCompliant : " + driver.jdbcCompliant() + "\n\n");
        }
        return buffer.toString();
    }

    public static String locale() {
        StringBuffer buffer = new StringBuffer(256);
        Locale current = Locale.getDefault();
        buffer.append(Dump.locale(current));
        return buffer.toString();
    }

    public static String localhost() {
        StringBuffer buffer = new StringBuffer(128);
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            buffer.append("host name    : " + localhost.getHostName() + "\n");
            buffer.append("host address : " + localhost.getHostAddress() + "\n");
        }
        catch (UnknownHostException e) {
            buffer.append(e.toString());
        }
        return buffer.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 1) {
            Dump.startServer(Integer.parseInt(args[0]));
            while (true) {
                Thread.sleep(2000L);
            }
        }
        System.out.println(Dump.all());
        System.out.println(Dump.separator("class source"));
        System.out.println(Dump.classsource(Dump.class));
    }

    public static String memory() {
        StringBuffer buffer = new StringBuffer(256);
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        long used = total - free;
        BigDecimal totalMB = new BigDecimal((double)total / 1024.0 / 1024.0);
        totalMB = totalMB.setScale(1, 4);
        BigDecimal usedMB = new BigDecimal((double)used / 1024.0 / 1024.0);
        usedMB = usedMB.setScale(1, 4);
        BigDecimal freeMB = new BigDecimal((double)free / 1024.0 / 1024.0);
        freeMB = freeMB.setScale(1, 4);
        buffer.append("Total memory : " + totalMB + "MB\n");
        buffer.append("Used memory  : " + usedMB + "MB\n");
        buffer.append("Free memory  : " + freeMB + "MB\n");
        return buffer.toString();
    }

    public static String memoryHtml() {
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        long used = total - free;
        BigDecimal usedPercent = new BigDecimal((double)used / (double)total * 100.0);
        usedPercent = usedPercent.setScale(1, 4);
        BigDecimal freePercent = new BigDecimal(100).subtract(usedPercent);
        freePercent = freePercent.setScale(1, 4);
        BigDecimal totalMB = new BigDecimal((double)total / 1024.0 / 1024.0);
        totalMB = totalMB.setScale(1, 4);
        BigDecimal usedMB = new BigDecimal((double)used / 1024.0 / 1024.0);
        usedMB = usedMB.setScale(1, 4);
        BigDecimal freeMB = new BigDecimal((double)free / 1024.0 / 1024.0);
        freeMB = freeMB.setScale(1, 4);
        StringBuffer buffer = new StringBuffer(512);
        buffer.append("Total memory : ");
        buffer.append(totalMB);
        buffer.append("MB\nUsed memory  : ");
        buffer.append(usedMB);
        buffer.append("MB\nFree memory  : ");
        buffer.append(freeMB);
        buffer.append("MB\n\n");
        buffer.append("<table border=0 width=50%><tr>");
        buffer.append("<td bgcolor=bbbbee width=");
        buffer.append(usedPercent);
        buffer.append("%>");
        buffer.append(usedPercent);
        buffer.append('%');
        buffer.append("</td>");
        buffer.append("<td bgcolor=ddddee align=right>");
        buffer.append(freePercent);
        buffer.append('%');
        buffer.append("</td></tr></table><table border=0 width=50%><tr>");
        buffer.append("<td width=50%>used</td>");
        buffer.append("<td align=right width=50%>free</td></tr></table>");
        return buffer.toString();
    }

    public static String methods(Class cl) {
        StringBuffer buffer = new StringBuffer();
        Method[] methods = cl.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            buffer.append(methods[i].toString() + "\n");
        }
        return buffer.toString();
    }

    public static String packages() {
        StringBuffer buffer = new StringBuffer(512);
        Package[] packages = Package.getPackages();
        for (int i = 0; i < packages.length; ++i) {
            buffer.append("package: " + packages[i].getName() + "\n");
        }
        return buffer.toString();
    }

    public static String properties() {
        StringBuffer buffer = new StringBuffer(1024);
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String name = entry.getKey().toString();
            if (name.length() < 26) {
                name = Str.pad(name, 26);
            }
            buffer.append(name);
            buffer.append(" : ");
            buffer.append(String.valueOf(entry.getValue()));
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public static void registerCommands() {
        Dump.registerCommands(HttpCommandServer.getDefault());
    }

    public static void registerCommands(HttpCommandServer server) {
        try {
            server.register(new DumpCommand("all", "Full environment"));
            server.register(new DumpCommand("jdbc", "Registered jdbc drivers"));
            server.register(new DumpCommand("locale", "Current locale"));
            server.register(new DumpCommand("localhost", "localhost"));
            server.register(new DumpCommand("memory", "Memory usage"));
            server.register(new DumpCommand("packages", "Loaded packages"));
            server.register(new DumpCommand("threads", "Threads"));
            server.register(new DumpCommand("classpath", "Classpath"));
            server.register(new DumpCommand("date", "Current Date"));
            server.register(new DumpCommand("jars", "Loaded Jars"));
            server.register(new DumpCommand("properties", "System properties"));
            server.register(new DumpCommand("stdoutput", "Standard Output (Last 32K)"));
            server.register(new DumpCommand("stderror", "Standard Error (Last 32K)"));
            ClassLoader system = ClassLoader.getSystemClassLoader();
            FuegoClassLoader.registerClassLoader(system);
            Map<ClassLoader, String> loaders = FuegoClassLoader.getRegisteredClassLoaders();
            ObjectWatch watch = new ObjectWatch("classloaders", "Class Loaders", loaders);
            watch.setGroup(GROUP);
            server.register(watch);
            SecurityManager sm = System.getSecurityManager();
            watch = new ObjectWatch("securitymanager", "Security Manager", sm);
            watch.setGroup(GROUP);
            server.register(watch);
            Dump.replaceStdIO();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public static String securitymanager() {
        StringBuffer buffer = new StringBuffer(128);
        SecurityManager mgr = System.getSecurityManager();
        if (mgr == null) {
            buffer.append("There isn't a security manager.\n");
        } else {
            buffer.append("security manager     : " + mgr + "\n");
            buffer.append("security context     : " + mgr.getSecurityContext() + "\n");
            buffer.append("default thread group : " + mgr.getThreadGroup() + "\n");
        }
        return buffer.toString();
    }

    public static void startHttpDebugger(int port) {
        if (!SystemInfo.isDebuggingMode()) {
            return;
        }
        Dump.registerCommands();
        HttpCommandServer server = HttpCommandServer.getDefault();
        try {
            server.start(port);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static String stderror() {
        if (stdError_sd != null) {
            return stdError_sd.getLastOutput();
        }
        return "Standard error not available";
    }

    public static String stdoutput() {
        if (stdOutput_sd != null) {
            return stdOutput_sd.getLastOutput();
        }
        return "Standard output not available";
    }

    public static String threads() {
        return Dump.threads(true);
    }

    public static String threads(boolean html) {
        ThreadGroup current = Thread.currentThread().getThreadGroup();
        while (current.getParent() != null) {
            current = current.getParent();
        }
        return Dump.threads(current, "", html);
    }

    private static String locale(Locale locale) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(" country  : " + locale.getCountry());
        buffer.append(" (" + locale.getDisplayCountry() + ")\n");
        buffer.append(" language : " + locale.getLanguage());
        buffer.append(" (" + locale.getDisplayLanguage() + ")\n");
        buffer.append(" variant  : " + locale.getVariant());
        buffer.append(" (" + locale.getDisplayVariant() + ")\n");
        return buffer.toString();
    }

    private static String minlength(String text, int length) {
        if (text.length() < length) {
            text = text + Dump.spaces(length - text.length());
        }
        return text;
    }

    private static String prefix(String text, String prefix) {
        return Str.replace(prefix + text, "\n", "\n" + prefix);
    }

    private static void replaceStdIO() {
        if (stdOutput_sd == null) {
            stdOutput_sd = new OutputWatch(System.out);
            PrintStream out = new PrintStream(stdOutput_sd, true);
            System.setOut(out);
            stdError_sd = new OutputWatch(System.err);
            PrintStream err = new PrintStream(stdError_sd, true);
            System.setErr(err);
        }
    }

    private static String separator(String title) {
        int length = 80 - title.length() - 2;
        return "\n" + Str.valueOf('-', length / 2) + " " + title + " " + Str.valueOf('-', length / 2) + "\n\n";
    }

    private static String spaces(int count) {
        if (spaces.length() < count) {
            spaces = spaces + " ";
            return Dump.spaces(count);
        }
        return spaces.substring(0, count);
    }

    private static void startServer(int port) throws IOException {
        HttpCommandServer server = new HttpCommandServer(port);
        Dump.registerCommands(server);
        server.start();
        System.out.println("listening on port: " + server.getPort());
    }

    private static String threads(ThreadGroup root, String prefix, boolean html) {
        StringBuffer buffer = new StringBuffer(512);
        String groupname = root.getName();
        if (html) {
            groupname = ObjectWatch.getDefault().getId(root, "thread", groupname);
        }
        groupname = Dump.minlength(groupname, 15);
        buffer.append("(");
        buffer.append("ThreadGroup : " + groupname);
        if (root.isDaemon()) {
            buffer.append(" [Daemon]");
        }
        if (root.isDestroyed()) {
            buffer.append(" [Destroyed]");
        }
        buffer.append(" [MaxPriority : " + root.getMaxPriority() + "]\n");
        Thread[] threads = new Thread[root.activeCount()];
        int count = root.enumerate(threads, false);
        for (int i = 0; i < count; ++i) {
            if (threads[i].getThreadGroup() != root) continue;
            buffer.append(Dump.threads(threads[i], DEFAULT_PREFIX, html));
        }
        ThreadGroup[] groups = new ThreadGroup[root.activeGroupCount()];
        count = root.enumerate(groups, false);
        for (int i = 0; i < count; ++i) {
            buffer.append(Dump.threads(groups[i], DEFAULT_PREFIX, html));
        }
        buffer.append(")");
        return Dump.prefix(buffer.toString(), prefix) + "\n";
    }

    private static String threads(Thread thread, String prefix, boolean html) {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append("(");
        String name = thread.getName();
        if (html) {
            name = ObjectWatch.getDefault().getId(thread, "thread", name);
        }
        name = Dump.minlength(name, 20);
        buffer.append("Thread : " + name);
        if (thread.isAlive()) {
            buffer.append(" [Alive]");
        }
        if (thread.isDaemon()) {
            buffer.append(" [Daemon]");
        }
        if (thread.isInterrupted()) {
            buffer.append(" [Interrupted]");
        }
        buffer.append(" [Priority : " + thread.getPriority() + "]");
        buffer.append(")");
        return Dump.prefix(buffer.toString(), prefix) + "\n";
    }

    static {
        spaces = " ";
    }

    static class OutputWatch
    extends OutputStream {
        private StringBuffer buffer = new StringBuffer();
        private OutputStream out;
        private static final int BLOCK_SIZE = 2048;
        private static final int MAX_LENGTH = 32768;

        OutputWatch(OutputStream out) {
            this.out = out;
        }

        public synchronized String getLastOutput() {
            return this.buffer.toString();
        }

        @Override
        public synchronized void write(byte[] b) throws IOException {
            this.out.write(b);
            this.buffer.append(new String(b));
            if (this.buffer.length() > 32768) {
                this.buffer.delete(0, Math.max(2048, this.buffer.length() - 32768));
            }
        }

        @Override
        public synchronized void write(int b) throws IOException {
            this.out.write(b);
            this.buffer.append((char)b);
            if (this.buffer.length() > 32768) {
                this.buffer.delete(0, Math.max(2048, this.buffer.length() - 32768));
            }
        }

        @Override
        public synchronized void write(byte[] b, int offset, int length) throws IOException {
            this.out.write(b, offset, length);
            this.buffer.append(new String(b, offset, length));
            if (this.buffer.length() > 32768) {
                this.buffer.delete(0, Math.max(2048, this.buffer.length() - 32768));
            }
        }
    }

    public static class DumpCommand
    extends AbstractHttpCommand {
        private Method method;

        public DumpCommand(String name, String description) throws NoSuchMethodException {
            super(name, description, Dump.GROUP);
            try {
                this.method = Dump.class.getMethod(name + "Html", null);
            }
            catch (NoSuchMethodException e) {
                this.method = Dump.class.getMethod(name, null);
            }
        }

        @Override
        public void process(HttpRequest request, HttpResponse response) throws IOException {
            try {
                String header = "<html><body bgcolor=white><pre><b><big>" + this.getDescription() + "</big></b>\n\n";
                String footer = "</pre></body></html>";
                String result = (String)this.method.invoke(null, (Object[])null);
                result = header + result + "</pre></body></html>";
                response.getOutput().write(result.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace(response.getPrintStream());
            }
        }
    }
}

