/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.util.ArrayList;
import java.util.List;

public class Chronometer {
    private final int deep;
    private final String id;
    private final long startTime = System.nanoTime();
    private static final ThreadLocal<List<Chronometer>> THREAD_LOCAL = new ThreadLocal();

    private Chronometer(String startId, int deep) {
        this.id = startId;
        this.deep = deep;
    }

    public static Chronometer start(String startId) {
        List<Chronometer> logs = Chronometer.getEntries();
        Chronometer instance = new Chronometer(startId, logs.size() + 1);
        logs.add(instance);
        return instance;
    }

    public static Chronometer last() {
        List<Chronometer> logs = Chronometer.getEntries();
        int idx = logs.size() - 1;
        try {
            return logs.get(idx);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException("start() must be invoked first", e);
        }
    }

    public boolean end() {
        long elapsed = System.nanoTime() - this.startTime;
        List<Chronometer> logs = Chronometer.getEntries();
        int last = logs.lastIndexOf(this);
        if (last != -1) {
            logs.subList(last, logs.size()).clear();
        }
        long scale = 100000000000L;
        int unitIdx = -1;
        while (elapsed < scale - 1L) {
            scale /= 1000L;
            ++unitIdx;
        }
        int value = (int)((elapsed + (scale /= 100L) / 2L) / scale);
        String prefix = unitIdx == -1 ? "" : "m\u00b5n".substring(unitIdx, unitIdx + 1);
        System.out.printf("%d- %s:%d%ss\n", this.deep, this.id, value, prefix);
        return true;
    }

    private static List<Chronometer> getEntries() {
        ThreadLocal<List<Chronometer>> tl = THREAD_LOCAL;
        List<Chronometer> result = tl.get();
        if (result == null) {
            result = new ArrayList<Chronometer>();
            tl.set(result);
        }
        return result;
    }
}

