/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.util.Calendar;

public final class ByteArray {
    private int count;
    private byte[] value;
    private static final int DEFAULT_CHUNK = 2048;

    public ByteArray() {
        this(2048);
    }

    public ByteArray(int size) {
        this.value = new byte[size];
        this.count = 0;
    }

    public ByteArray(byte[] bytes) {
        this.count = bytes.length;
        this.value = new byte[this.count];
        System.arraycopy(bytes, 0, this.value, 0, this.value.length);
    }

    public static ByteArray append(ByteArray result, byte b) {
        if (result == null) {
            result = new ByteArray(16);
        }
        result.append(b);
        return result;
    }

    public static String byteArrayToString(byte[] b) {
        StringBuilder buff = new StringBuilder();
        for (byte x : b) {
            if (x < 0) {
                x = (byte)(x + 256);
            }
            buff.append(Character.forDigit(x / 16, 16));
            buff.append(Character.forDigit(x % 16, 16));
        }
        return buff.toString();
    }

    public static byte[] stringToByteArray(String s) {
        if (s == null) {
            return new byte[0];
        }
        int len = s.length() / 2;
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            int j = i * 2;
            result[i] = (byte)(Character.digit(s.charAt(j), 16) * 16 + Character.digit(s.charAt(j + 1), 16));
        }
        return result;
    }

    public byte getByte(int i) {
        return this.value[i];
    }

    public byte[] getBytes() {
        return this.value;
    }

    public ByteArray setField(int from, int length, int val) {
        this.ensureCapacity(from + length);
        if (this.count < from + length) {
            this.count = from + length;
        }
        if (val < 0) {
            this.value[from++] = 45;
            val *= -1;
            --length;
        }
        for (int i = length - 1; i >= 0; --i) {
            this.value[from + i] = (byte)(val % 10 + 48);
            val /= 10;
        }
        return this;
    }

    public ByteArray setField(int from, int length, String str) {
        int i;
        if (str == null) {
            str = String.valueOf(str);
        }
        this.ensureCapacity(from + length);
        if (this.count < from + length) {
            this.count = from + length;
        }
        int len = Math.min(str.length(), length);
        for (i = 0; i < len; ++i) {
            this.value[i + from] = (byte)str.charAt(i);
        }
        while (i < length) {
            this.value[from + i++] = 32;
        }
        return this;
    }

    public ByteArray setField(int from, int length, Calendar cal) {
        if (length < 15) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(from + length);
        if (this.count < from + length) {
            this.count = from + length;
        }
        int n = cal.get(1);
        this.value[from] = (byte)(n % 10000 / 1000 + 48);
        this.value[from + 1] = (byte)(n % 1000 / 100 + 48);
        this.value[from + 2] = (byte)(n % 100 / 10 + 48);
        this.value[from + 3] = (byte)(n % 10 + 48);
        n = cal.get(2) + 1;
        this.value[from + 4] = (byte)(n % 100 / 10 + 48);
        this.value[from + 5] = (byte)(n % 10 + 48);
        n = cal.get(5);
        this.value[from + 6] = (byte)(n % 100 / 10 + 48);
        this.value[from + 7] = (byte)(n % 10 + 48);
        this.value[from + 8] = 84;
        n = cal.get(11);
        this.value[from + 9] = (byte)(n % 100 / 10 + 48);
        this.value[from + 10] = (byte)(n % 10 + 48);
        n = cal.get(12);
        this.value[from + 11] = (byte)(n % 100 / 10 + 48);
        this.value[from + 12] = (byte)(n % 10 + 48);
        n = cal.get(13);
        this.value[from + 13] = (byte)(n % 100 / 10 + 48);
        this.value[from + 14] = (byte)(n % 10 + 48);
        for (int i = 15; i < length; ++i) {
            this.value[from + i] = 32;
        }
        return this;
    }

    public String getString() {
        return new String(this.value, 0, this.count);
    }

    public void append(byte[] bytes) {
        int len = bytes.length;
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(bytes, 0, this.value, this.count, len);
        this.count = newcount;
    }

    public void append(byte[] bytes, int offset, int len) {
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(bytes, offset, this.value, this.count, len);
        this.count = newcount;
    }

    public ByteArray append(char c) {
        int newcount = this.count + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        this.value[this.count++] = (byte)c;
        return this;
    }

    public ByteArray append(int i) {
        return this.append(Integer.toString(i));
    }

    public int capacity() {
        return this.value.length;
    }

    public boolean equalsString(String other) {
        if (other.length() != this.count) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if ((this.value[i] & 0xFF) == other.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public int length() {
        return this.count;
    }

    public void reset(char c) {
        this.clear();
        byte b = (byte)c;
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = b;
        }
    }

    private void append(byte c) {
        int newcount = this.count + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        this.value[this.count++] = c;
    }

    private ByteArray append(String str) {
        int len;
        int newcount;
        if (str == null) {
            str = String.valueOf(str);
        }
        if ((newcount = this.count + (len = str.length())) > this.value.length) {
            this.expandCapacity(newcount);
        }
        for (int i = 0; i < len; ++i) {
            this.value[this.count + i] = (byte)str.charAt(i);
        }
        this.count = newcount;
        return this;
    }

    private void clear() {
        this.count = 0;
    }

    private void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.value.length) {
            this.expandCapacity(minimumCapacity);
        }
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.value.length + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        byte[] newValue = new byte[newCapacity];
        System.arraycopy(this.value, 0, newValue, 0, this.count);
        this.value = newValue;
    }
}

