/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.IllegalConversionException;
import oracle.bpm.lang.Initialization;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.Kind;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.ServiceObject;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.TypeError;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.type.AbstractTypeRef;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.SchemaObjectFactory;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeFinder;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.filter.FilterNotSupportedException;
import oracle.bpm.type.filter.IterablesByFilterRegistry;
import oracle.bpm.type.filter.Operation;
import oracle.bpm.util.DefaultValue;
import oracle.bpm.util.documentation.DocumentationType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeDescriptionImpl
extends AbstractTypeRef
implements TypeDescription {
    protected LocaleStringMap displayNames;
    protected LocaleStringMap documentation;
    protected TypeRef[] typeParameters;
    protected LocaleStringMap useCaseDocumentation;
    private List<TypeError> errors;
    private int[] intParameters = EMPTY_INT_PARAMETERS;
    private final int kind;
    private int length;
    private boolean primitive;
    private int scale;
    private static final Class BYTE_CLASS = Byte.class;
    private static final Class SHORT_CLASS = Short.class;
    private static final Class LONG_CLASS = Long.class;
    private static final Class INTEGER_CLASS = Integer.class;
    private static final Class FLOAT_CLASS = Float.class;
    private static final Class DOUBLE_CLASS = Double.class;
    private static final Class BOOLEAN_CLASS = Boolean.class;
    private static final Class OBJECT_CLASS = Object.class;
    private static final Class BYTEARRAY_CLASS = byte[].class;
    private static final Class BIGDECIMAL_CLASS = BigDecimal.class;
    private static final Class STRING_CLASS = String.class;
    private static final Class INTERVAL_CLASS = Interval.class;
    private static final Class TIME_CLASS = Time.class;
    public static final String DOCUMENTATION_PROPERTY = "documentation";
    private static final AtomicReference<Set<TypeDescription>> recycledSet = new AtomicReference();
    private static final int[] EMPTY_INT_PARAMETERS = new int[0];

    @Deprecated
    protected TypeDescriptionImpl(int kind) {
        this(kind, -1, -1, false);
    }

    protected TypeDescriptionImpl(int kind, int length, int scale, boolean primitive) {
        assert (Kind.getName(kind) != null) : "kind without name: " + kind;
        assert (kind != 14 && kind != 18 || this instanceof MethodTypeDescription) : "Invalid kind";
        this.kind = kind;
        this.length = length == 0 ? -1 : length;
        this.scale = scale;
        this.primitive = primitive;
        this.initIntParameters(this.length, this.scale);
    }

    public static TypeDescription createTypeDescription(int kind, int length, int scale, boolean primitive) {
        return new TypeDescriptionImpl(kind, length, scale, primitive);
    }

    @Override
    public final TypeRef[] getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public final boolean hasParameters() {
        return this.typeParameters != null && this.typeParameters.length > 0;
    }

    @Override
    public long getLastModifiedTime() {
        return -1L;
    }

    @Override
    public LocaleStringMap getDisplayNames() {
        if (this.displayNames == null) {
            this.displayNames = this.createDisplayNamesMap();
        }
        return this.displayNames;
    }

    @Override
    public String getDisplayName(Locale locale) {
        String displayName = this.getDisplayNames().getString(locale);
        return "".equals(displayName) ? this.getName() : displayName;
    }

    @Override
    public void setDisplayName(Locale locale, String displayName) {
        this.getDisplayNames().put(locale, displayName);
    }

    @Override
    public boolean isArray() {
        return this.kind == 12 || this.kind == 13;
    }

    @Override
    public final boolean isAtomic() {
        return Kind.isAtomic(this.kind);
    }

    @Override
    public final boolean isAttribute() {
        return this.kind == 18;
    }

    @Override
    public final boolean isBinary() {
        return this.kind == 8;
    }

    @Override
    public final boolean isBool() {
        return this.kind == 1;
    }

    @Override
    public final boolean isCollection() {
        return this.isArray() || this.isSet();
    }

    @Override
    public String getComponentType() {
        return null;
    }

    @Override
    public boolean isEnum() {
        return this.kind == 17;
    }

    @Override
    public final boolean isInt() {
        return this.kind == 2;
    }

    @Override
    public final int getKind() {
        return this.kind;
    }

    @Override
    public final int getLength() {
        return this.length;
    }

    @Override
    public final TypeDescription getRawType() {
        return TypeFactory.forKind(this.getKind(), -1, -1);
    }

    @Override
    public final String getMaxValue() {
        int len = this.getLength();
        switch (this.kind) {
            case 2: {
                return String.valueOf(len <= 8 ? 127L : (len <= 16 ? 32767L : (len <= 32 ? Integer.MAX_VALUE : Long.MAX_VALUE)));
            }
            case 4: {
                return String.valueOf(len <= 32 ? 3.4028234663852886E38 : Double.MAX_VALUE);
            }
        }
        return null;
    }

    @Override
    public final int getMemberIndex(String name) {
        return this.getMemberIndex(name, -1);
    }

    @Override
    public final int getMemberIndex(String name, int requiredKind) {
        return this.getNextMemberIndex(name, -1, requiredKind);
    }

    @Override
    public final boolean isMethod() {
        return this.kind == 14;
    }

    @Override
    public final String getMinValue() {
        int len = this.getLength();
        switch (this.kind) {
            case 2: {
                return String.valueOf(len <= 8 ? -128L : (len <= 16 ? -32768L : (len <= 32 ? Integer.MIN_VALUE : Long.MIN_VALUE)));
            }
            case 4: {
                return String.valueOf(len <= 32 ? (double)1.4E-45f : Double.MIN_VALUE);
            }
        }
        return null;
    }

    @Override
    public final boolean isObject() {
        return this.kind == 11;
    }

    @Override
    public final int getScale() {
        return this.scale;
    }

    @Override
    public ComponentCatalog getCatalog() {
        return null;
    }

    @Override
    public boolean isFromCatalog(ComponentCatalog catalog) {
        return this.getCatalog() == catalog;
    }

    @Override
    public boolean isCloneable() {
        return false;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public int getIntParameter(int index) {
        return this.intParameters[index];
    }

    @Override
    public int getIntParameterCount() {
        return this.intParameters != null ? this.intParameters.length : 0;
    }

    @Override
    public String getMalformedMessage() {
        return null;
    }

    @Override
    public void addError(@NotNull TypeError exc) {
        if (exc == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/impl/TypeDescriptionImpl.addError must not be null");
        }
        if (this.errors == null) {
            this.errors = new ArrayList<TypeError>();
        }
        this.errors.add(exc);
    }

    @Override
    @NotNull
    public List<TypeError> getErrors() {
        List<TypeError> list;
        if (!(this.errors == null ? (list = Collections.emptyList()) != null : (list = this.errors) != null)) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/impl/TypeDescriptionImpl.getErrors must not return null");
        }
        return list;
    }

    @Override
    public boolean hasErrors() {
        return this.errors != null;
    }

    @Override
    public boolean isMap() {
        return this.kind == 13;
    }

    @Override
    public final boolean isNumber() {
        return Kind.isNumber(this.kind);
    }

    @Override
    public String getJavaSignature() {
        Class<?> cl = this.getJavaClass();
        return cl != null ? JavaClass.getSignature(cl) : null;
    }

    @Override
    @NonNls
    public String getJavaType() {
        int len = this.getLength();
        switch (this.kind) {
            case 1: {
                return this.isPrimitive() ? "boolean" : "java.lang.Boolean";
            }
            case 6: {
                return "oracle.bpm.lang.Time";
            }
            case 7: {
                return "oracle.bpm.lang.Interval";
            }
            case 5: {
                return this.isPrimitive() && len == 1 ? "char" : "java.lang.String";
            }
            case 2: {
                if (len <= 0) {
                    return this.isPrimitive() ? "int" : "java.lang.Integer";
                }
                if (len <= 8) {
                    return this.isPrimitive() ? "byte" : "java.lang.Byte";
                }
                if (len <= 16) {
                    return this.isPrimitive() ? "short" : "java.lang.Short";
                }
                if (len <= 32) {
                    return this.isPrimitive() ? "int" : "java.lang.Integer";
                }
                return this.isPrimitive() ? "long" : "java.lang.Long";
            }
            case 4: {
                if (len >= 0 && len == 32) {
                    return this.isPrimitive() ? "float" : "java.lang.Float";
                }
                return this.isPrimitive() ? "double" : "java.lang.Double";
            }
            case 3: {
                return "java.math.BigDecimal";
            }
            case 9: 
            case 10: {
                return "java.lang.Object";
            }
            case 15: {
                return "oracle.bpm.lang.DynamicObject";
            }
            case 17: {
                return "long";
            }
            case 8: {
                return "byte[]";
            }
            case 0: {
                return "void";
            }
        }
        assert (false) : "Unexpected Kind: " + this.kind + ' ' + this.getName() + ':' + this.getClass().getName() + ':' + this.toString();
        return null;
    }

    @Override
    public String getName() {
        return Kind.getName(this.kind);
    }

    @Override
    public final boolean isPredefined() {
        return Kind.isPredefined(this.kind);
    }

    @Override
    public final boolean isPrimitive() {
        return this.primitive;
    }

    @Override
    public final boolean isString() {
        return this.kind == 5;
    }

    @Override
    public final boolean isTime() {
        return this.kind == 6;
    }

    @Override
    public final boolean isTransformation() {
        return this.kind == 20;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public final boolean isMember() {
        return this.kind == 18 || this.kind == 14 || this.kind == 20;
    }

    @Override
    public final boolean isVoid() {
        return this.kind == 0;
    }

    @Override
    public boolean isInvokeable() {
        return false;
    }

    @Override
    public TypeDescription getElementType() {
        return null;
    }

    @Override
    public TypeRef getElementTypeRef() {
        return this.getElementType();
    }

    @Override
    public TypeDescription getIndexType() {
        return null;
    }

    @Override
    public TypeRef getIndexTypeRef() {
        return this.getIndexType();
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public final TypeDescription[] allHierarchy() {
        HashSet set = recycledSet.getAndSet(null);
        if (set == null) {
            set = new HashSet();
        }
        Set<TypeDescription> graph = this.allHierarchy(set);
        TypeDescription[] result = graph.toArray(new TypeDescription[graph.size()]);
        set.clear();
        recycledSet.set(set);
        return result;
    }

    @Override
    public final MethodTypeDescription[] findClosestMembers(String name, int maxDistance) {
        return this.findClosestMembers(name, maxDistance, -1);
    }

    @Override
    public final MethodTypeDescription[] findClosestMembers(String name, int maxDistance, int reqKind) {
        return TypeFinder.findClosestMembers(this, name, maxDistance, reqKind);
    }

    @Override
    public final MethodTypeDescription findMember(String name) {
        return TypeFinder.findMemberImpl(this, name, -1, TypeFinder.Scope.DEFAULT);
    }

    @Override
    @Nullable
    public final MethodTypeDescription findMethod(String name) {
        return TypeFinder.findMemberImpl(this, name, 14, TypeFinder.Scope.DEFAULT);
    }

    @Override
    public final AttributeTypeDescription findAttribute(String name) {
        return this.findAttribute(name, TypeFinder.Scope.DEFAULT);
    }

    @Override
    public final MethodTypeDescription findMember(String name, TypeFinder.Scope scope) {
        return TypeFinder.findMemberImpl(this, name, -1, scope);
    }

    @Override
    public final MethodTypeDescription findMethod(String name, TypeFinder.Scope scope) {
        return TypeFinder.findMemberImpl(this, name, 14, scope);
    }

    @Override
    public AttributeTypeDescription findAttribute(String name, TypeFinder.Scope scope) {
        MethodTypeDescription result = TypeFinder.findMemberImpl(this, name, 18, scope);
        return result != null ? result.asAttribute() : null;
    }

    @Override
    public boolean isInnerType() {
        TypeDescription parent = this.getParent();
        return parent != null && parent.isBpmObject();
    }

    @Override
    public TypeDescription getInnerTypeRootContainer() {
        return this.isInnerType() ? this.getParent().getInnerTypeRootContainer() : this;
    }

    @Override
    public Class<?> getJavaClass() {
        Class result = OBJECT_CLASS;
        int len = this.getLength();
        switch (this.getKind()) {
            case 10: {
                break;
            }
            case 8: {
                return BYTEARRAY_CLASS;
            }
            case 2: {
                if (len <= 0) {
                    result = this.isPrimitive() ? Integer.TYPE : INTEGER_CLASS;
                    break;
                }
                if (len <= 8) {
                    result = this.isPrimitive() ? Byte.TYPE : BYTE_CLASS;
                    break;
                }
                if (len <= 16) {
                    result = this.isPrimitive() ? Short.TYPE : SHORT_CLASS;
                    break;
                }
                if (len <= 32) {
                    result = this.isPrimitive() ? Integer.TYPE : INTEGER_CLASS;
                    break;
                }
                result = this.isPrimitive() ? Long.TYPE : LONG_CLASS;
                break;
            }
            case 3: {
                return BIGDECIMAL_CLASS;
            }
            case 4: {
                if (len >= 0 && len <= 32) {
                    result = this.isPrimitive() ? Float.TYPE : FLOAT_CLASS;
                    break;
                }
                result = this.isPrimitive() ? Double.TYPE : DOUBLE_CLASS;
                break;
            }
            case 1: {
                return this.isPrimitive() ? Boolean.TYPE : BOOLEAN_CLASS;
            }
            case 5: {
                return this.isPrimitive() && len == 1 ? Character.TYPE : STRING_CLASS;
            }
            case 0: {
                return Void.TYPE;
            }
            case 7: {
                return INTERVAL_CLASS;
            }
            case 6: {
                return TIME_CLASS;
            }
            case 17: {
                return this.isPrimitive() ? Long.TYPE : LONG_CLASS;
            }
        }
        return result;
    }

    @Override
    public final int getMemberCount() {
        return this.getMemberNames().size();
    }

    @Override
    public String getMemberName(int number) {
        return this.getMemberType(number).getName();
    }

    @Override
    public MethodTypeDescription getMemberType(int i) {
        return null;
    }

    @Override
    public int getNextMemberIndex(String name, int from, int requiredKind) {
        return -1;
    }

    @Override
    public final TypeDescription getParent() {
        TypeRef ref = this.getParentRef();
        return ref != null ? ref.get() : null;
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    public String getSignature() {
        return this.getJavaSignature();
    }

    @Override
    public String getText() {
        StringBuilder result = new StringBuilder().append(this.getName());
        int k = this.getKind();
        if (this.length != -1 && this.scale != -1) {
            result.append('(').append(this.length).append(',').append(this.scale).append(')');
        } else if (k != 6 && k != 8 && this.scale != -1) {
            result.append('(').append(this.scale).append(')');
        } else if (this.length != -1 && (k == 5 || k == 2 && this.length != 32 || k == 4 && this.length != 64)) {
            result.append('(').append(this.length).append(')');
        }
        return result.toString();
    }

    @Override
    public boolean isComparable(TypeDescription b) {
        int k = this.getKind();
        return this.isNumber() && b.isNumber() || k == b.getKind() && (k == 7 || k == 6 || k == 5);
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public String getIteratorFilter(Operation operation) throws FilterNotSupportedException {
        return IterablesByFilterRegistry.get(this, operation);
    }

    @Override
    public TypeRef getRef() {
        return this;
    }

    public SuperType getSuperType(int index) {
        return this.getSuperTypes().get(index);
    }

    @Override
    public boolean equality(TypeDescription b) {
        if (this.getKind() != 11 && b.getKind() == 11) {
            return b.equality(this);
        }
        return this.kind == b.getKind() || this.isNumber() && b.isNumber() || this.isAny() || b.isAny() || (this.isNull() || b.isNull()) && this.getKind() != b.getKind();
    }

    public boolean equals(Object value) {
        if (this == value) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (!(value instanceof TypeDescriptionImpl)) {
            return false;
        }
        TypeDescriptionImpl type = (TypeDescriptionImpl)value;
        return this.kind == type.getKind() && this.length == type.getLength() && this.scale == type.getScale() && this.primitive == type.isPrimitive();
    }

    @Override
    public boolean equivalent(TypeDescription b) {
        return this.kind == b.getKind();
    }

    @Override
    public TypeDescription get() {
        return this;
    }

    @Override
    public TypeRef getParentRef() {
        return null;
    }

    @Override
    public TypeDescription setReferenceType(boolean v) {
        return this.getKind() != 12 ? this.primitiveEquivalent(!v) : this;
    }

    @Override
    public boolean hasDefaultInit() {
        return true;
    }

    @Override
    public Object invokeMethod(String method, Object target, Object[] args) throws ComponentExecutionException {
        this.nonObject();
        return null;
    }

    @Override
    public boolean match(int requiredKind) {
        return requiredKind == -1 || requiredKind == 10 || this.getKind() == requiredKind;
    }

    @Override
    public Object newInstance() throws ComponentExecutionException {
        return DefaultValue.forClass(this.getJavaClass());
    }

    @Override
    public TypeDescription primitiveEquivalent(boolean v) {
        if (this.primitive != v) {
            int len = this.getLength();
            switch (this.kind) {
                case 2: {
                    return v ? TypeFactory.getPrimitiveInt(len) : TypeFactory.getInt(len);
                }
                case 4: {
                    if (this.getLength() == 32) {
                        return v ? TypeFactory.getPrimitiveReal(32) : TypeFactory.getReal(32);
                    }
                    return v ? TypeFactory.getPrimitiveReal(64) : TypeFactory.getReal();
                }
                case 1: {
                    return v ? TypeFactory.getPrimitiveBool() : TypeFactory.getBool();
                }
                case 5: {
                    return this.getLength() != 1 ? this : (v ? TypeFactory.getPrimitiveChar() : TypeFactory.getString(1));
                }
            }
        }
        return this;
    }

    @Override
    @NonNls
    public String toString() {
        return (this.primitive ? "p" : "") + this.getText();
    }

    @Override
    public boolean isIterable() {
        return Modifier.isIterable(this.getModifiers()) || IterablesByFilterRegistry.contains(this);
    }

    @Override
    public boolean isIterator() {
        return false;
    }

    @Override
    @NonNls
    public final String getDefaultHolder() {
        switch (this.kind) {
            case 5: {
                return "oracle.bpm.lang.Str$Holder";
            }
            case 2: {
                return this.isPrimitive() ? "oracle.bpm.lang.Int$Holder" : "oracle.bpm.lang.Int$ObjHolder";
            }
            case 17: {
                throw new IllegalStateException("Enum holder");
            }
            case 4: {
                return this.isPrimitive() ? "oracle.bpm.lang.Real$Holder" : "oracle.bpm.lang.Real$ObjHolder";
            }
            case 1: {
                return this.isPrimitive() ? "oracle.bpm.lang.Bool$Holder" : "oracle.bpm.lang.Bool$ObjHolder";
            }
            case 6: {
                return "oracle.bpm.lang.Time$Holder";
            }
            case 7: {
                return "oracle.bpm.lang.Interval$Holder";
            }
            case 3: {
                return "oracle.bpm.lang.Decimal$Holder";
            }
            case 8: {
                return "oracle.bpm.lang.Binary$Holder";
            }
        }
        return "oracle.bpm.lang.ObjectHolder";
    }

    @Override
    public TypeDescription getHolderType() {
        TypeDescription holderType = TypeFactory.getAny();
        switch (this.kind) {
            case 2: 
            case 17: {
                holderType = this.isPrimitive() ? TypeFactory.getPrimitiveInt(64) : TypeFactory.getInt(64);
                break;
            }
            case 4: {
                holderType = this.isPrimitive() ? TypeFactory.getPrimitiveReal(64) : TypeFactory.getReal();
                break;
            }
            case 1: {
                holderType = this.isPrimitive() ? TypeFactory.getPrimitiveBool() : TypeFactory.getBool();
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                holderType = this;
            }
        }
        return holderType;
    }

    @Override
    public final AttributeTypeDescription asAttribute() {
        try {
            return (AttributeTypeDescription)this;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(this.getClass().getName() + ": " + this.getName());
        }
    }

    @Override
    public final MethodTypeDescription asMethod() {
        try {
            return (MethodTypeDescription)this;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(this.getClass().getName() + ": " + this);
        }
    }

    @Override
    public long getModifiers() {
        return 0L;
    }

    @Override
    public boolean isModule() {
        return this.getKind() == 11 && this.asObject().getComponentType().equals(ComponentType.OBJECT.getText());
    }

    @Override
    public boolean isNativeEnum() {
        return false;
    }

    @Override
    public boolean isNone() {
        return this.getKind() == -1;
    }

    @Override
    public boolean isReal() {
        return this.kind == 4;
    }

    @Override
    public boolean isSet() {
        return this.getKind() == 19;
    }

    @Override
    public boolean isSql() {
        return this.isObject() && this.asObject().getComponentType().equals(ComponentType.SQL.getText());
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    @Override
    public EnumTypeDescription asEnum() {
        return (EnumTypeDescription)((Object)this);
    }

    @Override
    public boolean isIntrospectedObject() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ObjectTypeDescription asObject() {
        ObjectTypeDescription objectTypeDescription;
        if (this.isObject()) {
            objectTypeDescription = (ObjectTypeDescription)this;
            if (objectTypeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/impl/TypeDescriptionImpl.asObject must not return null");
            return objectTypeDescription;
        }
        int len = this.getLength();
        switch (this.kind) {
            case 5: {
                objectTypeDescription = StringObjectHolder.VALUE;
                if (objectTypeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/impl/TypeDescriptionImpl.asObject must not return null");
                return objectTypeDescription;
            }
            case 6: {
                objectTypeDescription = TimeObjectHolder.VALUE;
                if (objectTypeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/impl/TypeDescriptionImpl.asObject must not return null");
                return objectTypeDescription;
            }
            case 7: {
                objectTypeDescription = IntervalObjectHolder.VALUE;
                if (objectTypeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/impl/TypeDescriptionImpl.asObject must not return null");
                return objectTypeDescription;
            }
            case 3: {
                objectTypeDescription = DecimalObjectHolder.VALUE;
                if (objectTypeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/impl/TypeDescriptionImpl.asObject must not return null");
                return objectTypeDescription;
            }
            case 2: {
                if (!(len <= 8 ? (objectTypeDescription = Int8ObjectHolder.VALUE) != null : (len <= 16 ? (objectTypeDescription = Int16ObjectHolder.VALUE) != null : (len <= 32 ? (objectTypeDescription = Int32ObjectHolder.VALUE) != null : (objectTypeDescription = Int64ObjectHolder.VALUE) != null)))) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/impl/TypeDescriptionImpl.asObject must not return null");
                return objectTypeDescription;
            }
            case 4: {
                if (!(len <= 32 ? (objectTypeDescription = Real32ObjectHolder.VALUE) != null : (objectTypeDescription = Real64ObjectHolder.VALUE) != null)) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/impl/TypeDescriptionImpl.asObject must not return null");
                return objectTypeDescription;
            }
            case 1: {
                objectTypeDescription = BoolObjectHolder.VALUE;
                if (objectTypeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/impl/TypeDescriptionImpl.asObject must not return null");
                return objectTypeDescription;
            }
            case 8: {
                objectTypeDescription = BinaryObjectHolder.VALUE;
                if (objectTypeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/impl/TypeDescriptionImpl.asObject must not return null");
                return objectTypeDescription;
            }
            case 9: {
                objectTypeDescription = NullObjectHolder.VALUE;
                if (objectTypeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/impl/TypeDescriptionImpl.asObject must not return null");
                return objectTypeDescription;
            }
            case 0: {
                objectTypeDescription = VoidObjectHolder.VALUE;
                if (objectTypeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/impl/TypeDescriptionImpl.asObject must not return null");
                return objectTypeDescription;
            }
            case -1: {
                objectTypeDescription = NoneObjectHolder.VALUE;
                if (objectTypeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/impl/TypeDescriptionImpl.asObject must not return null");
                return objectTypeDescription;
            }
            case 10: {
                objectTypeDescription = AnyObjectHolder.VALUE;
                if (objectTypeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/impl/TypeDescriptionImpl.asObject must not return null");
                return objectTypeDescription;
            }
            default: {
                assert (false) : this.toString() + ", class: " + this.getClass() + ", text: " + this.getText() + ", kind: " + Kind.getName(this.getKind());
                objectTypeDescription = new ObjectTypeDescription(Kind.getName(this.getKind()));
                if (objectTypeDescription != null) return objectTypeDescription;
            }
        }
        throw new IllegalArgumentException("@NotNull method oracle/bpm/type/impl/TypeDescriptionImpl.asObject must not return null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public XObjectTypeDescription asBpmObject() {
        XObjectTypeDescription xObjectTypeDescription;
        try {
            xObjectTypeDescription = (XObjectTypeDescription)this;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(this.getClass().getName() + ": " + this.getName());
        }
        if (xObjectTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/impl/TypeDescriptionImpl.asBpmObject must not return null");
        }
        return xObjectTypeDescription;
    }

    @Override
    public boolean isSchemaObject() {
        return this.isPredefined();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public SchemaObject asSchemaObject() {
        if (!this.isSchemaObject()) {
            throw new IllegalConversionException(this.getText(), "SchemaObject");
        }
        SchemaObject schemaObject = SchemaObjectFactory.createForSimpleType(this);
        if (schemaObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/impl/TypeDescriptionImpl.asSchemaObject must not return null");
        }
        return schemaObject;
    }

    @Override
    @NotNull
    public ServiceObject asServiceObject() {
        throw new IllegalConversionException(this.getText(), "ServiceObject");
    }

    @Override
    public Object clone() {
        try {
            return this.isPredefined() ? this : super.clone();
        }
        catch (CloneNotSupportedException e) {
            return this;
        }
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((TypeDescription)o).getName());
    }

    @Override
    public String findFreeMemberName(String name) {
        int suffixNumber = 1;
        MethodTypeDescription member = this.findMember(name);
        while (member != null) {
            member = this.findMember(name + ++suffixNumber);
        }
        if (suffixNumber > 1) {
            name = name + suffixNumber;
        }
        return name;
    }

    @Override
    public boolean isBpmObject() {
        return false;
    }

    @Override
    public boolean isXmlObject() {
        return false;
    }

    @Override
    public final TypeDescription setLength(int len) {
        if (this.length != len) {
            switch (this.kind) {
                case 3: 
                case 5: {
                    try {
                        TypeDescriptionImpl result = (TypeDescriptionImpl)super.clone();
                        result.length = len;
                        return result;
                    }
                    catch (CloneNotSupportedException cne) {
                        Log.logWarning(cne);
                        break;
                    }
                }
                case 2: {
                    return this.isPrimitive() ? TypeFactory.getPrimitiveInt(len) : TypeFactory.getInt(len);
                }
                case 4: {
                    return this.isPrimitive() ? TypeFactory.getPrimitiveReal(len) : TypeFactory.getReal(len);
                }
            }
        }
        return this;
    }

    @Override
    public final TypeDescription setScale(int sc) {
        if (this.scale != sc && (this.kind == 3 || this.kind == 6)) {
            try {
                TypeDescriptionImpl result = (TypeDescriptionImpl)super.clone();
                result.scale = sc;
                return result;
            }
            catch (CloneNotSupportedException cne) {
                Log.logWarning(cne);
            }
        }
        return this;
    }

    @Override
    public boolean isAny() {
        return this.kind == 10;
    }

    @Override
    public boolean isDecimal() {
        return this.kind == 3;
    }

    @Override
    public String getImplementationType() {
        return this.getJavaType();
    }

    @Override
    public boolean isIndexedArray() {
        return this.kind == 12;
    }

    @Override
    public Initialization getInitialization() {
        if (this.isNumber()) {
            return this.isPrimitive() ? Initialization.ZERO : Initialization.ZERO_CONSTRUCTOR;
        }
        if (this.isBool()) {
            return Initialization.FALSE;
        }
        if (this.isString()) {
            return Initialization.EMPTY_STRING;
        }
        if (this.isInterval() || this.isTime()) {
            return Initialization.DEFAULT_CONSTRUCTOR;
        }
        return Initialization.NULL;
    }

    @Override
    public boolean isInterval() {
        return this.kind == 7;
    }

    @Override
    public boolean hasModifiers(long mods) {
        return (this.getModifiers() & mods) != 0L;
    }

    @Override
    public final boolean isAbstract() {
        return this.hasModifiers(512L);
    }

    @Override
    public boolean isExternal() {
        return this.hasModifiers(2048L);
    }

    @Override
    public boolean isDoubleWord() {
        return (this.isInt() || this.isReal()) && this.getLength() == 64;
    }

    @Override
    public boolean overrides(MethodTypeDescription member) {
        return this.overridingOf(member) != null;
    }

    @Override
    public MethodTypeDescription overridingOf(MethodTypeDescription member) {
        return this.overridingOf(member, TypeFinder.Scope.CURRENT);
    }

    @Override
    public MethodTypeDescription overridingOf(MethodTypeDescription member, TypeFinder.Scope where) {
        for (MethodTypeDescription currentMember = member.findIn(this, where); currentMember != null; currentMember = currentMember.getNextMethod()) {
            if (!currentMember.matchArguments(member)) continue;
            return currentMember != member ? currentMember : null;
        }
        return null;
    }

    @Override
    public LocaleStringMap getDocumentation(DocumentationType type) {
        if (this.documentation == null) {
            this.documentation = this.createDocumentationMap();
            this.useCaseDocumentation = this.createDocumentationMap();
        }
        return type == DocumentationType.DOCUMENTATION ? this.documentation : this.useCaseDocumentation;
    }

    @Override
    public void setDocumentation(DocumentationType type, Locale language, String doc) {
        String prev = this.getDocumentation(type).put(language, doc);
        if (!Any.equals(prev, doc)) {
            this.firePropertyChanged(DOCUMENTATION_PROPERTY);
            this.fireTypeChanged();
        }
    }

    @Override
    public String getDocumentation(DocumentationType type, Locale language) {
        String s = (String)this.getDocumentation(type).get((Object)language);
        return s == null ? "" : s;
    }

    @Override
    public List<SuperType> getSuperTypes() {
        switch (this.kind) {
            case 5: {
                return SuperType.forString();
            }
            case 2: {
                return SuperType.forInt();
            }
            case 4: {
                return SuperType.forReal();
            }
            case 3: {
                return SuperType.forDecimal();
            }
            case 8: {
                return SuperType.forBinary();
            }
            case 1: {
                return SuperType.forBool();
            }
            case 10: {
                return Collections.emptyList();
            }
            case 0: {
                return Collections.emptyList();
            }
        }
        return SuperType.getAnySuperTypeList();
    }

    @Override
    public boolean isHidden() {
        return Modifier.isHidden(this.getModifiers());
    }

    @Override
    public boolean isSynthesized() {
        return Modifier.isSynthesized(this.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return this.hasModifiers(131072L);
    }

    @Override
    public boolean isDeprecated() {
        return this.hasModifiers(0x100000L);
    }

    @Override
    public final boolean isDelegateInTarget(MethodTypeDescription member) {
        MethodTypeDescription inheritedMember = member.findIn(this, TypeFinder.Scope.DELEGATED);
        return inheritedMember != null || (inheritedMember = member.findIn(this, TypeFinder.Scope.INHERITED)) != null && inheritedMember.getParent().isInvokeable();
    }

    @Override
    public final boolean isStrictSubtype(TypeDescription target) {
        if (target.isAny()) {
            return !this.isPrimitive() || this.isArray();
        }
        if (target.isInvokeable()) {
            return false;
        }
        return this.isNull() && (!target.isPrimitive() || target.isArray()) || this.isStrictSubtypeImpl(target);
    }

    @Override
    public TypeDescription promote(TypeDescription target) {
        if (this.isNull()) {
            return target;
        }
        if (target.isNull()) {
            return this;
        }
        if (this.isObject() != target.isObject()) {
            return TypeFactory.getAny();
        }
        return this.promoteImpl(target);
    }

    @Override
    public boolean isAssignableFrom(@NotNull TypeDescription source) {
        boolean result;
        if (source == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/impl/TypeDescriptionImpl.isAssignableFrom must not be null");
        }
        boolean bl = result = this.isAny() || source.isNull() || TypeDescriptionImpl.isJavaEquivalent(this, source);
        if (!result) {
            if (!this.isObject() && source.isObject()) {
                if (source instanceof XmlTypeDescription || source.isBpmObject()) {
                    ObjectTypeDescription td = source.asObject();
                    result = ((TypeDescriptionImpl)td).isAssignableFromImpl(this);
                } else {
                    ObjectTypeDescription td = this.asObject();
                    result = ((TypeDescriptionImpl)td).isAssignableFromImpl(source);
                }
            } else {
                result = this.isAssignableFromImpl(source);
            }
        }
        return result;
    }

    @Override
    public final String getSignature(MethodTypeDescription member) {
        String result = !this.isBpmObject() || member.belongsToFuegoObject() ? member.getSignature() : (!this.isDelegateInTarget(member) ? member.getSignature() : (member.isAttribute() ? JavaClass.createGetAttrSignature(member.getName(), member.getResultArgument().getJavaSignature()) : ("java".equals(member.getParent().getComponentType()) && member.getPrefix().length() == 0 ? member.getSignature() : member.getJavaSignature())));
        return result;
    }

    @Override
    public final String getWriteSignature(MethodTypeDescription member) {
        String result;
        if (!this.isBpmObject() || member.belongsToFuegoObject()) {
            result = member.isAttribute() ? member.asAttribute().getWriteSignature() : null;
        } else if (!this.isDelegateInTarget(member)) {
            result = member.isAttribute() ? member.asAttribute().getWriteSignature() : null;
        } else {
            Argument retType = member.getResultArgument();
            result = member.isAttribute() ? JavaClass.createSetAttrSignature(member.getName(), retType.getJavaSignature()) : member.getJavaSignature();
        }
        return result;
    }

    @Override
    public final String javaType() {
        String result;
        String string = result = this.isInvokeable() ? Invokeable.class.getName() : this.getJavaType();
        if (Str.isEmpty(result)) {
            throw new IllegalArgumentException(this.toString() + '-' + this.getClass() + " does not have a java type");
        }
        return result;
    }

    @Override
    public boolean isNull() {
        return this.getKind() == 9;
    }

    @Override
    public void setTypeParameters(TypeRef ... typeParameters) {
        this.typeParameters = typeParameters;
    }

    protected LocaleStringMap createDisplayNamesMap() {
        return LocaleStringMap.create();
    }

    protected LocaleStringMap createDocumentationMap() {
        return LocaleStringMap.create();
    }

    protected StringList getMemberNames() {
        return StringList.EMPTY;
    }

    protected boolean isAssignableFromImpl(TypeDescription source) {
        int bKind = source.getKind();
        if (this.kind == 10) {
            return true;
        }
        switch (this.kind) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return this.kind == bKind || this.isNumber() && bKind == 17;
            }
            case 4: {
                return source.isNumber() || bKind == 17;
            }
            case 3: {
                return bKind == 3 || bKind == 2 || bKind == 17;
            }
            case 15: {
                return true;
            }
        }
        return false;
    }

    protected boolean isStrictSubtypeImpl(TypeDescription b) {
        if (this.equals(b)) {
            return true;
        }
        switch (this.kind) {
            case 3: {
                if (b.getKind() != 3) break;
                int bScale = b.getScale();
                int thisScale = this.scale;
                if (bScale >= 0 && (thisScale < 0 || bScale < thisScale) || TypeDescriptionImpl.getDecimalIntDigits(b.getLength(), bScale) < TypeDescriptionImpl.getDecimalIntDigits(this.length, thisScale)) break;
                return true;
            }
            case 5: {
                if (!b.isString() || b.getLength() != -1 && (this.length == -1 || b.getLength() < this.length)) break;
                return true;
            }
            case 2: {
                if (!b.isInt() || this.isPrimitive() != b.isPrimitive() || b.getLength() < this.length) break;
                return this.isPrimitive() ? b.getLength() >= this.length : b.getLength() == this.length;
            }
            case 4: {
                if (!b.isReal() || b.getLength() < this.length || this.isPrimitive() != b.isPrimitive()) break;
                return true;
            }
            case 0: {
                return false;
            }
            case -1: {
                return false;
            }
            case 15: {
                return false;
            }
        }
        return !this.isPrimitive() && b.equals(AnyObjectHolder.VALUE);
    }

    protected final Object abstractClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return this;
        }
    }

    protected TypeDescription promoteImpl(TypeDescription b) {
        int bKind = b.getKind();
        switch (this.kind) {
            case 1: {
                if (this.kind != bKind) break;
                if (this.isPrimitive() != b.isPrimitive()) {
                    return TypeFactory.getBool();
                }
                return this;
            }
            case -1: 
            case 0: 
            case 6: 
            case 7: 
            case 8: {
                if (this.kind != bKind) break;
                return this;
            }
            case 5: {
                if (bKind != 5) break;
                TypeDescription type = this.getLength() < 0 || b.getLength() < 0 ? TypeFactory.getString() : TypeFactory.getString(Math.max(this.getLength(), b.getLength()));
                return type.primitiveEquivalent(this.isPrimitive() && b.isPrimitive());
            }
            case 4: {
                if (!b.isNumber() && bKind != 17) break;
                if (bKind == 4) {
                    TypeDescription result = this.getLength() > b.getLength() ? this : b;
                    return this.isPrimitive() == b.isPrimitive() ? result : result.primitiveEquivalent(false);
                }
                return this;
            }
            case 3: {
                if (bKind == 4) {
                    return b;
                }
                if (bKind == 3) {
                    int maxScale;
                    int bScale = b.getScale();
                    int thisScale = this.getScale();
                    int bDigits = TypeDescriptionImpl.getDecimalIntDigits(b.getLength(), bScale);
                    int thisDigits = TypeDescriptionImpl.getDecimalIntDigits(this.getLength(), thisScale);
                    int maxDigits = Math.max(bDigits, thisDigits);
                    int n = maxScale = bScale < 0 || thisScale < 0 ? -1 : Math.max(bScale, thisScale);
                    int newLen = maxDigits == Integer.MAX_VALUE ? -1 : (maxScale < 0 ? maxDigits : maxDigits + maxScale);
                    return TypeFactory.getDecimal(newLen, maxScale);
                }
                if (bKind != 2 && bKind != 17) break;
                return this.setLength(-1);
            }
            case 2: {
                if (bKind == 17) {
                    return TypeFactory.getInt(64);
                }
                if (!Kind.isNumber(bKind)) break;
                if (bKind == 2) {
                    TypeDescription result = this.getLength() > b.getLength() ? this : b;
                    return this.isPrimitive() == b.isPrimitive() ? result : result.primitiveEquivalent(false);
                }
                return b.setLength(-1);
            }
            case 10: {
                return TypeFactory.getAny();
            }
            case 17: {
                if (!Kind.isNumber(bKind)) break;
                return b;
            }
        }
        return TypeFactory.getAny();
    }

    protected final void setPrimitive(boolean primitive) {
        assert (!primitive || this.kind != 13) : "an associative array cannot be primitive";
        this.primitive = primitive;
    }

    final void nonObject() {
        throw new IllegalStateException("Attempting to invoke a method in an non-object type: " + this);
    }

    private static int getDecimalIntDigits(int len, int scale) {
        return len < 0 ? Integer.MAX_VALUE : (scale < 0 ? len : len - scale);
    }

    private static boolean isTimeEquivalent(TypeDescription type) {
        if (!type.isObject() || !ComponentType.JAVA.getText().equals(type.getComponentType())) {
            return false;
        }
        String typeName = type.getQualifiedName();
        return "Java.Util.Date".equals(typeName) || "Java.Sql.Date".equals(typeName) || "Java.Sql.Time".equals(typeName) || "Java.Sql.Timestamp".equals(typeName);
    }

    private static boolean isJavaEquivalent(TypeDescription target, TypeDescription source) {
        boolean isAssignable = false;
        if ((source.isEnum() || source.isBpmObject()) && target.getText().equals(TypeFactory.getRootObject().getText())) {
            isAssignable = true;
        } else if (source.isTime() && TypeDescriptionImpl.isTimeEquivalent(target)) {
            isAssignable = true;
        } else if (target.isTime() && TypeDescriptionImpl.isTimeEquivalent(source)) {
            isAssignable = true;
        }
        return isAssignable;
    }

    private void initIntParameters(int len, int sc) {
        if (len != -1 && sc != -1) {
            this.intParameters = new int[]{len, sc};
        } else if (len != -1) {
            this.intParameters = new int[]{len};
        } else if (sc != -1) {
            this.intParameters = new int[]{sc};
        }
    }

    private Set<TypeDescription> allHierarchy(Set<TypeDescription> graph) {
        if (!graph.contains(this)) {
            graph.add(this);
            for (SuperType superType : this.getSuperTypes()) {
                ((TypeDescriptionImpl)superType.getType()).allHierarchy(graph);
            }
        }
        return graph;
    }

    private static final class VoidObjectHolder {
        static final ObjectTypeDescription VALUE = new ObjectTypeDescription("Void");

        private VoidObjectHolder() {
        }
    }

    private static final class TimeObjectHolder {
        static final ObjectTypeDescription VALUE = TypeUtils.loadType("Fuego.Lang.Time");

        private TimeObjectHolder() {
        }
    }

    private static final class StringObjectHolder {
        static final ObjectTypeDescription VALUE = TypeUtils.loadType("Java.Lang.String");

        private StringObjectHolder() {
        }
    }

    private static final class Real64ObjectHolder {
        static final ObjectTypeDescription VALUE = TypeUtils.loadType("Java.Lang.Double");

        private Real64ObjectHolder() {
        }
    }

    private static final class Real32ObjectHolder {
        static final ObjectTypeDescription VALUE = TypeUtils.loadType("Java.Lang.Float");

        private Real32ObjectHolder() {
        }
    }

    private static final class NullObjectHolder {
        static final ObjectTypeDescription VALUE = new ObjectTypeDescription("null");

        private NullObjectHolder() {
        }
    }

    private static final class NoneObjectHolder {
        static final ObjectTypeDescription VALUE = new ObjectTypeDescription("None");

        private NoneObjectHolder() {
        }
    }

    private static final class IntervalObjectHolder {
        static final ObjectTypeDescription VALUE = TypeUtils.loadType("Fuego.Lang.Interval");

        private IntervalObjectHolder() {
        }
    }

    private static final class Int8ObjectHolder {
        static final ObjectTypeDescription VALUE = TypeUtils.loadType("Java.Lang.Byte");

        private Int8ObjectHolder() {
        }
    }

    private static final class Int64ObjectHolder {
        static final ObjectTypeDescription VALUE = TypeUtils.loadType("Java.Lang.Long");

        private Int64ObjectHolder() {
        }
    }

    private static final class Int32ObjectHolder {
        static final ObjectTypeDescription VALUE = TypeUtils.loadType("Java.Lang.Integer");

        private Int32ObjectHolder() {
        }
    }

    private static final class Int16ObjectHolder {
        static final ObjectTypeDescription VALUE = TypeUtils.loadType("Java.Lang.Short");

        private Int16ObjectHolder() {
        }
    }

    private static final class DecimalObjectHolder {
        static final ObjectTypeDescription VALUE = TypeUtils.loadType("Java.Math.BigDecimal");

        private DecimalObjectHolder() {
        }
    }

    private static final class BoolObjectHolder {
        static final ObjectTypeDescription VALUE = TypeUtils.loadType("Java.Lang.Boolean");

        private BoolObjectHolder() {
        }
    }

    private static final class BinaryObjectHolder {
        static final ObjectTypeDescription VALUE = TypeFactory.getPrimitiveArray(Int8ObjectHolder.VALUE).asObject();

        private BinaryObjectHolder() {
        }
    }

    private static final class AnyObjectHolder {
        static final ObjectTypeDescription VALUE = TypeFactory.getRootObject();

        private AnyObjectHolder() {
        }
    }
}

