/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.ComponentBundleMetadata;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.log.Trace;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DefaultComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.PropertyVisitor;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.UnknownType;
import oracle.bpm.type.catalog.ComponentBundle;
import oracle.bpm.util.Identifier;
import oracle.bpm.util.ProgressMonitor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeUtils {
    @Nullable
    private static MutableComponentCatalog defaultCatalog;
    public static final String CATALOG_PREFIX = "FUEGO-INF/";
    public static final String MODULE_SEPARATOR = ".";
    private static final char MODULE_SEPARATOR_CHAR = '.';
    private static final Trace trace;

    private TypeUtils() {
    }

    public static String shortName(String typeName) {
        int indexOfDot = (typeName = TypeUtils.checkName(typeName)).lastIndexOf(46);
        return indexOfDot == -1 ? typeName : typeName.substring(indexOfDot + 1);
    }

    public static String shortName(TypeRef typeRef) {
        String text = typeRef.getText();
        return text.substring(text.lastIndexOf(MODULE_SEPARATOR) + 1);
    }

    public static String moduleName(String typeName, String defaulName) {
        int indexOfDot = (typeName = TypeUtils.checkName(typeName)).lastIndexOf(46);
        return indexOfDot == -1 ? defaulName : typeName.substring(0, indexOfDot);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String qualifiedName(@NotNull String module, @NotNull String name) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeUtils.qualifiedName must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/TypeUtils.qualifiedName must not be null");
        }
        String string = (module.isEmpty() ? name : module + MODULE_SEPARATOR + name).intern();
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeUtils.qualifiedName must not return null");
        }
        return string;
    }

    public static List<String> typeShortNames(List<? extends TypeRef> typeRefs) {
        ArrayList<String> typeNames = new ArrayList<String>();
        for (TypeRef typeRef : typeRefs) {
            typeNames.add(TypeUtils.shortName(typeRef));
        }
        return typeNames;
    }

    public static int memberDistance(String source, String target) {
        source = Identifier.validLowerCase(source);
        target = Identifier.validLowerCase(target);
        source = source.toLowerCase();
        target = target.toLowerCase();
        return Str.editDistance(source, target);
    }

    public static boolean sameSignature(MethodTypeDescription left, MethodTypeDescription right) {
        return left.getName().equals(right.getName()) && left.matchArguments(right, false) && left.getResultType().equals(right.getResultType());
    }

    public static void visitProperties(@NotNull Map<String, String> properties, @NotNull PropertyVisitor visitor) {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeUtils.visitProperties must not be null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/TypeUtils.visitProperties must not be null");
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key != null && value != null) {
                if (visitor.visit(key, value)) continue;
                break;
            }
            if (!trace.isEnabled()) continue;
            trace.log("PropertyVisitor found malformed key-value pair: " + key + " = " + value);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String getAttributesObjectId(@NotNull ObjectTypeDescription bpmObject) {
        if (bpmObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeUtils.getAttributesObjectId must not be null");
        }
        String string = bpmObject.getProperty("attributes.schema.id");
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeUtils.getAttributesObjectId must not return null");
        }
        return string;
    }

    @Nullable
    public static XmlTypeDescription getModelObject(@NotNull ObjectTypeDescription bpmObject) {
        if (bpmObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeUtils.getModelObject must not be null");
        }
        String schemaId = bpmObject.getProperty("attributes.schema.id");
        assert (!Str.isEmpty(schemaId)) : "Missing schema id on " + bpmObject.getText();
        XmlTypeDescription result = null;
        if (!Str.isEmpty(schemaId)) {
            for (SuperType superType : bpmObject.getSuperTypes()) {
                TypeDescription td = superType.getType();
                if (!schemaId.equals(td.getId()) || td.isUnknown()) continue;
                result = (XmlTypeDescription)td;
                break;
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static XmlTypeDescription findXmlType(@NotNull XmlTypeDescription xmlTypeDescription) {
        if (xmlTypeDescription == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeUtils.findXmlType must not be null");
        }
        XmlTypeDescription result = null;
        String elementTypeId = xmlTypeDescription.getProperty("element.type.id");
        if (!Str.isEmpty(elementTypeId)) {
            for (SuperType superType : xmlTypeDescription.getSuperTypes()) {
                TypeDescription td = superType.getType();
                if (!elementTypeId.equals(td.getId())) continue;
                if (td.isUnknown()) {
                    throw new IllegalStateException("Missing xml schema for: " + xmlTypeDescription.getText());
                }
                assert (td instanceof XmlTypeDescription && superType.isDelegated());
                result = (XmlTypeDescription)td;
                break;
            }
        }
        if (result == null) {
            result = xmlTypeDescription;
        }
        XmlTypeDescription xmlTypeDescription2 = result;
        if (xmlTypeDescription2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeUtils.findXmlType must not return null");
        }
        return xmlTypeDescription2;
    }

    public static ObjectTypeDescription createParentFromModule(@NotNull ObjectTypeDescription rootModule, @NotNull String moduleName, MutableComponentCatalog defaultCatalog) throws AmbiguousTypeNameException {
        boolean isRootModule;
        if (rootModule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeUtils.createParentFromModule must not be null");
        }
        if (moduleName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/TypeUtils.createParentFromModule must not be null");
        }
        ObjectTypeDescription parentModule = null;
        boolean bl = isRootModule = !moduleName.contains(MODULE_SEPARATOR) && Identifier.classname(moduleName).equals(rootModule.getName());
        if (isRootModule) {
            parentModule = rootModule;
        } else {
            ObjectTypeDescription root = null;
            String currentModule = null;
            int index = 0;
            for (String part : Str.split(moduleName, '.', true)) {
                ObjectTypeDescription newModule;
                TypeRef innerType;
                part = Identifier.classname(part);
                currentModule = currentModule != null ? currentModule + MODULE_SEPARATOR + part : part;
                TypeRef typeRef = null;
                if (defaultCatalog != null && (typeRef = defaultCatalog.findType(currentModule, null, null, true)) != null && !currentModule.equals(typeRef.getText())) {
                    typeRef = null;
                }
                if (typeRef == null) {
                    innerType = parentModule != null ? parentModule.findInnerType(part) : rootModule.findInnerType(part);
                    if (innerType != null) {
                        newModule = (ObjectTypeDescription)innerType.get();
                    } else if (part.equals(rootModule.getText()) && index == 0) {
                        newModule = rootModule;
                    } else {
                        newModule = new ObjectTypeDescription(part);
                        newModule.setComponentType(ComponentType.OBJECT.getText());
                    }
                } else {
                    newModule = (ObjectTypeDescription)typeRef.get();
                }
                if (root == null) {
                    root = newModule;
                } else {
                    assert (parentModule != null);
                    innerType = parentModule.findInnerType(part);
                    if (innerType == null) {
                        parentModule.addInnerType(newModule);
                    }
                }
                parentModule = newModule;
                ++index;
            }
        }
        return parentModule;
    }

    public static boolean isEnumType(@NotNull TypeDescription td) {
        if (td == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeUtils.isEnumType must not be null");
        }
        if (td instanceof XmlTypeDescription) {
            XmlTypeDescription xmltd = (XmlTypeDescription)td;
            return TypeUtils.findXmlType(xmltd).isEnum();
        }
        return td.isEnum();
    }

    public static boolean compareObjectMembers(@NotNull ObjectTypeDescription otd1, @NotNull ObjectTypeDescription otd2) {
        if (otd1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeUtils.compareObjectMembers must not be null");
        }
        if (otd2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/TypeUtils.compareObjectMembers must not be null");
        }
        if (otd1 == otd2) {
            return true;
        }
        int memberCount = otd1.getMemberCount();
        if (memberCount != otd2.getMemberCount()) {
            return false;
        }
        for (int i = 0; i < memberCount; ++i) {
            MethodTypeDescription mtd2;
            MethodTypeDescription mtd1 = otd1.getMember(i);
            if (mtd1.equals(mtd2 = otd2.getMember(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean belongsToDefaultCatalog(TypeRef ref) {
        return ref.isFromCatalog(TypeUtils.getDefaultCatalog());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static MutableComponentCatalog getDefaultCatalog() {
        MutableComponentCatalog mutableComponentCatalog = TypeUtils.getDefaultCatalog(null);
        if (mutableComponentCatalog == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeUtils.getDefaultCatalog must not return null");
        }
        return mutableComponentCatalog;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static synchronized MutableComponentCatalog getDefaultCatalog(ProgressMonitor monitor) {
        MutableComponentCatalog catalog = defaultCatalog;
        if (catalog == null) {
            catalog = TypeUtils.createComponentCatalog();
            catalog.setDescription("Default repository");
            catalog.setMonitor(monitor);
            catalog.setReadOnly(true);
            ExtensionService service = Platform.getExtensionService();
            List<Extension<ComponentBundleMetadata>> extensions = service.getExtensionsByPoint(ComponentBundleMetadata.class);
            for (Extension<ComponentBundleMetadata> extension : extensions) {
                try {
                    if (extension.getMetadata().deprecated() && System.getProperty("oracle.bpmn.test.compatibility") == null) continue;
                    catalog.addComponentBundle(extension.instantiateAs(ComponentBundle.class));
                }
                catch (InstantiationException e) {
                    Log.logSevere(e);
                }
            }
            defaultCatalog = catalog;
            catalog.sync();
        }
        MutableComponentCatalog mutableComponentCatalog = catalog;
        if (mutableComponentCatalog == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeUtils.getDefaultCatalog must not return null");
        }
        return mutableComponentCatalog;
    }

    public static ObjectTypeDescription loadType(@NonNls String type) {
        TypeRef ref;
        MutableComponentCatalog catalog = TypeUtils.getDefaultCatalog();
        try {
            ref = catalog.find(type);
        }
        catch (AmbiguousTypeNameException e) {
            ref = UnknownType.create(e.getTypeName(), (ComponentCatalog)catalog, e.getMessage());
        }
        return ref == null ? UnknownType.create(type, (ComponentCatalog)catalog, "Type was not found") : ref.get().asObject();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static MutableComponentCatalog createComponentCatalog() {
        DefaultComponentCatalog defaultComponentCatalog = new DefaultComponentCatalog();
        if (defaultComponentCatalog == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeUtils.createComponentCatalog must not return null");
        }
        return defaultComponentCatalog;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static MutableComponentCatalog createComponentCatalog(MutableComponentCatalog parent) {
        DefaultComponentCatalog defaultComponentCatalog = new DefaultComponentCatalog(parent);
        if (defaultComponentCatalog == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeUtils.createComponentCatalog must not return null");
        }
        return defaultComponentCatalog;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String buildTypeId(@NotNull String componentType, String id) {
        if (componentType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeUtils.buildTypeId must not be null");
        }
        String string = componentType + "::" + id;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeUtils.buildTypeId must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String buildFullName(@NotNull String typeName, @Nullable String parentName) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeUtils.buildFullName must not be null");
        }
        String objectTypeName = !Str.isEmpty(parentName) ? parentName + '.' + TypeUtils.shortName(typeName) : typeName;
        String string = objectTypeName;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeUtils.buildFullName must not return null");
        }
        return string;
    }

    public static boolean isService(@NotNull TypeRef typeRef) {
        if (typeRef == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeUtils.isService must not be null");
        }
        boolean result = false;
        TypeDescription type = typeRef.get();
        if (type.isObject()) {
            ObjectTypeDescription otd = type.asObject();
            result = otd.getProperty("interface.object") != null;
        }
        return result;
    }

    private static String checkName(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("Invalid type name (null value)");
        }
        typeName = typeName.startsWith(MODULE_SEPARATOR) ? typeName.substring(1) : typeName;
        return typeName;
    }

    static {
        trace = Trace.getInstance(TypeUtils.class);
    }
}

