/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.impl.TypeDescriptionImpl;

public class TypeToXsdMapping {
    private static Map<TypeDescription, String> typesToXsd = new TreeMap<TypeDescription, String>(new TypeComparator());

    public static Map<TypeDescription, String> getTypesToXsd() {
        return typesToXsd;
    }

    public static String getTypeMapping(TypeDescription td) {
        return TypeToXsdMapping.getTypesToXsd().get(td);
    }

    public static Map<TypeDescription, String> createEmptyTypeMap() {
        return new TreeMap<TypeDescription, String>(new TypeComparator());
    }

    static {
        typesToXsd.put(TypeFactory.getString(), "string");
        typesToXsd.put(TypeFactory.getInt(8), "byte");
        typesToXsd.put(TypeFactory.getInt(16), "short");
        typesToXsd.put(TypeFactory.getInt(32), "int");
        typesToXsd.put(TypeFactory.getInt(64), "long");
        typesToXsd.put(TypeFactory.getPrimitiveInt(8), "byte");
        typesToXsd.put(TypeFactory.getPrimitiveInt(16), "short");
        typesToXsd.put(TypeFactory.getPrimitiveInt(32), "int");
        typesToXsd.put(TypeFactory.getPrimitiveInt(64), "long");
        typesToXsd.put(TypeFactory.getDecimal(), "decimal");
        typesToXsd.put(TypeFactory.getReal(64), "double");
        typesToXsd.put(TypeFactory.getReal(32), "float");
        typesToXsd.put(TypeFactory.getPrimitiveReal(64), "double");
        typesToXsd.put(TypeFactory.getPrimitiveReal(32), "float");
        typesToXsd.put(TypeFactory.getBool(), "boolean");
        typesToXsd.put(TypeFactory.getPrimitiveBool(), "boolean");
        typesToXsd.put(TypeFactory.getTime(), "dateTime");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(6, -1, 2, false), "dateTime");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(6, -1, 1, false), "time");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(6, -1, 0, false), "date");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(6, -1, 4, false), "gYearMonth");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(6, -1, 3, false), "gMonthDay");
        typesToXsd.put(TypeFactory.getInterval(), "duration");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(8, -1, 0, false), "base64Binary");
        typesToXsd.put(TypeDescriptionImpl.createTypeDescription(8, -1, 1, false), "hexBinary");
        typesToXsd.put(TypeFactory.getAny(), "anyType");
    }

    private static class TypeComparator
    implements Comparator<TypeDescription> {
        private TypeComparator() {
        }

        @Override
        public int compare(TypeDescription td1, TypeDescription td2) {
            int s2;
            int s1;
            int k2;
            if (td1 == td2) {
                return 0;
            }
            int k1 = td1.getKind();
            if (k1 != (k2 = td2.getKind())) {
                return k1 - k2;
            }
            if (td1.isPrimitive() ^ td2.isPrimitive()) {
                return td1.isPrimitive() ? 1 : -1;
            }
            if (td1.isInt() || td1.isReal()) {
                int l2;
                int l1 = td1.getLength();
                if (l1 != (l2 = td2.getLength())) {
                    return l1 - l2;
                }
            } else if (td1.isTime()) {
                int s22;
                int s12 = td1.getScale();
                if (s12 != (s22 = td2.getScale())) {
                    return s12 - s22;
                }
            } else if (td1.isBinary() && (s1 = td1.getScale()) != (s2 = td2.getScale())) {
                return s1 - s2;
            }
            return 0;
        }
    }
}

