/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.DynamicTypeDescription;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.Void;
import oracle.bpm.type.TypeFactory;

public class TypeMappings {
    private static final Map<String, TypeDescription> typeMappings;

    public static TypeDescription getType(String javaType) {
        return typeMappings.get(javaType);
    }

    static {
        HashMap<String, TypeDescription> mappings = new HashMap<String, TypeDescription>();
        typeMappings = mappings;
        mappings.put(String.class.getName(), TypeFactory.getString());
        mappings.put(BigDecimal.class.getName(), TypeFactory.getDecimal());
        mappings.put(Time.class.getName(), TypeFactory.getTime());
        mappings.put(Interval.class.getName(), TypeFactory.getInterval());
        mappings.put("long", TypeFactory.getPrimitiveInt(64));
        mappings.put("int", TypeFactory.getPrimitiveInt(32));
        mappings.put("short", TypeFactory.getPrimitiveInt(16));
        mappings.put("byte", TypeFactory.getPrimitiveInt(8));
        mappings.put("double", TypeFactory.getPrimitiveReal(64));
        mappings.put("float", TypeFactory.getPrimitiveReal(32));
        mappings.put("void", TypeFactory.getVoid());
        mappings.put("char", TypeFactory.getPrimitiveChar());
        mappings.put("boolean", TypeFactory.getPrimitiveBool());
        mappings.put("byte[]", TypeFactory.getBinary());
        mappings.put(Void.class.getName(), TypeFactory.getVoid());
        mappings.put(Boolean.class.getName(), TypeFactory.getBool());
        mappings.put(Character.class.getName(), TypeFactory.getString(1));
        mappings.put(Double.class.getName(), TypeFactory.getReal());
        mappings.put(Float.class.getName(), TypeFactory.getReal(32));
        mappings.put(Long.class.getName(), TypeFactory.getInt(64));
        mappings.put(Integer.class.getName(), TypeFactory.getInt(32));
        mappings.put(Short.class.getName(), TypeFactory.getInt(16));
        mappings.put(Byte.class.getName(), TypeFactory.getInt(8));
        mappings.put(DynamicObject.class.getName(), DynamicTypeDescription.INSTANCE);
    }
}

