/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeIds;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.UnknownType;
import oracle.bpm.type.Variable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TypeLoader
extends DefaultHandler {
    private Object current;
    private Handler currentHandler;
    private Handler documentHandler;
    private Stack handlerStack;
    private ComponentCatalog loader;
    private Stack objectStack;
    private SAXParser parser;
    private Handler skipHandler;

    public TypeLoader(ComponentCatalog loader) throws ParserConfigurationException, SAXException {
        this.loader = loader;
        this.objectStack = new Stack();
        this.handlerStack = new Stack();
        this.documentHandler = new DocumentHandler();
        this.skipHandler = new Handler("unknown");
        SAXParserFactory spf = SAXParserFactory.newInstance();
        this.parser = spf.newSAXParser();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentHandler.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.currentHandler.endElement(uri, localName, qName);
    }

    public TypeDescription parse(File source) throws SAXException, IOException {
        this.currentHandler = this.documentHandler;
        this.parser.parse(source, (DefaultHandler)this);
        return (TypeDescription)this.current;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currentHandler.startElement(uri, localName, qName, attributes);
    }

    protected TypeRef findType(String text) {
        TypeRef type;
        try {
            type = this.loader.find(text);
        }
        catch (AmbiguousTypeNameException e) {
            type = null;
        }
        return type != null ? type : UnknownType.create(text, null);
    }

    protected void reportError(String message) {
        System.err.println(message);
    }

    class VariableHandler
    extends Handler {
        VariableHandler() {
            super("var");
        }

        @Override
        public Object create(Object current, Attributes attrs) {
            Variable var = new Variable(attrs.getValue("name"), TypeFactory.getAny());
            int length = attrs.getLength();
            block4: for (int i = 0; i < length; ++i) {
                String value = attrs.getValue(i);
                String name = attrs.getLocalName(i);
                switch (TypeIds.attribute(name)) {
                    case 1: {
                        var.setName(value);
                        continue block4;
                    }
                    case 3: {
                        var.setType(TypeLoader.this.findType(value));
                    }
                }
            }
            MethodTypeDescription method = (MethodTypeDescription)current;
            method.addVariable(var);
            return var;
        }
    }

    class PropertyHandler
    extends Handler {
        PropertyHandler() {
            super("property");
        }

        @Override
        public Object create(Object current, Attributes attrs) {
            String propertyName = null;
            String propertyValue = null;
            int length = attrs.getLength();
            block4: for (int i = 0; i < length; ++i) {
                String value = attrs.getValue(i);
                String name = attrs.getLocalName(i);
                switch (TypeIds.attribute(name)) {
                    case 1: {
                        propertyName = value;
                        continue block4;
                    }
                    case 7: {
                        propertyValue = value;
                    }
                }
            }
            ObjectTypeDescription type = (ObjectTypeDescription)current;
            type.setProperty(propertyName, propertyValue);
            return null;
        }
    }

    class MethodHandler
    extends Handler {
        MethodHandler() {
            super("method");
            this.handlers.put("arg", new ArgumentHandler());
            this.handlers.put("variable", new VariableHandler());
        }

        @Override
        public Object create(Object current, Attributes attrs) {
            MethodTypeDescription method = this.create(current);
            int length = attrs.getLength();
            block4: for (int i = 0; i < length; ++i) {
                String value = attrs.getValue(i);
                String name = attrs.getLocalName(i);
                switch (TypeIds.attribute(name)) {
                    case 1: {
                        method.setName(value);
                        continue block4;
                    }
                    case 2: {
                        method.setModifiers(Modifier.getModifiers(value));
                    }
                }
            }
            ObjectTypeDescription parent = (ObjectTypeDescription)current;
            parent.addMember(method);
            return method;
        }

        protected MethodTypeDescription create(Object current) {
            return new MethodTypeDescription("");
        }

        void characters(Object current, char[] chars, int start, int length) {
            MethodTypeDescription method = (MethodTypeDescription)current;
            String text = new String(chars, start, length);
            method.setCode(text, method.getCodeLanguage());
        }
    }

    class InheritanceHandler
    extends Handler {
        InheritanceHandler() {
            super("inherit");
        }

        @Override
        public Object create(Object current, Attributes attrs) {
            TypeRef type = TypeFactory.getAny();
            long modifiers = 0L;
            int length = attrs.getLength();
            block4: for (int i = 0; i < length; ++i) {
                String value = attrs.getValue(i);
                String name = attrs.getLocalName(i);
                switch (TypeIds.attribute(name)) {
                    case 4: {
                        type = TypeLoader.this.findType(value);
                        continue block4;
                    }
                    case 2: {
                        modifiers = Modifier.getModifiers(value);
                    }
                }
            }
            SuperType cl = new SuperType(type, modifiers);
            ((ObjectTypeDescription)current).addSuperType(cl);
            return cl;
        }
    }

    class Handler
    extends DefaultHandler {
        protected Map handlers;
        protected String tagName;

        Handler(String tagName) {
            this.tagName = tagName;
            this.handlers = new HashMap();
        }

        @Override
        public final void endElement(String uri, String localName, String qName) {
            TypeLoader.this.current = TypeLoader.this.objectStack.pop();
            TypeLoader.this.currentHandler = (Handler)TypeLoader.this.handlerStack.pop();
        }

        @Override
        public final void startElement(String uri, String localName, String qName, Attributes attributes) {
            try {
                int index = qName.lastIndexOf(58);
                qName = qName.substring(index + 1);
                TypeLoader.this.handlerStack.push(TypeLoader.this.currentHandler);
                TypeLoader.this.objectStack.push(TypeLoader.this.current);
                TypeLoader.this.currentHandler = (Handler)this.handlers.get(qName);
                if (TypeLoader.this.currentHandler == null) {
                    TypeLoader.this.currentHandler = TypeLoader.this.skipHandler;
                }
                TypeLoader.this.current = TypeLoader.this.currentHandler.create(TypeLoader.this.current, attributes);
            }
            catch (Exception unexpected) {
                unexpected.printStackTrace();
                TypeLoader.this.reportError(unexpected.toString());
                TypeLoader.this.current = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        public Object create(Object current, Attributes attributes) {
            return null;
        }

        public String toString() {
            return "Handler(" + this.tagName + ")";
        }
    }

    class DocumentHandler
    extends Handler {
        DocumentHandler() {
            super("document");
            this.handlers.put("class", new ClassHandler());
        }
    }

    class ClassHandler
    extends Handler {
        ClassHandler() {
            super("class");
            this.handlers.put("inherit", new InheritanceHandler());
            this.handlers.put("property", new PropertyHandler());
            this.handlers.put("method", new MethodHandler());
            this.handlers.put("attribute", new AttributeHandler());
        }

        @Override
        public Object create(Object current, Attributes attrs) {
            ObjectTypeDescription type = new ObjectTypeDescription("");
            int length = attrs.getLength();
            block4: for (int i = 0; i < length; ++i) {
                String value = attrs.getValue(i);
                String name = attrs.getLocalName(i);
                switch (TypeIds.attribute(name)) {
                    case 1: {
                        type.setName(value);
                        continue block4;
                    }
                    case 2: {
                        type.setModifiers(Modifier.getModifiers(value));
                    }
                }
            }
            if (current != null) {
                ObjectTypeDescription parent = (ObjectTypeDescription)current;
                parent.addInnerType(type);
            }
            return type;
        }
    }

    class AttributeHandler
    extends MethodHandler {
        AttributeHandler() {
            this.tagName = "attribute";
            this.handlers.put("arg", new ArgumentHandler());
            this.handlers.put("var", new VariableHandler());
        }

        @Override
        public Object create(Object current, Attributes attrs) {
            AttributeTypeDescription attr = (AttributeTypeDescription)super.create(current, attrs);
            return attr;
        }

        @Override
        protected MethodTypeDescription create(Object current) {
            return new AttributeTypeDescription("", TypeFactory.getAny());
        }
    }

    class ArgumentHandler
    extends Handler {
        ArgumentHandler() {
            super("arg");
        }

        @Override
        public Object create(Object current, Attributes attrs) {
            Argument arg = new Argument(attrs.getValue("name"), TypeFactory.getAny(), 1L);
            int length = attrs.getLength();
            block5: for (int i = 0; i < length; ++i) {
                String value = attrs.getValue(i);
                String name = attrs.getLocalName(i);
                switch (TypeIds.attribute(name)) {
                    case 1: {
                        arg.setName(value);
                        continue block5;
                    }
                    case 3: {
                        arg.setType(TypeLoader.this.findType(value));
                        continue block5;
                    }
                    case 2: {
                        arg.setModifiers(Modifier.getModifiers(value));
                    }
                }
            }
            MethodTypeDescription method = (MethodTypeDescription)current;
            method.addVariable(arg);
            return arg;
        }
    }
}

