/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.io.File;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.type.AbstractTypeRef;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeCache;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeHandleIterator;
import oracle.bpm.type.TypeInfo;
import oracle.bpm.type.TypeList;
import oracle.bpm.type.TypeObserver;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.UnknownType;
import oracle.bpm.type.catalog.ComponentBundle;
import oracle.bpm.type.catalog.DirectoryComponentBundle;
import oracle.bpm.type.catalog.XcdlComponentBundle;
import oracle.bpm.util.ProgressMonitor;
import org.jetbrains.annotations.NotNull;

class TypeHandle
extends AbstractTypeRef
implements Serializable,
TypeList,
TypeObserver {
    protected TypeCache cache;
    TypeHandle next;
    private transient ComponentBundle bundle;
    private String componentPath;
    private TypeInfo info;
    private transient boolean invalid = false;
    private long lastModifiedTime;
    private String name;
    private transient SoftReference ref;
    private transient TypeDescription strong;
    private boolean virtual = false;
    private static final TypeInfo VIRTUAL_INFO = new TypeInfo();
    static final long serialVersionUID = -6389109017524295098L;
    static final long serialCheck = -5474438553110732032L;

    TypeHandle(ObjectTypeDescription root, ComponentBundle bundle, String componentPath, String name, TypeCache cache, boolean virtual) {
        if (componentPath != null) {
            boolean condition;
            boolean bl = condition = !componentPath.startsWith(".");
            assert (condition) : componentPath;
        }
        assert (!name.endsWith(".xcdl")) : name;
        this.cache = cache;
        this.componentPath = componentPath;
        this.name = name;
        this.virtual = virtual;
        this.bundle = bundle;
        if (root != null) {
            TypeInfo typeInfo = new TypeInfo(root);
            this.setInfo(typeInfo);
            if (root.isSynthesized()) {
                this.strong = root;
            }
        }
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = this == obj;
        if (!result && obj instanceof TypeRef) {
            TypeRef other = (TypeRef)obj;
            result = this.getText().equals(other.getText());
        }
        return result;
    }

    @Override
    public TypeDescription get() {
        TypeDescription result = null;
        MutableComponentCatalog repository = this.cache.getRepository();
        if (!this.invalid) {
            TypeDescription type = this.getIfLoaded();
            if (type == null) {
                try {
                    type = this.load();
                }
                catch (TypeCatalogException e) {
                    e.printStackTrace();
                    type = UnknownType.create(this.getText(), (ComponentCatalog)repository, e);
                }
            }
            result = type;
        }
        if (result == null) {
            result = UnknownType.create(this.getText(), repository);
        }
        return result;
    }

    public boolean isValid() {
        return !this.invalid;
    }

    @Override
    public ComponentCatalog getCatalog() {
        return this.cache.getRepository();
    }

    @Override
    public boolean isFromCatalog(ComponentCatalog catalog) {
        return this.cache.getRepository() == catalog;
    }

    @Override
    public String getComponentType() {
        return this.getInfo().getType();
    }

    @Override
    public int getCount() {
        return 1 + (this.hasNext() ? this.getNext().getCount() : 0);
    }

    public boolean hasNext() {
        return this.getNext() != null;
    }

    @Override
    public int getKind() {
        if (this.isValid()) {
            TypeInfo info = this.getInfo();
            return "true".equals(info.getProperty("isEnum")) ? 17 : 11;
        }
        return -1;
    }

    @Override
    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Override
    public long getModifiers() {
        if (this.isValid()) {
            TypeDescription type = this.getIfLoaded();
            return type != null ? type.getModifiers() : this.getInfo().getFlags();
        }
        return 0L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TypeRef getRef() {
        return this;
    }

    @Override
    public String getText() {
        String text = this.name;
        if (this.componentPath != null && !this.componentPath.equals("")) {
            text = this.componentPath + "." + text;
        }
        return text;
    }

    @Override
    public TypeList getType(int index) {
        return index == 0 ? this : this.getNext().getType(index - 1);
    }

    public boolean hasChildren() {
        TypeDescription type = this.getIfLoaded();
        if (type != null) {
            return type.asObject().getInnerTypeCount() > 0;
        }
        if (!this.isVirtual() && this.getBundle() instanceof DirectoryComponentBundle) {
            try {
                DirectoryComponentBundle dirBundle = (DirectoryComponentBundle)this.getBundle();
                File dir = dirBundle.getDirForType(this.getText());
                if (!dir.exists()) {
                    return false;
                }
                String[] files = dir.list(XcdlComponentBundle.SUFFIX_FILTER);
                if (files != null) {
                    return files.length > 0;
                }
            }
            catch (TypeCatalogException typeCatalogException) {
                // empty catch block
            }
        }
        return this.cache.hasChildren(this.getText());
    }

    public int hashCode() {
        return this.getText().hashCode();
    }

    public String toString() {
        String text = "";
        TypeHandle current = this;
        while (current != null) {
            text = text + current.getText();
            if ((current = current.getNext()) == null) continue;
            text = text + ", ";
        }
        return "[" + text + "]";
    }

    public void updateInfo(ObjectTypeDescription type) {
        this.setInfo(new TypeInfo(type));
    }

    public TypeHandle getForModule(String module) {
        return module.equals(this.getModule()) ? this : this.nextForModuleOrNull(module);
    }

    public void findByModule(String module, List<TypeHandle> result) {
        if (!this.invalid && module.equals(this.getModule())) {
            result.add(this);
        }
        if (this.hasNext()) {
            this.getNext().findByModule(module, result);
        }
    }

    public void findByBundleId(String id, Set<TypeHandle> result) {
        if (!this.invalid && this.bundle != null && this.bundle.getUniqueId().equals(id)) {
            result.add(this);
        }
        if (this.hasNext()) {
            this.getNext().findByBundleId(id, result);
        }
    }

    @Override
    public Iterator<TypeList> iterator() {
        return new TypeHandleIterator(this);
    }

    @Override
    public void typeChanged(TypeRef typeRef) {
        super.fireTypeChanged();
    }

    @Override
    public void typeMemberAdded(TypeRef ref) {
        super.fireTypeMemberAdded(ref);
    }

    @Override
    public void typeMemberRemoved(TypeRef ref) {
        super.fireTypeMemberRemoved(ref);
    }

    public TypeHandle findFirstValid() {
        TypeHandle result = this.isValid() ? this : (this.hasNext() ? this.getNext().findFirstValid() : null);
        return result;
    }

    protected ComponentBundle getBundle() {
        return this.bundle;
    }

    @Override
    protected void someIsObservingUs() {
        TypeDescription ifLoaded = this.getIfLoaded();
        if (ifLoaded != null) {
            ifLoaded.addObserver(this);
        }
    }

    @Override
    protected void noOneLeftObservingUs() {
        TypeDescription ifLoaded = this.getIfLoaded();
        if (ifLoaded != null) {
            ifLoaded.removeObserver(this);
        }
    }

    void revalidate(ObjectTypeDescription root, ComponentBundle bundle, TypeCache cache, boolean virtual) {
        this.cache = cache;
        this.virtual = virtual;
        this.bundle = bundle;
        if (root != null) {
            TypeInfo typeInfo = new TypeInfo(root);
            this.setInfo(typeInfo);
            if (root.isSynthesized()) {
                this.strong = root;
            }
        }
        this.invalid = false;
    }

    void free() {
        if (this.ref != null) {
            this.ref.clear();
            this.ref = null;
        }
        this.clearInfo();
    }

    TypeDescription getIfLoaded() {
        if (this.strong != null) {
            return this.strong;
        }
        if (this.ref != null) {
            return (TypeDescription)this.ref.get();
        }
        return null;
    }

    TypeInfo getInfo() {
        if (this.info == null && this.isValid()) {
            this.loadInfo();
        }
        return this.info;
    }

    String getModule() {
        return this.componentPath;
    }

    TypeHandle getNext() {
        return this.next;
    }

    void invalidate() {
        if (!this.invalid) {
            this.invalid = true;
            this.ref = null;
            this.clearInfo();
            if (this.strong != null) {
                this.strong = null;
            }
            this.lastModifiedTime = -1L;
        }
    }

    boolean isStrong() {
        return this.strong != null;
    }

    boolean isVirtual() {
        return this.virtual;
    }

    void loadInfo() {
        try {
            if (this.isVirtual()) {
                this.setInfo(VIRTUAL_INFO);
            } else if (this.isStrong()) {
                TypeInfo typeInfo;
                if (this.strong.isObject()) {
                    typeInfo = new TypeInfo(this.strong.asObject());
                } else {
                    typeInfo = new TypeInfo();
                    typeInfo.setType(this.strong.getComponentType());
                    typeInfo.setSignature(this.strong.getSignature());
                    typeInfo.setFlags(this.strong.getModifiers());
                }
                this.setInfo(typeInfo);
            } else {
                this.setInfo(this.getBundle().loadHeader(this.getText(), null, this.getCatalog()));
            }
        }
        catch (TypeCatalogException e) {
            this.info = null;
            throw ProgramException.wrap("Error while loading the Type Header '" + this.getText() + "'", e);
        }
    }

    void set(TypeDescription type) {
        if (type != null && type.isSynthesized()) {
            this.strong = type;
        } else {
            this.ref = new SoftReference<TypeDescription>(type);
        }
    }

    void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    void setNext(TypeHandle next) {
        this.next = next;
    }

    private void setInfo(@NotNull TypeInfo typeInfo) {
        if (typeInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeHandle.setInfo must not be null");
        }
        this.clearInfo();
        this.info = typeInfo;
        this.cache.getPropertyIndex().addType(this.getText(), this.info);
    }

    private void clearInfo() {
        if (this.info != null) {
            this.cache.getPropertyIndex().removeType(this.getText(), this.info);
            this.info = null;
        }
    }

    private TypeDescription load() throws TypeCatalogException {
        try {
            ObjectTypeDescription type;
            this.incrLoading();
            ProgressMonitor monitor = this.cache.getMonitor();
            if (monitor != null) {
                monitor.info(2, LibMsg.LOADING_FROM(this.getText(), this.bundle == null ? null : this.bundle.getUniqueId()));
            }
            MutableComponentCatalog repository = this.cache.getRepository();
            TypeHandle parent = this.cache.getExactMatch(this.getModule());
            if (this.isVirtual()) {
                type = new ObjectTypeDescription(this.name);
                type.addModifier(0x100000000L);
                type.setCatalog(repository);
                type.setRef(this);
            } else {
                type = (ObjectTypeDescription)this.getBundle().loadType(this.getText(), parent != null ? parent.getText() : null, this.getCatalog());
            }
            type.setParent(parent);
            type.setCatalog(repository);
            type.setRef(this);
            this.set(type);
            type.addObserver(this);
            if (this.isObserved()) {
                type.addObserver(this);
            }
            this.loadInnerTypes(type);
            type.setLastModifiedTime(this.getLastModifiedTime());
            ObjectTypeDescription objectTypeDescription = type;
            return objectTypeDescription;
        }
        catch (TypeCatalogException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TypeCatalogException(this.cache.getRepository(), this.getText(), e);
        }
        catch (Throwable e) {
            throw new TypeCatalogException(this.cache.getRepository(), this.getText(), new RuntimeException(e.getMessage(), e));
        }
        finally {
            this.decrLoading();
        }
    }

    private void loadInnerTypes(ObjectTypeDescription parent) {
        for (TypeHandle typeRef : this.cache.findByModule(this.getText())) {
            boolean alreadyAdded = parent.findInnerType(typeRef.getName()) != null;
            if (alreadyAdded) continue;
            parent.addInnerType(typeRef);
        }
    }

    private TypeHandle nextForModuleOrNull(String module) {
        return this.hasNext() ? this.getNext().getForModule(module) : null;
    }

    static {
        VIRTUAL_INFO.setType("object");
        VIRTUAL_INFO.setId("");
    }
}

