/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.ArrayList;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeUtils;
import org.jetbrains.annotations.Nullable;

public class TypeFinder {
    private static final MethodTypeDescription[] EMPTY_MTD_ARRAY = new MethodTypeDescription[0];

    public static MethodTypeDescription[] findClosestMembers(TypeDescription td, String name, int maxDistance) {
        return TypeFinder.findClosestMembers(td, name, maxDistance, -1);
    }

    public static MethodTypeDescription[] findClosestMembers(TypeDescription td, String name, int maxDistance, int reqKind) {
        TypeDescription[] hierarchy = td.allHierarchy();
        ArrayList<MethodTypeDescription> closestMembers = null;
        int minDistance = maxDistance;
        for (TypeDescription current : hierarchy) {
            int length = current.getMemberCount();
            for (int j = 0; j < length; ++j) {
                MethodTypeDescription memberType = current.getMemberType(j);
                if (reqKind != -1 && memberType.getKind() != reqKind) continue;
                int dist = TypeUtils.memberDistance(name, memberType.getName());
                if (dist < minDistance) {
                    if (closestMembers != null) {
                        closestMembers.clear();
                    } else {
                        closestMembers = new ArrayList<MethodTypeDescription>();
                    }
                    closestMembers.add(memberType);
                    minDistance = dist;
                    continue;
                }
                if (dist != minDistance) continue;
                if (closestMembers == null) {
                    closestMembers = new ArrayList();
                }
                closestMembers.add(memberType);
            }
        }
        return closestMembers == null ? EMPTY_MTD_ARRAY : closestMembers.toArray(EMPTY_MTD_ARRAY);
    }

    @Nullable
    public static MethodTypeDescription findMemberImpl(TypeDescription td, String name, int reqKind, Scope scope) {
        ObjectTypeDescription asObject;
        MethodTypeDescription member = null;
        if (name != null) {
            TypeDescription parent;
            if (scope.isCurrent()) {
                int count = td.getMemberCount();
                for (int i = 0; i < count; ++i) {
                    MethodTypeDescription current = td.getMemberType(i);
                    if (!Any.equals(current.getName(), name) || reqKind != -1 && current.getKind() != reqKind) continue;
                    member = current;
                    break;
                }
            }
            if (member == null && scope.isInherited()) {
                for (SuperType cl : td.getSuperTypes()) {
                    if (cl.isDelegated()) continue;
                    member = TypeFinder.findMemberImpl(cl.getType(), name, reqKind, Scope.DEFAULT);
                    if ((member = TypeFinder.filterConstructor(member)) == null) continue;
                    break;
                }
            }
            if (member == null && scope.isDelegated()) {
                for (SuperType cl : td.getSuperTypes()) {
                    if (!cl.isDelegated()) continue;
                    member = TypeFinder.findMemberImpl(cl.getType(), name, reqKind, Scope.DEFAULT);
                    if ((member = TypeFinder.filterConstructor(member)) == null) continue;
                    break;
                }
            }
            if (member == null && scope.isParent() && td.isInnerType() && (parent = td.getParent()) != null) {
                member = TypeFinder.findMemberImpl(parent, name, reqKind, Scope.ALL);
                member = TypeFinder.filterConstructor(member);
            }
        }
        if (member == null && !td.isObject() && (asObject = td.asObject()) != td) {
            member = TypeFinder.findMemberImpl(asObject, name, reqKind, scope);
        }
        return member;
    }

    private static MethodTypeDescription filterConstructor(MethodTypeDescription member) {
        return member != null && member.isConstructor() ? null : member;
    }

    public static enum Scope {
        CURRENT,
        DELEGATED,
        INHERITED,
        ALL_INHERITED,
        DEFAULT,
        PARENT,
        ALL;


        public boolean isCurrent() {
            return this == CURRENT || this == DEFAULT || this == ALL;
        }

        public boolean isInherited() {
            return this == INHERITED || this == ALL_INHERITED || this == DEFAULT || this == ALL;
        }

        public boolean isDelegated() {
            return this == DELEGATED || this == ALL_INHERITED || this == DEFAULT || this == ALL;
        }

        public boolean isParent() {
            return this == PARENT || this == ALL;
        }
    }
}

