/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.ArrayList;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.type.Diff;
import oracle.bpm.type.MethodDiff;

public class TypeDiff
implements Diff {
    protected String description;
    private Diff[] added;
    private Diff[] modified;
    private Diff[] removed;
    private static Diff[] DIFF_ARRAY = new Diff[0];

    public static TypeDiff create(ObjectTypeDescription oldType, ObjectTypeDescription newType) {
        int i;
        TypeDiff diff = new TypeDiff();
        if (!oldType.getName().equals(newType.getName())) {
            diff.description = "Name has changed from " + oldType.getName() + " to " + newType.getName();
        }
        ArrayList<MethodDiff> added = new ArrayList<MethodDiff>();
        ArrayList<MethodDiff> removed = new ArrayList<MethodDiff>();
        ArrayList<MethodDiff> modified = new ArrayList<MethodDiff>();
        int count = newType.getMemberCount();
        for (i = 0; i < count; ++i) {
            if (!newType.getMemberType(i).isMethod()) continue;
            for (MethodTypeDescription newMethod = newType.getMemberType(i); newMethod != null; newMethod = newMethod.getNextMethod()) {
                MethodTypeDescription oldMethod = oldType.getMemberTypeBySignature(newMethod.getSignature());
                MethodDiff methodDiff = MethodDiff.create(oldMethod, newMethod);
                if (oldMethod == null) {
                    added.add(methodDiff);
                    continue;
                }
                modified.add(methodDiff);
            }
        }
        count = oldType.getMemberCount();
        for (i = 0; i < count; ++i) {
            if (!oldType.getMemberType(i).isMethod()) continue;
            for (MethodTypeDescription oldMethod = oldType.getMemberType(i); oldMethod != null; oldMethod = oldMethod.getNextMethod()) {
                MethodTypeDescription newMethod = newType.getMemberTypeBySignature(oldMethod.getSignature());
                if (newMethod != null) continue;
                removed.add(MethodDiff.create(oldMethod, newMethod));
            }
        }
        diff.added = added.toArray(DIFF_ARRAY);
        diff.removed = removed.toArray(DIFF_ARRAY);
        diff.modified = modified.toArray(DIFF_ARRAY);
        return diff;
    }

    @Override
    public Diff[] getAdded() {
        return this.added;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Diff[] getModified() {
        return this.modified;
    }

    @Override
    public Diff[] getRemoved() {
        return this.removed;
    }

    @Override
    public void ignore() {
    }

    @Override
    public void patch() {
    }
}

