/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.type.Argument;
import oracle.bpm.util.Identifier;
import oracle.bpm.util.ProgressMonitor;

public class TypeBeautifier {
    private Map<String, String> stringPool = new HashMap<String, String>();

    public void beautify(ObjectTypeDescription[] roots, ProgressMonitor monitor) {
        this.beautify(roots, monitor, null);
    }

    public void beautify(ObjectTypeDescription[] roots, ProgressMonitor monitor, Map properties) {
        this.beautify(roots, monitor, properties, true);
    }

    public void beautify(ObjectTypeDescription[] roots, ProgressMonitor monitor, Map properties, boolean recurse) {
        TreeMap<String, ObjectTypeDescription> processed = new TreeMap<String, ObjectTypeDescription>(String.CASE_INSENSITIVE_ORDER);
        LinkedList<ObjectTypeDescription> valid = new LinkedList<ObjectTypeDescription>();
        LinkedList<ObjectTypeDescription> invalid = new LinkedList<ObjectTypeDescription>();
        for (ObjectTypeDescription innerType : roots) {
            this.beautify(innerType, monitor, properties, recurse);
            String innerName = innerType.getName();
            if (Identifier.isValidClassName(innerName)) {
                valid.add(innerType);
                continue;
            }
            invalid.add(innerType);
        }
        for (ObjectTypeDescription otd : valid) {
            String name = otd.getName();
            if (processed.containsKey(name)) {
                otd.setName(this.intern(TypeBeautifier.suggestAltName(name)));
            }
            processed.put(name, otd);
        }
        for (ObjectTypeDescription otd : invalid) {
            String validName = Identifier.classname(otd.getName());
            if (processed.containsKey(validName)) {
                validName = TypeBeautifier.suggestAltName(validName);
            }
            validName = this.intern(validName);
            otd.setName(validName);
            processed.put(validName, otd);
        }
        String prefix = properties != null ? (String)properties.get("TYPE_PREFIX") : null;
        for (ObjectTypeDescription otd : processed.values()) {
            if (prefix != null && otd.getParentRef() != null && !otd.getName().startsWith(prefix)) {
                otd.setName(prefix + otd.getName());
            }
            this.beautify(otd, monitor, properties, recurse);
        }
    }

    private static String suggestAltName(String name) {
        int len;
        int d;
        int lastDigit;
        int number = 0;
        for (lastDigit = len = name.length(); lastDigit > 0 && (d = Character.digit(name.charAt(lastDigit - 1), 10)) != -1; --lastDigit) {
            int shift = 10 * (len - lastDigit);
            shift = shift == 0 ? 1 : shift;
            number += d * shift;
        }
        return name.substring(0, lastDigit) + (number + 1);
    }

    private void beautify(ObjectTypeDescription object, ProgressMonitor monitor, Map properties, boolean recurse) {
        int innerCount = object.getInnerTypeCount();
        if (innerCount != 0) {
            monitor.info(0, LibMsg.BEAUTIFYING_MODULE(object.getText()));
        }
        for (MethodTypeDescription member : object.getMembers(-1)) {
            if (object.isEnum()) {
                String newName = Identifier.constant(member.getName());
                if (newName.equals(member.getName())) continue;
                object.renameMember(member, this.intern(newName));
                continue;
            }
            this.beautify(member);
        }
        if (recurse) {
            ObjectTypeDescription[] inners = new ObjectTypeDescription[innerCount];
            for (int i = 0; i < innerCount; ++i) {
                inners[i] = object.getInnerType(i);
            }
            this.beautify(inners, monitor, properties);
        }
    }

    private void beautify(MethodTypeDescription method) {
        if (method.isAttribute()) {
            this.beautify(method.asAttribute());
            return;
        }
        if (method.isHidden()) {
            return;
        }
        ObjectTypeDescription type = method.getParent().asObject();
        HashSet<String> argNames = null;
        for (MethodTypeDescription current = method; current != null; current = current.getNextMethod()) {
            String newName;
            String name = current.getName();
            if (!current.isConstructor() && !(newName = Identifier.method(name)).equals(name)) {
                if (this.findMethodByMatchingArgs(type, newName, current) != null) {
                    String baseName = newName;
                    int next = 2;
                    while (this.findMethodByMatchingArgs(type, newName = baseName + next++, current) != null) {
                    }
                }
                type.renameMember(current, this.intern(newName));
            }
            int argn = 1;
            int argc = current.getArgumentCount();
            if (argc > 0 && argNames == null) {
                argNames = new HashSet<String>();
            }
            for (int i = 0; i < argc; ++i) {
                Argument arg = current.getArgument(i);
                String argName = arg.getName();
                String string = argName = argName != null ? Identifier.argument(argName) : null;
                assert (argNames != null) : "argNames cannot be null";
                if (argName == null || argName.equals("")) {
                    while (argNames.contains(argName = "arg" + argn++)) {
                    }
                }
                if (argNames.contains(argName)) {
                    String prefix = argName;
                    int next = 2;
                    while (argNames.contains(argName = prefix + next++)) {
                    }
                }
                argName = this.intern(argName);
                arg.setName(argName);
                argNames.add(argName);
            }
            if (argNames == null) continue;
            argNames.clear();
        }
    }

    private void beautify(AttributeTypeDescription attribute) {
        String newName;
        String name = attribute.getName();
        long mods = attribute.getModifiers();
        String string = newName = Modifier.isStatic(mods) && Modifier.isFinal(mods) ? Identifier.constant(name) : Identifier.attribute(name);
        if (!newName.equals(name)) {
            ObjectTypeDescription type = attribute.getParent().asObject();
            if (type.findAttribute(newName) != null) {
                String baseName = newName;
                int next = 2;
                while (type.findAttribute(newName = baseName + next++) != null) {
                }
            }
            type.renameMember(attribute, this.intern(newName));
        }
    }

    private MethodTypeDescription findMethodByMatchingArgs(ObjectTypeDescription type, String method, MethodTypeDescription args) {
        MethodTypeDescription result;
        for (result = type.findMethod(method); result != null && !result.matchArguments(args); result = result.getNextMethod()) {
        }
        return result;
    }

    private String intern(String text) {
        if (!this.stringPool.containsKey(text)) {
            this.stringPool.put(text, text);
        }
        return this.stringPool.get(text);
    }
}

