/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import javax.xml.namespace.QName;
import oracle.bpm.lang.DelegatedMethodTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.NamespacedTypeDescription;
import oracle.bpm.lang.ServiceObject;
import oracle.bpm.lang.ServiceUUID;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceObjectFactory {
    public static ServiceObject createForBpmObjectType(final XObjectTypeDescription xotd) {
        return new ServiceObject(){

            @Override
            @NotNull
            public QName getServiceQName() {
                return ServiceObjectFactory.getDelegatedServiceQName(xotd);
            }

            @Override
            public QName getCallbackServiceQName() {
                QName qName = null;
                XObjectTypeDescription callbackXotd = ServiceObjectFactory.getCallback(xotd);
                if (callbackXotd != null) {
                    qName = ServiceObjectFactory.getDelegatedServiceQName(callbackXotd);
                }
                return qName;
            }

            @Override
            @NotNull
            public String getTarget() {
                return xotd.getProperty("target");
            }

            @Override
            @Nullable
            public String getTargetPort() {
                return xotd.getProperty("target.port");
            }

            @Override
            public String getServiceLocation() {
                return ServiceObjectFactory.getLocation(xotd);
            }

            @Override
            public boolean isSynchronous() {
                return this.getCallbackServiceQName() == null;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static QName getDelegatedServiceQName(@NotNull XObjectTypeDescription xotd) {
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/ServiceObjectFactory.getDelegatedServiceQName must not be null");
        }
        String serviceId = xotd.getProperty("service.object.id");
        if (serviceId == null) {
            throw new IllegalStateException("Service Id cannot be null: " + xotd.getText());
        }
        ServiceUUID serviceUUID = UUIDFactory.parseServiceId(serviceId);
        QName qName = new QName(serviceUUID.getNamespace(), serviceUUID.getNativeName());
        if (qName == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/ServiceObjectFactory.getDelegatedServiceQName must not return null");
        }
        return qName;
    }

    @Nullable
    private static XObjectTypeDescription getCallback(@NotNull XObjectTypeDescription xotd) {
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/ServiceObjectFactory.getCallback must not be null");
        }
        TypeRef callback = xotd.findInnerType("Callback");
        XObjectTypeDescription callbackXotd = null;
        if (callback != null) {
            callbackXotd = callback.get().asBpmObject();
        }
        return callbackXotd;
    }

    private static MethodTypeDescription findDelegatedMethod(@NotNull XObjectTypeDescription xotd) {
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/ServiceObjectFactory.findDelegatedMethod must not be null");
        }
        DelegatedMethodTypeDescription delegated = null;
        for (MethodTypeDescription method : xotd.getMethods()) {
            if (!method.isDelegated()) continue;
            delegated = method.asDelegated();
            break;
        }
        return delegated;
    }

    private static String getLocation(@NotNull XObjectTypeDescription xotd) {
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/ServiceObjectFactory.getLocation must not be null");
        }
        TypeDescription type = ServiceObjectFactory.getServiceType(xotd);
        String location = null;
        if (type != null) {
            location = ((NamespacedTypeDescription)type).getLocation();
        }
        return location;
    }

    @Nullable
    private static TypeDescription getServiceType(@NotNull XObjectTypeDescription xotd) {
        TypeDescription service;
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/ServiceObjectFactory.getServiceType must not be null");
        }
        MethodTypeDescription mtd = ServiceObjectFactory.findDelegatedMethod(xotd);
        if (mtd != null && mtd.isDelegated()) {
            DelegatedMethodTypeDescription dmtd = mtd.asDelegated();
            TypeRef ref = dmtd.getDelegatedService();
            service = ref.get();
        } else {
            service = null;
        }
        return service;
    }
}

