/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.List;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.util.Identifier;

public class JavaClassGenerator {
    private String javaPackage;

    public void setJavaPackage(String javaPackage) {
        this.javaPackage = javaPackage;
    }

    public String getJavaPackage() {
        return this.javaPackage;
    }

    public void generate(IndentedPrintWriter out, ObjectTypeDescription type) {
        this.generatePackage(out, type);
        out.println();
        this.generateImports(out, type);
        out.println();
        this.generateClassDeclaration(out, type);
        this.generateInheritanceDeclaration(out, type);
        this.generateClassBody(out, type);
    }

    protected void generateImports(IndentedPrintWriter out, ObjectTypeDescription type) {
    }

    protected void generateInheritanceDeclaration(IndentedPrintWriter out, ObjectTypeDescription type) {
        List<SuperType> superTypes = type.getSuperTypes();
        if (superTypes.size() > 0) {
            out.print("    extends ");
            for (int i = 0; i < superTypes.size(); ++i) {
                if (i > 0) {
                    out.print(", ");
                }
                this.generateType(out, superTypes.get(i).getType());
            }
            out.println();
        }
    }

    protected void generatePackage(IndentedPrintWriter out, ObjectTypeDescription type) {
        out.print("package ");
        out.print(this.getJavaPackage());
        out.println(";");
    }

    protected void generateClassDeclaration(IndentedPrintWriter out, ObjectTypeDescription type) {
        out.print("public class ");
        this.generateClassName(out, type);
        out.println();
    }

    protected void generateClassName(IndentedPrintWriter out, ObjectTypeDescription type) {
        this.generateType(out, type);
    }

    protected void generateClassBody(IndentedPrintWriter out, ObjectTypeDescription type) {
        out.println("{");
        out.indent();
        this.generateClassFields(out, type);
        out.println();
        this.generateClassAccessors(out, type);
        this.generateClassMethods(out, type);
        out.dedent();
        out.println("}");
    }

    protected void generateClassFields(IndentedPrintWriter out, ObjectTypeDescription type) {
        for (MethodTypeDescription member : type.getAttributes()) {
            this.generateClassField(out, member);
        }
    }

    protected void generateClassField(IndentedPrintWriter out, MethodTypeDescription member) {
        out.print("private ");
        this.generateType(out, member.getResultType());
        out.print(" ");
        out.print(member.getName());
        out.println(";");
    }

    protected void generateClassAccessors(IndentedPrintWriter out, ObjectTypeDescription type) {
        for (MethodTypeDescription member : type.getAttributes()) {
            this.generateClassAccessor(out, member);
            out.println();
        }
    }

    protected void generateClassAccessor(IndentedPrintWriter out, MethodTypeDescription member) {
        if (member.hasGetter()) {
            this.generateGetter(out, member);
            out.println();
        }
        if (member.hasSetter()) {
            this.generateSetter(out, member);
        }
    }

    protected void generateGetter(IndentedPrintWriter out, MethodTypeDescription member) {
        out.print("public ");
        this.generateType(out, member.getResultType());
        out.print(" ");
        this.generateGetterName(out, member);
        out.println("() {");
        out.indent();
        this.generateGetterBody(out, member);
        out.dedent();
        out.println("}");
    }

    protected void generateGetterName(IndentedPrintWriter out, MethodTypeDescription member) {
        out.print("get");
        out.print(Identifier.capitalize(member.getName()));
    }

    protected void generateGetterBody(IndentedPrintWriter out, MethodTypeDescription member) {
        out.println("return this." + member.getName() + ";");
    }

    protected void generateSetter(IndentedPrintWriter out, MethodTypeDescription member) {
        out.print("public void ");
        this.generateSetterName(out, member);
        out.print("(");
        this.generateType(out, member.getResultType());
        out.println(" value) {");
        out.indent();
        this.generateSetterBody(out, member);
        out.dedent();
        out.println("}");
    }

    protected void generateSetterName(IndentedPrintWriter out, MethodTypeDescription member) {
        out.print("set");
        out.print(Identifier.capitalize(member.getName()));
    }

    protected void generateSetterBody(IndentedPrintWriter out, MethodTypeDescription member) {
        out.println("this." + member.getName() + " = value;");
    }

    protected void generateClassMethods(IndentedPrintWriter out, ObjectTypeDescription type) {
        for (MethodTypeDescription method : type.getMethods()) {
            this.generateClassMethod(out, method);
        }
    }

    protected void generateClassMethod(IndentedPrintWriter out, MethodTypeDescription method) {
    }

    protected void generateType(IndentedPrintWriter out, TypeDescription type) {
        String text;
        if (type.isInvokeable()) {
            text = type.getName();
        } else {
            text = type.getJavaType();
            if (text.startsWith("java.lang.")) {
                text = text.substring("java.lang.".length());
            }
        }
        out.print(text);
    }
}

