/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.collections.factory.CollectionFactory;
import oracle.bpm.log.Log;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.observers.ObjectRelationListener;
import oracle.bpm.type.TypeObserver;
import oracle.bpm.type.TypeRef;

public abstract class AbstractTypeRef
implements TypeRef {
    protected transient int loading = 0;
    private transient Set<TypeObserver> observers = CollectionFactory.createSet();
    private Map<String, List<ObjectPropertyListener>> propertiesObservers = CollectionFactory.createMap();
    private Map<String, List<ObjectRelationListener>> relationObservers = CollectionFactory.createMap();
    public static String ANY_PROPERTY = "__all__";

    @Override
    public void addObserver(TypeObserver observer) {
        if (this.observers.add(observer) && this.observers.size() == 1) {
            this.someIsObservingUs();
        }
    }

    @Override
    public void removeObserver(TypeObserver observer) {
        if (this.observers.remove(observer) && this.observers.isEmpty()) {
            this.noOneLeftObservingUs();
        }
    }

    @Override
    public void addPropertyObserver(String propertyName, ObjectPropertyListener observer) {
        this.getSpecificPropertyObservers(propertyName).add(observer);
    }

    @Override
    public void removePropertyObserver(String propertyName, ObjectPropertyListener observer) {
        this.getSpecificPropertyObservers(propertyName).remove(observer);
    }

    @Override
    public void addRelationObserver(String relationPropertyName, ObjectRelationListener observer) {
        this.getRelationsObservers(relationPropertyName).add(observer);
    }

    @Override
    public void removeRelationObserver(String relationPropertyName, ObjectRelationListener observer) {
        this.getRelationsObservers(relationPropertyName).remove(observer);
    }

    public void fireRelationAdded(String relationName, Object addedElement) {
        for (ObjectRelationListener observer : this.getRelationsObservers(relationName)) {
            try {
                observer.relationAdded(addedElement, relationName);
            }
            catch (Exception e) {
                Log.logWarning(e);
            }
        }
    }

    public void fireTypeChanged() {
        if (!this.isLoading()) {
            for (TypeObserver observer : this.observers.toArray(new TypeObserver[this.observers.size()])) {
                try {
                    if (observer == null) continue;
                    observer.typeChanged(this);
                }
                catch (Exception e) {
                    Log.logWarning(e);
                }
            }
        }
    }

    protected boolean isLoading() {
        return this.loading > 0;
    }

    protected synchronized void incrLoading() {
        ++this.loading;
    }

    protected synchronized void decrLoading() {
        --this.loading;
    }

    protected void someIsObservingUs() {
    }

    protected void noOneLeftObservingUs() {
    }

    protected void fireTypeMemberAdded(TypeRef ref) {
        if (!this.isLoading()) {
            for (TypeObserver observer : this.observers.toArray(new TypeObserver[this.observers.size()])) {
                try {
                    if (observer == null) continue;
                    observer.typeMemberAdded(ref);
                }
                catch (Exception e) {
                    Log.logWarning(e);
                }
            }
        }
    }

    protected void fireTypeMemberRemoved(TypeRef ref) {
        if (!this.isLoading()) {
            for (TypeObserver observer : this.observers.toArray(new TypeObserver[this.observers.size()])) {
                try {
                    if (observer == null) continue;
                    observer.typeMemberRemoved(ref);
                }
                catch (Exception e) {
                    Log.logWarning(e);
                }
            }
        }
    }

    protected boolean isObserved() {
        return !this.observers.isEmpty();
    }

    protected void firePropertyChanged(String propertyName) {
        for (ObjectPropertyListener observer : this.getPropertyObservers(propertyName)) {
            try {
                if (observer == null) continue;
                observer.propertyChanged(this, propertyName);
            }
            catch (Exception e) {
                Log.logWarning(e);
            }
        }
    }

    protected void fireRelationRemoved(String relationName, Object object) {
        for (ObjectRelationListener observer : new ArrayList<ObjectRelationListener>(this.getRelationsObservers(relationName))) {
            try {
                if (observer == null) continue;
                observer.relationRemoved(object, relationName);
            }
            catch (Exception e) {
                Log.logWarning(e);
            }
        }
    }

    protected List<ObjectPropertyListener> getSpecificPropertyObservers(String propertyName) {
        if (!this.propertiesObservers.containsKey(propertyName)) {
            this.propertiesObservers.put(propertyName, CollectionFactory.createList());
        }
        return this.propertiesObservers.get(propertyName);
    }

    private List<ObjectPropertyListener> getPropertyObservers(String propertyName) {
        ArrayList<ObjectPropertyListener> list = new ArrayList<ObjectPropertyListener>();
        list.addAll(this.getSpecificPropertyObservers(propertyName));
        list.addAll(this.getSpecificPropertyObservers(ANY_PROPERTY));
        return list;
    }

    private List<ObjectRelationListener> getRelationsObservers(String relationName) {
        if (!this.relationObservers.containsKey(relationName)) {
            this.relationObservers.put(relationName, CollectionFactory.createList());
        }
        return this.relationObservers.get(relationName);
    }
}

