/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.sql.struct;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.JDBCHelper;
import oracle.bpm.jdbc.DatabaseManager;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.sql.struct.Schema;
import oracle.bpm.type.Argument;

public class SchemaUtils {
    private SchemaUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createSchema(ObjectTypeDescription objectType) throws ConnectorException, SQLException {
        Connection connection = null;
        String sql = null;
        try {
            String configName = objectType.getProperty("configName");
            connection = JDBCHelper.getReadOnlyConnection(configName);
            DatabaseManager mgr = JDBCHelper.getDatabaseManager(configName);
            Schema schema = SchemaUtils.buildFromTypeDescription(objectType);
            sql = mgr.showCreateTables(schema, "user", "password", null);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return sql;
    }

    public static Schema buildFromTypeDescription(ObjectTypeDescription module) {
        String isSchema = module.getProperty("isSchema");
        if (isSchema == null || !isSchema.equals("true") || !module.getComponentType().equals(ComponentType.SQL.getText())) {
            return null;
        }
        String schemaName = module.getName();
        Schema schema = Schema.create(schemaName);
        if (schemaName != null) {
            for (int i = 0; i < module.getInnerTypeCount(); ++i) {
                ObjectTypeDescription member = module.getInnerType(i);
                if (!member.getComponentType().equals(ComponentType.SQL.getText())) continue;
                String memberSchema = member.getProperty("schema");
                if (memberSchema != null && !schemaName.toUpperCase().equals(memberSchema.toUpperCase())) {
                    System.out.println("SCHEMA ISNT EQUAL!");
                    System.out.println("table = " + memberSchema);
                    continue;
                }
                if (member.getSignature().startsWith("oracle.bpm.sql.ProcedureSQLObject")) {
                    SchemaUtils.addProcedure(schema, member);
                    continue;
                }
                SchemaUtils.addTable(schema, member);
            }
        }
        return schema;
    }

    public static int convertKindToFieldType(int kind) {
        switch (kind) {
            case 1: {
                return 2;
            }
            case 8: {
                return 4;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 9;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 11;
            }
            case 4: {
                return 12;
            }
        }
        System.out.println("UNKNOWN kind = " + kind);
        return 3;
    }

    private static void addColumn(Schema.Table table, AttributeTypeDescription columnTypeDescription) {
        String name = columnTypeDescription.getWriteSignature();
        String type = columnTypeDescription.getProperty("sqltype");
        int kind = columnTypeDescription.getType().getKind();
        int intType = SchemaUtils.convertKindToFieldType(kind);
        TypeDescription resultType = columnTypeDescription.getResultType();
        int scale = resultType.getScale();
        int length = resultType.getLength();
        boolean isPk = columnTypeDescription.isPrimaryKey();
        boolean isRequired = columnTypeDescription.isRequired();
        Schema.Field field = new Schema.Field(name, intType, type);
        boolean bl = field.allowNull = !isRequired;
        if (kind != 6) {
            if (scale >= 0) {
                if (length > 0) {
                    field.size = "" + length + ", " + scale;
                } else {
                    assert (scale > 0);
                    field.size = "" + scale;
                }
            } else if (length > 0) {
                field.size = "" + length;
            }
        }
        field.restrictedSize = field.size;
        table.addField(field);
        if (isPk) {
            table.addToPrimaryKey(name);
        }
    }

    private static void addProcedure(Schema schema, ObjectTypeDescription procedureTypeDescription) {
        String procedureName = procedureTypeDescription.getProperty("caseSensitiveName");
        Schema.Procedure procedure = new Schema.Procedure(procedureName);
        schema.addProcedure(procedure);
        int memberCount = procedureTypeDescription.getMemberCount();
        for (int i = 0; i < memberCount; ++i) {
            MethodTypeDescription methodTypeDescription = procedureTypeDescription.getMember(i);
            if (methodTypeDescription.isAttribute() || methodTypeDescription.isConstructor()) continue;
            int argumentCount = methodTypeDescription.getArgumentCount();
            ArrayList<Schema.Argument> arguments = new ArrayList<Schema.Argument>();
            for (int j = 0; j < argumentCount; ++j) {
                Argument argType = methodTypeDescription.getArgument(j);
                TypeDescription type = argType.getType();
                int argumentType = SchemaUtils.convertKindToFieldType(type.getKind());
                long modifiers = argType.getModifiers();
                Schema.Argument argument = new Schema.Argument(argType.getName(), argumentType, argType.getTypeText(), Modifier.isIn(modifiers) ? 0 : (Modifier.isOut(modifiers) ? 1 : 2));
                arguments.add(argument);
            }
            procedure.arguments = arguments;
            procedure.code = "";
        }
    }

    private static void addTable(Schema schema, ObjectTypeDescription tableTypeDescription) {
        String tableName = tableTypeDescription.getProperty("caseSensitiveName");
        Schema.Table table = new Schema.Table(tableName);
        schema.addTable(table);
        List<MethodTypeDescription> attributes = tableTypeDescription.getAttributes();
        if (attributes.isEmpty()) {
            return;
        }
        ObjectTypeDescription.AttributeByPosition orderComparator = ObjectTypeDescription.ATTRIBUTE_BY_POSITION_COMPARATOR;
        Collections.sort(attributes, orderComparator);
        for (MethodTypeDescription attribute : attributes) {
            AttributeTypeDescription column = attribute.asAttribute();
            SchemaUtils.addColumn(table, column);
        }
    }
}

