/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.sql.struct;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.Id;
import oracle.bpm.sql.struct.InvalidSchemaDefinitionException;
import oracle.bpm.sql.struct.SchemaReader;

public class Schema {
    public final String fieldNamePrefix;
    public String name = null;
    public final String tableNamePrefix;
    public final String version;
    private List<Procedure> procedures;
    private Map<String, Procedure> proceduresSearch;
    private Map<String, List<RawSentence>> rawSentcencesByDBType;
    private List<Sequence> sequences;
    private List<Statement> statements;
    private List<Table> tables = new ArrayList<Table>();
    private Map<String, Table> tablesSearch = new HashMap<String, Table>();
    private List<View> views;
    private Map<String, View> viewSearch;
    static final String DEFAULT = "default";

    Schema(String name, String version, String tableNamePrefix, String fieldNamePrefix) {
        this.procedures = new ArrayList<Procedure>();
        this.proceduresSearch = new HashMap<String, Procedure>();
        this.views = new ArrayList<View>();
        this.viewSearch = new HashMap<String, View>();
        this.statements = new ArrayList<Statement>();
        this.rawSentcencesByDBType = new TreeMap<String, List<RawSentence>>(String.CASE_INSENSITIVE_ORDER);
        this.name = name;
        this.sequences = new ArrayList<Sequence>();
        if (version == null) {
            version = Id.getVersionTag();
        }
        this.version = version;
        if (tableNamePrefix == null) {
            tableNamePrefix = "";
        }
        if (fieldNamePrefix == null) {
            fieldNamePrefix = "";
        }
        this.tableNamePrefix = tableNamePrefix;
        this.fieldNamePrefix = fieldNamePrefix;
    }

    public static Schema create(String schemaName) {
        return new Schema(schemaName, Id.getVersionTag(), null, null);
    }

    public static Schema read(String resourceName) {
        InputStream is = Schema.class.getResourceAsStream(resourceName);
        if (is == null) {
            throw new InvalidSchemaDefinitionException("Schema Definition cannot be found! " + resourceName);
        }
        return Schema.read(is);
    }

    public static Schema read(InputStream is) {
        assert (is != null) : "input stream cannot be null";
        try {
            SchemaReader reader = new SchemaReader();
            return reader.parse(is);
        }
        catch (IOException ex) {
            throw new InvalidSchemaDefinitionException(ex);
        }
    }

    public static Schema readSchemaDefinition(String name) {
        InputStream is = Schema.class.getResourceAsStream(name);
        if (is == null) {
            throw new InvalidSchemaDefinitionException("Schema Definition cannot be found!");
        }
        return Schema.readSchemaDefinition(is);
    }

    public static Schema readSchemaDefinition(InputStream is) {
        assert (is != null) : "input stream cannot be null";
        try {
            SchemaReader reader = new SchemaReader();
            return reader.parseHeaderOnly(is);
        }
        catch (IOException ex) {
            throw new InvalidSchemaDefinitionException(ex);
        }
    }

    public List<Procedure> getProcedures() {
        return this.procedures;
    }

    public List<RawSentence> getRawSentences(String dbname) {
        assert (dbname != null) : "The database name cannot be null";
        assert (this.name != null) : "The schema name cannot be null";
        List<RawSentence> sentences = this.rawSentcencesByDBType.get(dbname);
        if (sentences == null) {
            sentences = this.rawSentcencesByDBType.get(DEFAULT);
        }
        if (sentences == null) {
            sentences = new ArrayList<RawSentence>();
        }
        for (RawSentence rawSentence : sentences) {
            rawSentence.setSentence(SchemaReader.resolveSchemaVariable(rawSentence.getSentence(), this.name));
        }
        return sentences;
    }

    public List<Sequence> getSequences() {
        return this.sequences;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public List<Table> getTablesInReverseOrder() {
        ArrayList<Table> tables = new ArrayList<Table>();
        for (int i = this.tables.size() - 1; i >= 0; --i) {
            tables.add(this.tables.get(i));
        }
        return tables;
    }

    public List<View> getViews() {
        for (View view : this.views) {
            view.statement = SchemaReader.resolveSchemaVariable(view.statement, this.name);
        }
        return this.views;
    }

    public void addProcedure(Procedure procedure) {
        this.procedures.add(procedure);
        this.proceduresSearch.put(procedure.name, procedure);
    }

    public void addRawSentence(String dbname, RawSentence sentence) {
        List<RawSentence> sentences = this.rawSentcencesByDBType.get(dbname);
        if (sentences == null) {
            sentences = new ArrayList<RawSentence>();
            this.rawSentcencesByDBType.put(dbname, sentences);
        }
        sentences.add(sentence);
    }

    public void addSequence(Sequence sequence) {
        this.sequences.add(sequence);
    }

    public void addStatement(Statement statement) {
        this.statements.add(statement);
    }

    public void addTable(Table table) {
        this.tables.add(table);
        this.tablesSearch.put(table.name, table);
        for (Field f : table.getFields()) {
            if (f.referencedTable == null) continue;
            Table t = this.tablesSearch.get(f.referencedTable);
            t.addReferencingTable(table);
            table.addReferencingField(f, t);
        }
    }

    public void addView(View view) {
        this.views.add(view);
        this.viewSearch.put(view.name, view);
    }

    public String buildFieldName(String name) {
        assert (name != null);
        return this.fieldNamePrefix + name;
    }

    public String[] buildFieldNames(String[] names) {
        assert (names != null);
        String[] result = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = this.fieldNamePrefix + names[i];
        }
        return result;
    }

    public String buildTableName(String name) {
        assert (name != null);
        return this.tableNamePrefix + name;
    }

    public void checkArgument(String name, Procedure procedure) {
        assert (name != null);
        for (Argument arg : procedure.arguments) {
            if (!arg.name.equalsIgnoreCase(name)) continue;
            throw new InvalidSchemaDefinitionException("Argument [" + name + "] already exists in procedure [" + procedure.name + "]");
        }
    }

    public void checkField(String name, Table table) {
        assert (name != null && table != null);
        for (Field f : table.getFields()) {
            if (!f.name.equalsIgnoreCase(name)) continue;
            throw new InvalidSchemaDefinitionException("Field [" + name + "] already exists in table [" + table.name + "]");
        }
    }

    public void checkFieldExistance(String name, Table table) {
        assert (name != null);
        assert (table != null);
        boolean found = false;
        for (Field f : table.getFields()) {
            if (!f.name.equalsIgnoreCase(name)) continue;
            found = true;
            break;
        }
        if (!found || table.getField(name) == null) {
            throw new InvalidSchemaDefinitionException("Field [" + name + "] was not found in table [" + table.name + "]");
        }
    }

    public void checkForeignKeyField(String[] names, String referencedTable, String[] referencedFields, Table table) {
        assert (names != null);
        assert (referencedTable != null);
        assert (referencedFields != null);
        assert (table != null);
        boolean found = false;
        for (String name : names) {
            for (Field f : table.getFields()) {
                found = f.name.equalsIgnoreCase(name);
                if (!found) continue;
                break;
            }
            if (found) continue;
            throw new InvalidSchemaDefinitionException("Foreign key field [" + name + "] does not exist in table [" + table.name + "]");
        }
        if (!this.tablesSearch.containsKey(referencedTable)) {
            if (!referencedTable.equalsIgnoreCase(table.name)) {
                throw new InvalidSchemaDefinitionException("Foreign key of table[" + table.name + "] -> Referenced table[" + referencedTable + "] does not exist");
            }
        } else {
            Table t = this.tablesSearch.get(referencedTable);
            found = false;
            for (String referencedField : referencedFields) {
                for (Field f : t.getFields()) {
                    if (!f.name.equalsIgnoreCase(referencedField)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new InvalidSchemaDefinitionException("Foreign key of table[" + table.name + "] -> Referenced field[" + referencedField + "] does not exist in referenced table[" + referencedTable + "]");
            }
        }
    }

    public void checkIndex(String name, Table table) {
        assert (name != null && table != null);
        for (Index index : table.getIndexes()) {
            if (!index.name.equalsIgnoreCase(name)) continue;
            throw new InvalidSchemaDefinitionException("Index [" + name + "] already exists in table [" + table.name + "]");
        }
    }

    public void checkIndexField(String indexName, String fieldName, Table table) {
        assert (indexName != null);
        assert (fieldName != null);
        assert (table != null);
        Index index = table.getIndex(indexName);
        for (String field : index.fields) {
            Field f = table.getField(field);
            if (f == null) {
                throw new InvalidSchemaDefinitionException("Field [" + field + "] not found in table [" + table.name + "] for index [" + indexName + "]");
            }
            if (!field.equalsIgnoreCase(fieldName)) continue;
            throw new InvalidSchemaDefinitionException("Field [" + field + "] already exists in index [" + indexName + "]");
        }
    }

    public void checkPrimaryKeyField(String name, Table table) {
        assert (name != null && table != null);
        for (String fieldName : table.getPrimaryKeyFieldNames()) {
            if (!fieldName.equalsIgnoreCase(name)) continue;
            throw new InvalidSchemaDefinitionException("Duplicate field [" + name + "] in primary key of table [" + table.name + "]");
        }
        boolean found = false;
        for (Field f : table.getFields()) {
            if (!f.name.equalsIgnoreCase(name)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new InvalidSchemaDefinitionException("Primary Key field [" + name + "] does not exist in table [" + table.name + "]");
        }
    }

    public void checkProcedure(String name) {
        assert (name != null);
        if (this.proceduresSearch.containsKey(name)) {
            throw new InvalidSchemaDefinitionException("Procedure [" + name + "] already exists");
        }
    }

    public void checkStatement(String name) {
        assert (name != null);
    }

    public void checkTable(String name) {
        assert (name != null);
        Table t = this.tablesSearch.get(name);
        if (t != null) {
            throw new InvalidSchemaDefinitionException("Table [" + name + "] already exists");
        }
    }

    public void checkUniqueField(String name, Table table) {
        assert (name != null && table != null);
        for (String fieldName : table.getUniqueFieldNames()) {
            if (!fieldName.equalsIgnoreCase(name)) continue;
            throw new InvalidSchemaDefinitionException("Duplicate field [" + name + "] in unique constraint of table [" + table.name + "]");
        }
        boolean found = false;
        for (Field f : table.getFields()) {
            if (!f.name.equalsIgnoreCase(name)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new InvalidSchemaDefinitionException("Unique field [" + name + "] does not exist in table [" + table.name + "]");
        }
    }

    public void checkView(String name) {
        assert (name != null);
        if (this.viewSearch.containsKey(name)) {
            throw new InvalidSchemaDefinitionException("View [" + name + "] already exists");
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder("Tables:\n");
        for (Table table : this.tables) {
            s.append("\tName:").append(table.name).append("\n");
            s.append("\tPrimaryKey:");
            s.append(table.getPrimaryKeyFieldNames());
            s.append("\n");
            s.append("\tFields:{");
            for (Field f : table.getFields()) {
                s.append("\n\t\t[");
                s.append("name:").append(f.name).append(",");
                s.append("type:").append(f.type).append(",");
                s.append("size:").append(f.size).append(",");
                s.append("allownull:").append(f.allowNull).append(",");
                s.append("referencedTable:").append(f.referencedTable).append(",");
                s.append("referencedField:").append(f.referencedField).append(",");
                s.append("initial:").append(f.initial).append(",");
                s.append("ondelete:").append(f.ondelete).append(",");
                s.append("when:").append(f.when).append("]\n");
            }
            s.append("\t}\n");
            s.append("\tForeignKeys:[");
            for (ForeignKey fk : table.getForeignKeys()) {
                s.append("[\n\tFields:").append(fk.fields).append("\n");
                s.append("\tReferencedTable:").append(fk.referencedTable).append("\n");
                s.append("\tReferencedFields:").append(fk.referencedFields).append("\n]");
            }
            s.append("]\n");
        }
        s.append("Views:\n");
        for (View view : this.views) {
            s.append("\tName:").append(view.name).append("\n");
            s.append("\tSentence:").append(view.statement).append("\n");
        }
        s.append("Optional Sentences:\n");
        for (Map.Entry entry : this.rawSentcencesByDBType.entrySet()) {
            String name = (String)entry.getKey();
            if (name == null) {
                name = "Default";
            }
            s.append("[\n\tDatabaseType: ").append(name).append("\n");
            s.append("\tSentences: ").append(entry.getValue()).append("\n]");
        }
        return s.toString();
    }

    public static class View {
        public String name;
        public String statement;

        public View(String name, String statement) {
            this.name = name;
            this.statement = statement;
        }
    }

    public static class Table {
        public boolean delete = true;
        public boolean hasAuditInfo = false;
        public int lockType = 0;
        public String name;
        private Map<String, Field> fields;
        private List<ForeignKey> foreignKeys;
        private Map<String, Index> indexes;
        private StringList initializers;
        private StringList primarykeyFields;
        private Map<String, List<Field>> referencingFields;
        private List<Table> tablesReferencing;
        private StringList uniqueFields;
        public static final int DEFAULT_LOCKING = 0;
        public static final int TABLE_LOCKING = 1;
        public static final int ROW_LOCKING = 2;

        public Table(String name) {
            this.name = name;
            this.fields = new HashMap<String, Field>();
            this.primarykeyFields = StringList.create();
            this.uniqueFields = StringList.create();
            this.tablesReferencing = new ArrayList<Table>();
            this.referencingFields = new HashMap<String, List<Field>>();
            this.indexes = new HashMap<String, Index>();
            this.foreignKeys = new ArrayList<ForeignKey>();
            this.initializers = StringList.create();
        }

        public void setDelete(boolean b) {
            this.delete = b;
        }

        public Field getField(String fieldName) {
            return this.fields.get(fieldName);
        }

        public Collection<Field> getFields() {
            return this.fields.values();
        }

        public List<ForeignKey> getForeignKeys() {
            return this.foreignKeys;
        }

        public Index getIndex(String name) {
            return this.indexes.get(name);
        }

        public Collection<Index> getIndexes() {
            return this.indexes.values();
        }

        public StringList getInitializers() {
            return this.initializers;
        }

        public StringList getPrimaryKeyFieldNames() {
            return this.primarykeyFields;
        }

        public List<Field> getReferencingFields(Table table) {
            return this.referencingFields.get(table.name);
        }

        public List<Table> getTablesReferencing() {
            return this.tablesReferencing;
        }

        public StringList getUniqueFieldNames() {
            return this.uniqueFields;
        }

        public void addField(Field field) {
            this.fields.put(field.name, field);
        }

        public void addForeignKey(ForeignKey foreignKey) {
            this.foreignKeys.add(foreignKey);
        }

        public void addIndex(Index index) {
            this.indexes.put(index.name, index);
        }

        public void addInit(String className) {
            this.initializers.add(className);
        }

        public void addReferencingField(Field f, Table parentTable) {
            List<Field> list = this.referencingFields.get(parentTable.name);
            if (list == null) {
                list = new ArrayList<Field>();
            }
            list.add(f);
            this.referencingFields.put(parentTable.name, list);
        }

        public void addReferencingTable(Table table) {
            for (Table t : this.tablesReferencing) {
                if (!t.name.equals(table.name)) continue;
                return;
            }
            this.tablesReferencing.add(table);
        }

        public void addToPrimaryKey(String fieldName) {
            this.primarykeyFields.add(fieldName);
        }

        public void addToUnique(String fieldName) {
            this.uniqueFields.add(fieldName);
        }
    }

    public static class Statement {
        public String table;
        public List<NameValue> values;

        public Statement(String table) {
            this.table = table;
            this.values = new ArrayList<NameValue>();
        }
    }

    public static class Sequence {
        private int initialValue = 1;
        private String name;
        private Schema schema;

        public Sequence(String name, Schema schema) {
            this(name, schema, 1);
        }

        public Sequence(String name, Schema schema, int initialValue) {
            this.name = name;
            this.initialValue = initialValue;
            this.schema = schema;
        }

        public int getInitialValue() {
            return this.initialValue;
        }

        public String getName() {
            return this.name;
        }

        public String getSchemaName() {
            return this.schema.name;
        }
    }

    public static class RawSentence {
        private String sentence;

        public RawSentence(String sentence) {
            this.sentence = sentence;
        }

        public String toString() {
            return this.sentence;
        }

        public String getSentence() {
            return this.sentence;
        }

        public void setSentence(String sentence) {
            this.sentence = sentence;
        }
    }

    public static class Procedure {
        public List<Argument> arguments;
        public String code;
        public String name;

        public Procedure(String name) {
            this.name = name;
            this.arguments = new ArrayList<Argument>();
        }
    }

    public static class NameValue {
        public String name;
        public String value;

        public NameValue(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class Index {
        public StringList fields;
        public String name;
        public boolean unique;

        public Index(String name, boolean unique) {
            this.name = name;
            this.unique = unique;
            this.fields = StringList.create();
        }
    }

    public static class ForeignKey {
        public String fields;
        public int ondelete = -1;
        public String referencedFields;
        public String referencedTable;
        public int when = 2;

        public ForeignKey(String[] fields, String referencedTable, String[] referencedFields) {
            assert (fields.length > 0);
            assert (referencedFields.length == fields.length);
            this.setFields(fields);
            this.setReferencedFields(referencedFields);
            this.referencedTable = referencedTable;
        }

        public ForeignKey(String[] fields, String referencedTable, String[] referencedFields, int when, int ondeleteAction) {
            this.setFields(fields);
            this.setReferencedFields(referencedFields);
            this.referencedTable = referencedTable;
            this.when = when;
            this.ondelete = ondeleteAction;
        }

        private void setFields(String[] fields) {
            this.fields = fields[0];
            for (int i = 1; i < fields.length; ++i) {
                String field = fields[i];
                this.fields = this.fields + "," + field;
            }
        }

        private void setReferencedFields(String[] referencedFields) {
            this.referencedFields = referencedFields[0];
            for (int i = 1; i < referencedFields.length; ++i) {
                String referencedField = referencedFields[i];
                this.referencedFields = this.referencedFields + "," + referencedField;
            }
        }
    }

    public static class Field
    implements Cloneable {
        public boolean allowNull = true;
        public String defaultValue;
        public int initial = 1;
        public boolean isAuditInfoTimestamp = false;
        public String name;
        public int ondelete = -1;
        public String referencedField = null;
        public String referencedTable = null;
        public String restrictedSize = null;
        public String size = null;
        public String strType = null;
        public int type = 14;
        public int when = 2;
        public static final int TYPE_INTEGER = 1;
        public static final int TYPE_BOOLEAN = 2;
        public static final int TYPE_STRING = 3;
        public static final int TYPE_BLOB = 4;
        public static final int TYPE_CLOB = 5;
        public static final int TYPE_SEQUENCE = 6;
        public static final int TYPE_CHAR = 7;
        public static final int TYPE_LONG = 8;
        public static final int TYPE_TIMESTAMP = 9;
        public static final int TYPE_PASSWORD = 10;
        public static final int TYPE_DECIMAL = 11;
        public static final int TYPE_REAL = 12;
        public static final int TYPE_BINARY = 13;
        public static final int TYPE_UNKNOWN = 14;
        public static final int TYPE_NSTRING = 15;
        public static final int TYPE_NCLOB = 16;
        public static final int TYPE_FLOAT_754 = 17;
        public static final int TYPE_DOUBLE_754 = 18;
        public static final int ONDELETE_UNKNOWN = -1;
        public static final int ONDELETE_CASCADE = 1;
        public static final int ONDELETE_SETNULL = 2;
        public static final int WHEN_AFTER = 1;
        public static final int WHEN_BEFORE = 2;

        public Field() {
        }

        public Field(String name, int type, String strType) {
            this.name = name;
            this.type = type;
            this.strType = strType;
        }

        public boolean isSequence() {
            return this.type == 6;
        }

        public Field clone() {
            try {
                return (Field)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    public static class Argument
    extends Field {
        public int argType;
        public static final int ARGTYPE_IN = 0;
        public static final int ARGTYPE_OUT = 1;
        public static final int ARGTYPE_INOUT = 2;

        public Argument(String name, int type, String strType, int argType) {
            super(name, type, strType);
            this.argType = argType;
        }
    }
}

