/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.sql;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpm.lang.Kind;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.sql.ParsedQuery;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.util.CantLoadBinaryException;
import oracle.bpm.util.Conversion;

public abstract class SQLUtils {
    private static Map<Integer, String> sqltypeToString_d;
    private static final int UNKNOWN = -1234567890;
    private static final int NVARCHAR = -9;
    private static Map<String, Integer> stringToSQLType_d;

    public static String getDelete(String from, List<String> eqFields) {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ").append(from);
        sql.append(SQLUtils.getWhere(eqFields));
        return sql.toString();
    }

    public static String getDeleteCurrent(String from, String cursor) {
        return "DELETE FROM " + from + " WHERE CURRENT OF " + cursor;
    }

    public static boolean isExternal(int sqltype) {
        switch (sqltype) {
            case 91: 
            case 93: 
            case 2005: {
                return true;
            }
            case 2004: {
                return true;
            }
            case -9: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 92: {
                return false;
            }
            case 0: 
            case 1111: {
                return false;
            }
        }
        return true;
    }

    public static String getInsert(String into, List<String> fields) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(into).append(" (");
        Iterator<String> iterator = fields.iterator();
        while (iterator.hasNext()) {
            sql.append(iterator.next());
            if (!iterator.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(") VALUES (?");
        for (int i = 1; i < fields.size(); ++i) {
            sql.append(", ?");
        }
        sql.append(")");
        return sql.toString();
    }

    public static Object getJavaObject(ResultSet resultSet, String fieldName) {
        try {
            ObjectInputStream byteArrayInputStream = new ObjectInputStream(resultSet.getBinaryStream(fieldName));
            return byteArrayInputStream.readObject();
        }
        catch (IOException e) {
            throw new CantLoadBinaryException(LibMsg.FE_0006(fieldName), (Throwable)e);
        }
        catch (SQLException e) {
            throw new CantLoadBinaryException(LibMsg.FE_0006(fieldName), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new CantLoadBinaryException(LibMsg.FE_0006(fieldName), (Throwable)e);
        }
    }

    public static String getJavaType(int sqltype) {
        switch (sqltype) {
            case 93: {
                return "java.sql.Timestamp";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 2005: {
                return "java.sql.Clob";
            }
            case 2004: {
                return "java.sql.Blob";
            }
            case 0: 
            case 1111: {
                return "java.lang.Object";
            }
        }
        return null;
    }

    public static TypeDescription getTypeDescription(int sqltype) throws SQLException {
        switch (sqltype) {
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return TypeFactory.getString();
            }
            case 91: 
            case 92: 
            case 93: {
                return TypeFactory.getTime();
            }
            case -7: {
                return TypeFactory.getBool();
            }
            case -5: {
                return TypeFactory.getInt(64);
            }
            case 4: {
                return TypeFactory.getInt(32);
            }
            case 5: {
                return TypeFactory.getInt(16);
            }
            case -6: {
                return TypeFactory.getInt(8);
            }
            case 2: 
            case 3: {
                return TypeFactory.getDecimal();
            }
            case 7: 
            case 8: {
                return TypeFactory.getReal();
            }
            case 6: {
                return TypeFactory.getReal(32);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return TypeFactory.getBinary();
            }
            case 1111: {
                return TypeFactory.getRootObject();
            }
        }
        throw new SQLException("Unssuported Type: " + sqltype);
    }

    public static int getKind(int sqltype) {
        switch (sqltype) {
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return 5;
            }
            case 91: 
            case 92: 
            case 93: {
                return 6;
            }
            case -7: {
                return 1;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return 2;
            }
            case 2: 
            case 3: {
                return 3;
            }
            case 6: 
            case 7: 
            case 8: {
                return 4;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return 8;
            }
            case 0: {
                return -1;
            }
            case 1111: {
                return 11;
            }
        }
        return -1;
    }

    public static Object getObject(ResultSet rs, String colName, int kind) throws SQLException {
        try {
            switch (kind) {
                case 5: {
                    return rs.getString(colName);
                }
                case 1: {
                    return rs.getBoolean(colName);
                }
                case 2: {
                    return rs.getLong(colName);
                }
                case 3: {
                    return rs.getBigDecimal(colName);
                }
                case 4: {
                    return rs.getDouble(colName);
                }
                case 6: {
                    return rs.getTime(colName) != null ? Time.valueOf(rs.getTimestamp(colName)) : null;
                }
                case 9: {
                    return null;
                }
                case 8: {
                    byte[] bytes = rs.getBytes(colName);
                    ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                    try {
                        ObjectInputStream is = new ObjectInputStream(stream);
                        return is.readObject();
                    }
                    catch (StreamCorruptedException e) {
                        if (Log.isDebugging()) {
                            Log.logDebug(e);
                        }
                        return bytes;
                    }
                    catch (IOException e) {
                        if (Log.isDebugging()) {
                            Log.logDebug(e);
                        }
                        throw new SQLException(e.getMessage());
                    }
                    catch (ClassNotFoundException e) {
                        if (Log.isDebugging()) {
                            Log.logDebug(e);
                        }
                        throw new SQLException(e.getMessage());
                    }
                }
            }
            return rs.getObject(colName);
        }
        catch (AbstractMethodError e) {
            if (Log.isDebugging()) {
                Log.logDebug(e);
            }
            return rs.getObject(colName);
        }
    }

    public static void setParameter(PreparedStatement statement, int position, Object value) throws SQLException {
        SQLUtils.setParameter(statement, position, value, -1234567890);
    }

    public static void setParameter(PreparedStatement statement, int position, Object value, int sqltype) throws SQLException {
        if (value instanceof Time) {
            value = Conversion.tojava_sql_Timestamp((Time)value);
        }
        if (value == null && sqltype != -1234567890 && sqltype != 1111) {
            statement.setNull(position, sqltype);
            return;
        }
        switch (sqltype) {
            case -1234567890: 
            case 1111: {
                if (value == null) {
                    value = "";
                }
                statement.setObject(position, value);
                break;
            }
            case -7: {
                assert (value instanceof Boolean) : "The SQL type is BIT and the value is not a Boolean";
                statement.setBoolean(position, (Boolean)value);
                break;
            }
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -1: 
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                statement.setObject(position, value);
                break;
            }
            case -9: 
            case 1: 
            case 12: 
            case 2005: {
                if (value instanceof Clob) {
                    Clob clob = (Clob)value;
                    statement.setCharacterStream(position, clob.getCharacterStream(), (int)clob.length());
                    break;
                }
                if (value instanceof String) {
                    statement.setString(position, (String)value);
                    break;
                }
                statement.setObject(position, value);
                break;
            }
            case -2: 
            case 2004: {
                if (value instanceof Blob) {
                    statement.setBlob(position, (Blob)value);
                    break;
                }
                if (value instanceof byte[]) {
                    statement.setBytes(position, (byte[])value);
                    break;
                }
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(value);
                    byte[] data = baos.toByteArray();
                    statement.setBytes(position, data);
                }
                catch (IOException e) {
                    Log.logSevere(e);
                }
                break;
            }
            default: {
                assert (false) : "invalid sql type : " + sqltype;
                break;
            }
        }
    }

    public static int getSQLType(int kind) {
        switch (kind) {
            case 5: {
                return 1;
            }
            case 1: {
                return -7;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 7;
            }
            case 6: {
                return 93;
            }
            case 8: {
                return -2;
            }
            case 9: {
                return 1;
            }
        }
        return 12;
    }

    public static String getSelect(String from, List<String> fields, List<String> eqFields) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        if (fields == null || fields.size() == 0) {
            sql.append("*");
        } else {
            for (int i = 0; i < fields.size(); ++i) {
                sql.append(fields.get(i));
                if (i + 1 >= fields.size()) continue;
                sql.append(", ");
            }
        }
        sql.append(" FROM ").append(from);
        sql.append(SQLUtils.getWhere(eqFields));
        return sql.toString();
    }

    public static String getUpdate(String from, List<String> fields, List<String> eqFields) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(from);
        sql.append(" SET ");
        sql.append(fields.get(0)).append(" = ? ");
        for (int i = 1; i < fields.size(); ++i) {
            sql.append(", ").append(fields.get(i)).append(" = ? ");
        }
        sql.append(SQLUtils.getWhere(eqFields));
        return sql.toString();
    }

    public static String getUpdateCurrent(String from, List<String> fields, String cursor) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(from);
        sql.append(" SET ");
        sql.append(fields.get(0)).append(" = ? ");
        for (int i = 1; i < fields.size(); ++i) {
            sql.append(", ").append(fields.get(i)).append(" = ? ");
        }
        sql.append(" WHERE CURRENT OF ").append(cursor);
        return sql.toString();
    }

    public static void main(String[] args) {
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<String> eqfields = new ArrayList<String>();
        fields.add("field1");
        fields.add("field2");
        fields.add("field3");
        System.out.println(SQLUtils.getSelect("table", fields, eqfields));
        System.out.println(SQLUtils.getInsert("table", fields));
        System.out.println(SQLUtils.getDelete("table", eqfields));
        System.out.println(SQLUtils.getUpdate("table", fields, eqfields));
        System.out.println(SQLUtils.getDeleteCurrent("table", "cursorName"));
        System.out.println(SQLUtils.getUpdateCurrent("table", fields, "cursorName"));
    }

    public static PreparedStatement prepareDelete(Connection conn, String from, List<String> eqFields) throws SQLException {
        return conn.prepareStatement(SQLUtils.getDelete(from, eqFields));
    }

    public static PreparedStatement prepareDeleteCurrent(Connection conn, String from, String cursor) throws SQLException {
        return conn.prepareStatement(SQLUtils.getDeleteCurrent(from, cursor));
    }

    public static PreparedStatement prepareInsert(Connection conn, String into, List<String> fields) throws SQLException {
        return conn.prepareStatement(SQLUtils.getInsert(into, fields));
    }

    public static PreparedStatement prepareSelect(Connection conn, String from, List<String> fields, List<String> eqFields) throws SQLException {
        return conn.prepareStatement(SQLUtils.getSelect(from, fields, eqFields));
    }

    public static PreparedStatement prepareUpdate(Connection conn, String from, List<String> fields, List<String> eqFields) throws SQLException {
        return conn.prepareStatement(SQLUtils.getUpdate(from, fields, eqFields));
    }

    public static PreparedStatement prepareUpdateCurrent(Connection conn, String from, List<String> flds, String cursor) throws SQLException {
        return conn.prepareStatement(SQLUtils.getUpdateCurrent(from, flds, cursor));
    }

    public static String schemaQualification(String query) {
        ParsedQuery parsed = ParsedQuery.parse(query);
        Iterator<String> tablesIt = parsed.getTables();
        while (tablesIt.hasNext()) {
            String table = tablesIt.next().toString();
            if (table.indexOf(".") == -1) continue;
            String schema = table.substring(0, table.indexOf("."));
            table = table.substring(table.indexOf(".") + 1, table.length());
            query = Str.replaceString(query, " " + table + ".", " " + schema + "." + table + ".");
            query = Str.replaceString(query, "(" + table + ".", "(" + schema + "." + table + ".");
            query = Str.replaceString(query, "," + table + ".", "," + schema + "." + table + ".");
        }
        return query;
    }

    public static String sqlTypeToString(int type) {
        String val;
        if (sqltypeToString_d == null) {
            sqltypeToString_d = new HashMap<Integer, String>();
            sqltypeToString_d.put(2003, "ARRAY");
            sqltypeToString_d.put(-5, "BIGINT");
            sqltypeToString_d.put(-2, "BINARY");
            sqltypeToString_d.put(-7, "BIT");
            sqltypeToString_d.put(2004, "BLOB");
            sqltypeToString_d.put(1, "CHAR");
            sqltypeToString_d.put(2005, "CLOB");
            sqltypeToString_d.put(91, "DATE");
            sqltypeToString_d.put(3, "DECIMAL");
            sqltypeToString_d.put(2001, "DISTINCT");
            sqltypeToString_d.put(8, "DOUBLE");
            sqltypeToString_d.put(6, "FLOAT");
            sqltypeToString_d.put(4, "INTEGER");
            sqltypeToString_d.put(2000, "JAVA_OBJECT");
            sqltypeToString_d.put(-4, "LONGVARBINARY");
            sqltypeToString_d.put(-1, "LONGVARCHAR");
            sqltypeToString_d.put(0, "NULL");
            sqltypeToString_d.put(2, "NUMERIC");
            sqltypeToString_d.put(1111, "OTHER");
            sqltypeToString_d.put(7, "REAL");
            sqltypeToString_d.put(2006, "REF");
            sqltypeToString_d.put(5, "SMALLINT");
            sqltypeToString_d.put(2002, "STRUCT");
            sqltypeToString_d.put(92, "TIME");
            sqltypeToString_d.put(93, "TIMESTAMP");
            sqltypeToString_d.put(-6, "TINYINT");
            sqltypeToString_d.put(-3, "VARBINARY");
            sqltypeToString_d.put(12, "VARCHAR");
            sqltypeToString_d.put(-9, "NVARCHAR");
        }
        return (val = sqltypeToString_d.get(type)) != null ? val : "OTHER";
    }

    public static int stringToSQLType(String type) {
        Integer val;
        if (stringToSQLType_d == null) {
            stringToSQLType_d = new HashMap<String, Integer>();
            stringToSQLType_d.put("ARRAY", 2003);
            stringToSQLType_d.put("BIGINT", -5);
            stringToSQLType_d.put("BINARY", -2);
            stringToSQLType_d.put("BIT", -7);
            stringToSQLType_d.put("BLOB", 2004);
            stringToSQLType_d.put("CHAR", 1);
            stringToSQLType_d.put("CLOB", 2005);
            stringToSQLType_d.put("DATE", 91);
            stringToSQLType_d.put("DECIMAL", 3);
            stringToSQLType_d.put("DISTINCT", 2001);
            stringToSQLType_d.put("DOUBLE", 8);
            stringToSQLType_d.put("FLOAT", 6);
            stringToSQLType_d.put("INTEGER", 4);
            stringToSQLType_d.put("JAVA_OBJECT", 2000);
            stringToSQLType_d.put("LONGVARBINARY", -4);
            stringToSQLType_d.put("LONGVARCHAR", -1);
            stringToSQLType_d.put("NULL", 0);
            stringToSQLType_d.put("NUMERIC", 2);
            stringToSQLType_d.put("OTHER", 1111);
            stringToSQLType_d.put("REAL", 7);
            stringToSQLType_d.put("REF", 2006);
            stringToSQLType_d.put("SMALLINT", 5);
            stringToSQLType_d.put("STRUCT", 2002);
            stringToSQLType_d.put("TIME", 92);
            stringToSQLType_d.put("TIMESTAMP", 93);
            stringToSQLType_d.put("TINYINT", -6);
            stringToSQLType_d.put("VARBINARY", -3);
            stringToSQLType_d.put("VARCHAR", 12);
            stringToSQLType_d.put("NVARCHAR", -9);
            stringToSQLType_d.put("OTHER", 1111);
        }
        return (val = stringToSQLType_d.get(type)) != null ? val : 0;
    }

    public static Object valueOf(int kind, String value) {
        switch (kind) {
            case 5: {
                return value;
            }
            case 1: {
                return Integer.valueOf(value) == 1;
            }
            case 2: {
                return Long.valueOf(value);
            }
            case 3: {
                return new BigDecimal(value);
            }
            case 4: {
                return Float.valueOf(value);
            }
            case 6: {
                return Timestamp.valueOf(value);
            }
        }
        assert (false) : "SQLUtils.valueOf() - Invalid Kind '" + Kind.getName(kind) + "' value'" + value + "'";
        return null;
    }

    public static Object valueOfNull(int kind) {
        switch (kind) {
            case 5: {
                return "";
            }
            case 1: {
                return Boolean.FALSE;
            }
            case 2: {
                return 0L;
            }
            case 3: {
                return new BigDecimal(0);
            }
            case 4: {
                return Float.valueOf(0.0f);
            }
            case 6: {
                return null;
            }
        }
        assert (false) : "SQLUtils.valueOfNull() - Invalid Kind '" + Kind.getName(kind) + "'";
        return null;
    }

    public static boolean isString(int sqltype) {
        switch (sqltype) {
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private static String getWhere(List<String> eqFields) {
        StringBuffer sql = new StringBuffer();
        if (eqFields != null && eqFields.size() != 0) {
            sql.append(" WHERE ").append(eqFields.get(0)).append(" = ? ");
            for (int i = 1; i < eqFields.size(); ++i) {
                sql.append("AND ").append(eqFields.get(i)).append(" = ? ");
            }
        }
        return sql.toString();
    }
}

