/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import oracle.bpm.components.SQLException;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.JDBCHelper;
import oracle.bpm.jdbc.DatabaseManager;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.sql.SQLObject;
import oracle.bpm.sql.SQLUtils;
import oracle.bpm.sql.StatementException;

public class QueryObject
extends SQLObject {
    protected Object[] arguments_d;
    protected transient boolean fetched_d = false;
    protected transient boolean hasNext_d = false;
    protected transient boolean prepared_d;
    protected transient PreparedStatement queryStatement_d;
    protected transient ResultSet result_d;
    protected int[] types_d;
    static final long serialVersionUID = -916905917474994588L;
    static final long serialCheck = 1083458154769852873L;

    public QueryObject(String moduleName, String signature) {
        super(moduleName, signature);
    }

    public void setArguments(Object[] args, int[] types) {
        this.arguments_d = args;
        this.types_d = types;
    }

    @Override
    public Object setAttributeValue(String signature, Object value) {
        try {
            this.result_d.updateObject(signature, value);
            super.setAttributeValue(signature, value);
        }
        catch (java.sql.SQLException exc) {
            throw new RuntimeExceptionShell(exc);
        }
        return value;
    }

    @Override
    public String getName() {
        return this.getObjectName();
    }

    @Override
    public synchronized void close() throws SQLException {
        try {
            if (this.result_d != null) {
                this.result_d.close();
            }
            if (this.queryStatement_d != null) {
                this.queryStatement_d.close();
            }
            this.result_d = null;
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    public boolean hasNext() throws SQLException {
        try {
            return this.fetched_d ? this.hasNext_d : this.fetchNext();
        }
        catch (java.sql.SQLException e) {
            e.printStackTrace();
            throw new SQLException(e);
        }
    }

    public Object next() throws SQLException {
        if (!this.fetched_d) {
            try {
                this.fetched_d = this.fetchNext();
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }
        this.fetched_d = false;
        return this;
    }

    @Override
    public void remove() throws SQLException {
        try {
            this.result_d.deleteRow();
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void store() throws SQLException {
        try {
            this.result_d.updateRow();
        }
        catch (java.sql.SQLException e) {
            throw new SQLException(e);
        }
    }

    protected void cancelChanges() throws java.sql.SQLException {
        if (this.result_d.rowUpdated()) {
            this.result_d.cancelRowUpdates();
        }
    }

    protected boolean fetchNext() throws java.sql.SQLException {
        if (!this.prepared_d) {
            this.init();
        }
        if (this.fetched_d) {
            this.cancelChanges();
        }
        this.hasNext_d = this.result_d.next();
        if (this.hasNext_d) {
            this.loadValuesFrom(this.result_d);
        }
        return this.hasNext_d;
    }

    protected void init() throws java.sql.SQLException {
        try {
            Connection conn = JDBCHelper.getConnection(this.getModuleName());
            DatabaseManager mgr = JDBCHelper.getDatabaseManager(this.getModuleName());
            String sqlText = this.getSQLText(conn.getMetaData().getIdentifierQuoteString());
            this.queryStatement_d = mgr.prepareQueryObjectStatement(conn, sqlText);
        }
        catch (StatementException e) {
            throw (java.sql.SQLException)e.getCause();
        }
        catch (ConnectorException e) {
            if (e.getCause() instanceof java.sql.SQLException) {
                throw (java.sql.SQLException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        if (this.arguments_d != null) {
            for (int i = 0; i < this.arguments_d.length; ++i) {
                SQLUtils.setParameter(this.queryStatement_d, i + 1, this.arguments_d[i], this.types_d[i]);
            }
        }
        this.initCursor();
        this.result_d = this.queryStatement_d.executeQuery();
        this.prepared_d = true;
    }

    protected void initCursor() {
    }

    @Override
    protected void parseSignature(String signature) {
        this.setSQLText(signature);
    }
}

