/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.bpm.jdbc.DatabaseManager;
import oracle.bpm.jdbc.TableInitializer;
import oracle.bpm.lang.Time;
import oracle.bpm.sql.struct.Schema;

public abstract class AbstractMigrationTableInitializer
implements TableInitializer {
    @Override
    public String getSql(Schema.Table table, DatabaseManager dbMgr) {
        assert (table.name.equalsIgnoreCase("migration")) : "Unexpected table";
        return "INSERT INTO " + dbMgr.getFullTableName(dbMgr.getSchemaName(), dbMgr.upperCase(table.name)) + " (BUILD,DESCRIPTION) VALUES(" + this.getSchemaVersion() + ", 'Created on " + Time.now() + "')";
    }

    @Override
    public String getSql(String tableName) {
        return "INSERT INTO " + tableName + " (BUILD,DESCRIPTION) VALUES(" + this.getSchemaVersion() + ", 'Created on " + Time.now() + "')";
    }

    @Override
    public void initialize(Connection connection, Schema.Table table, DatabaseManager dbMgr) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute(this.getSql(table, dbMgr));
    }

    protected abstract int getSchemaVersion();
}

