/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.servlet.multipart;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import oracle.bpm.servlet.multipart.CharCursor;
import oracle.bpm.servlet.multipart.StringCharCursor;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;

public class MultipartRequest
implements HttpServletRequest {
    private boolean deleteOnExit = false;
    private File dir;
    private Map<String, UploadedFile> files = new HashMap<String, UploadedFile>();
    private int maxSize;
    private Map<String, String[]> parameters = new HashMap<String, String[]>();
    private HttpServletRequest req;
    private String suffixFileString;
    private static final int DEFAULT_MAX_POST_SIZE = 0x100000;

    public MultipartRequest(HttpServletRequest request, String saveDirectory) throws IOException {
        this(request, saveDirectory, 0x100000);
    }

    public MultipartRequest(HttpServletRequest request, String saveDirectory, int maxPostSize) throws IOException {
        this(request, saveDirectory, "", maxPostSize);
    }

    public MultipartRequest(HttpServletRequest request, String _prefixFileString, String saveDirectory) throws IOException {
        this(request, saveDirectory, _prefixFileString, 0x100000);
    }

    public MultipartRequest(HttpServletRequest request, String saveDirectory, String suffixFileString, int maxPostSize) throws IOException {
        this(request, saveDirectory, suffixFileString, maxPostSize, false);
    }

    public MultipartRequest(HttpServletRequest request, String saveDirectory, String suffixFileString, int maxPostSize, boolean deleteOnExit) throws IOException {
        this.suffixFileString = suffixFileString;
        this.deleteOnExit = deleteOnExit;
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (saveDirectory == null) {
            throw new IllegalArgumentException("saveDirectory cannot be null");
        }
        if (maxPostSize <= 0) {
            throw new IllegalArgumentException("maxPostSize must be positive");
        }
        this.req = request;
        this.dir = new File(saveDirectory);
        this.maxSize = maxPostSize;
        if (!this.dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + saveDirectory);
        }
        if (!this.dir.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + saveDirectory);
        }
        String qs = this.req.getQueryString();
        if (qs != null && !"".equals(qs)) {
            MultipartRequest.parseQueryString(this.parameters, qs);
        }
        this.readRequest();
    }

    public static void parseQueryString(Map<String, String[]> table, String query) {
        StringCharCursor is = new StringCharCursor(query);
        char ch = ((CharCursor)is).current();
        while (ch != '\uffff') {
            while (Character.isWhitespace(ch) || ch == '&') {
                ch = ((CharCursor)is).next();
            }
            StringBuffer bb = new StringBuffer();
            while (ch != '\uffff' && ch != '=') {
                if (ch == '+') {
                    bb.append(' ');
                } else if (ch == '%') {
                    char ch1 = ((CharCursor)is).next();
                    char ch2 = ((CharCursor)is).next();
                    bb.append((char)((MultipartRequest.toHex(ch1) << 4) + MultipartRequest.toHex(ch2)));
                } else {
                    bb.append(ch);
                }
                ch = ((CharCursor)is).next();
            }
            if (bb.length() == 0) break;
            String key = bb.toString();
            bb = new StringBuffer();
            ch = ((CharCursor)is).next();
            while (ch != '\uffff' && ch != '&') {
                if (ch == '+') {
                    bb.append(' ');
                } else if (ch != ' ') {
                    if (ch == '%') {
                        char ch1 = ((CharCursor)is).next();
                        char ch2 = ((CharCursor)is).next();
                        bb.append((char)((MultipartRequest.toHex(ch1) << 4) + MultipartRequest.toHex(ch2)));
                    } else {
                        bb.append(ch);
                    }
                }
                ch = ((CharCursor)is).next();
            }
            String value = bb.toString();
            if (value == null) continue;
            MultipartRequest.addParameter(table, key, value);
        }
    }

    public void setAttribute(String _string, Object _object) {
        this.req.setAttribute(_string, _object);
    }

    public Object getAttribute(String _string) {
        return this.req.getAttribute(_string);
    }

    public Enumeration getAttributeNames() {
        return this.req.getAttributeNames();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.req.setCharacterEncoding(env);
    }

    public String getCharacterEncoding() {
        return this.req.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.req.getContentLength();
    }

    public String getContentType(String name) {
        try {
            return this.files.get(name).getContentType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getContentType() {
        return this.req.getContentType();
    }

    public File getFile(String name) {
        File result = null;
        try {
            result = this.files.get(name).getFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public Iterable<String> getFileNames() {
        return this.files.keySet();
    }

    public String getFilesystemName(String name) {
        String result = null;
        try {
            result = this.files.get(name).getClientFilePath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.req;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.req.getInputStream();
    }

    public Locale getLocale() {
        return this.req.getLocale();
    }

    public Enumeration getLocales() {
        return this.req.getLocales();
    }

    public String getParameter(String name) {
        try {
            String[] param = this.parameters.get(name);
            if (param == null || param.length == 0) {
                return null;
            }
            return param[param.length - 1];
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map getParameterMap() {
        return this.req.getParameterMap();
    }

    public Enumeration getParameterNames() {
        final Iterator<String> it = this.parameters.keySet().iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)it.next();
            }
        };
    }

    public String[] getParameterValues(String str) {
        return this.parameters.get(str);
    }

    public String getProtocol() {
        return this.req.getProtocol();
    }

    public BufferedReader getReader() throws IOException {
        return this.req.getReader();
    }

    public String getRealPath(String _string) {
        return this.req.getSession().getServletContext().getRealPath(_string);
    }

    public int getRemotePort() {
        return 0;
    }

    public String getLocalName() {
        return null;
    }

    public String getLocalAddr() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public String getRemoteAddr() {
        return this.req.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.req.getRemoteHost();
    }

    public String getRemoteUser() {
        return this.req.getRemoteUser();
    }

    public RequestDispatcher getRequestDispatcher(String _string) {
        return this.req.getRequestDispatcher(_string);
    }

    public String getRequestURI() {
        return this.req.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.req.getRequestURL();
    }

    public String getAuthType() {
        return this.req.getAuthType();
    }

    public String getContextPath() {
        return this.req.getContextPath();
    }

    public Cookie[] getCookies() {
        return this.req.getCookies();
    }

    public long getDateHeader(String _string) {
        return this.req.getDateHeader(_string);
    }

    public String getHeader(String _string) {
        return this.req.getHeader(_string);
    }

    public Enumeration getHeaderNames() {
        return this.req.getHeaderNames();
    }

    public Enumeration getHeaders(String _string) {
        return this.req.getHeaders(_string);
    }

    public int getIntHeader(String _string) {
        return this.req.getIntHeader(_string);
    }

    public String getMethod() {
        return this.req.getMethod();
    }

    public String getPathInfo() {
        return this.req.getPathInfo();
    }

    public String getPathTranslated() {
        return this.req.getPathTranslated();
    }

    public String getQueryString() {
        return this.req.getQueryString();
    }

    public String getRequestedSessionId() {
        return this.req.getRequestedSessionId();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.req.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.req.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.req.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this.req.isRequestedSessionIdValid();
    }

    public String getScheme() {
        return this.req.getScheme();
    }

    public boolean isSecure() {
        return this.req.isSecure();
    }

    public String getServerName() {
        return this.req.getServerName();
    }

    public int getServerPort() {
        return this.req.getServerPort();
    }

    public String getServletPath() {
        return this.req.getServletPath();
    }

    public HttpSession getSession(boolean _string) {
        return this.req.getSession(_string);
    }

    public HttpSession getSession() {
        return this.req.getSession();
    }

    public boolean isUserInRole(String _string) {
        return this.req.isUserInRole(_string);
    }

    public Principal getUserPrincipal() {
        return this.req.getUserPrincipal();
    }

    public void removeAttribute(String _string) {
        this.req.removeAttribute(_string);
    }

    public String getFileName(String name) {
        UploadedFile uploadedFile = this.files.get(name);
        return uploadedFile != null ? uploadedFile.getFileName() : null;
    }

    protected void readRequest() throws IOException {
        ServletRequestContext requestContext = new ServletRequestContext(this.req);
        DiskFileItemFactory factory = new DiskFileItemFactory(){

            public FileItem createItem(String fieldName, String contentType, boolean isFormField, String fileName) {
                return super.createItem(fieldName, isFormField ? "text/plain; charset=UTF-8" : contentType, isFormField, fileName);
            }
        };
        factory.setRepository(this.dir);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setSizeMax((long)this.maxSize);
        upload.setHeaderEncoding("UTF-8");
        try {
            List fileItems = upload.parseRequest((RequestContext)requestContext);
            for (FileItem fileItem : fileItems) {
                if (fileItem.isFormField()) {
                    this.processFormField(fileItem);
                    continue;
                }
                this.processUploadedFile(fileItem);
            }
        }
        catch (FileUploadException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static void addParameter(Map<String, String[]> table, String key, String value) {
        if (table.get(key) != null) {
            String[] params = table.get(key);
            String[] paramNew = new String[params.length + 1];
            System.arraycopy(params, 0, paramNew, 0, params.length);
            paramNew[params.length] = value;
            table.put(key, paramNew);
        } else {
            String[] params = new String[]{value};
            table.put(key, params);
        }
    }

    private static int toHex(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 97 && ch <= 102) {
            return ch - 97 + 10;
        }
        if (ch >= 65 && ch <= 70) {
            return ch - 65 + 10;
        }
        return -1;
    }

    private void processFormField(FileItem item) {
        MultipartRequest.addParameter(this.parameters, item.getFieldName(), item.getString());
    }

    private void processUploadedFile(FileItem fileItem) throws IOException {
        try {
            String clientFilePath = fileItem.getName();
            String contentType = "unknown".equals(clientFilePath) ? null : fileItem.getContentType();
            UploadedFile upload = new UploadedFile(this.dir, clientFilePath, contentType);
            File uploadedFile = upload.getFile();
            if (this.deleteOnExit) {
                uploadedFile.deleteOnExit();
            }
            if (!uploadedFile.exists() || uploadedFile.isFile()) {
                fileItem.write(uploadedFile);
                String inputFieldName = fileItem.getFieldName();
                this.files.put(inputFieldName, upload);
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    class UploadedFile {
        private String clientFilePath;
        private String contentType;
        private String fileName;
        private File localFileDir;
        private static final String UNKNOWN_FILE_NAME = "unknown";

        UploadedFile(File localFileDir, String clientFilePath, String contentType) {
            this.localFileDir = localFileDir;
            this.clientFilePath = clientFilePath;
            this.contentType = contentType;
            this.fileName = this.generateFileName(clientFilePath);
        }

        public String getContentType() {
            return this.contentType;
        }

        public File getFile() {
            String localFileName = !"".equals(MultipartRequest.this.suffixFileString) ? this.fileName + "_" + MultipartRequest.this.suffixFileString : this.fileName;
            return new File(this.localFileDir, localFileName);
        }

        public String getClientFilePath() {
            return this.clientFilePath;
        }

        public String getFileName() {
            return this.fileName;
        }

        private String generateFileName(String clientFilePath) {
            String ret;
            if (clientFilePath == null) {
                ret = UNKNOWN_FILE_NAME;
            } else {
                int fslash = clientFilePath.lastIndexOf("/");
                int bslash = clientFilePath.lastIndexOf("\\");
                int cutoff = Math.max(Math.max(fslash, bslash) + 1, 0);
                ret = clientFilePath.substring(cutoff);
            }
            return ret;
        }
    }
}

