/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import oracle.bpm.collections.sets.StringSet;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.EnumType;
import oracle.bpm.lang.IllegalTypeException;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.JavaEnumTypeDescription;
import oracle.bpm.lang.JavaIntrospector;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.ObjectTypeDescriptionException;
import oracle.bpm.lang.RealClassNotFoundException;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.log.Log;

public class JavaObjectTypeDescription
extends ObjectTypeDescription {
    protected boolean connectToRealClass = false;
    protected boolean loaded = false;
    private StringSet implementedInterfaces = StringSet.create();
    private transient JavaClass<?> javaclass;
    protected static Map<String, ObjectTypeDescription> typescache;
    protected static final Object classLock;

    protected JavaObjectTypeDescription(String pkg, String classname) {
        this(pkg, classname, false);
    }

    protected JavaObjectTypeDescription(String pkg, String classname, boolean connectToRealClasses) {
        this();
        if (classname == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.setName(classname);
        if (classname.indexOf(".") != -1) {
            throw new IllegalTypeException("Invalid classname '" + classname + "'");
        }
        if (Str.isEmpty(pkg) && Log.isDebugging()) {
            Log.logDebug("class without package: " + classname);
        }
        this.name = classname;
        this.setSignature(classname);
        this.setProperty("package", pkg);
        Class cl = this.getJavaClass();
        this.setConnectToRealClass(connectToRealClasses);
        if (cl != null) {
            this.setModifiers(this.getModifiers() | JavaIntrospector.getModifiers(cl));
            JavaIntrospector.setRunningSide(this, cl);
        }
    }

    private JavaObjectTypeDescription() {
        super("");
        this.setComponentType(ComponentType.JAVA.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectTypeDescription forName(String fullclassname) {
        Object object = classLock;
        synchronized (object) {
            ObjectTypeDescription resultType;
            if (typescache == null) {
                typescache = new HashMap<String, ObjectTypeDescription>();
            }
            if ((resultType = typescache.get(fullclassname)) == null) {
                int index = fullclassname.lastIndexOf(".");
                String pkg = null;
                String name = fullclassname;
                if (index != -1) {
                    pkg = fullclassname.substring(0, index);
                    name = fullclassname.substring(index + 1);
                }
                if (pkg == null && name == null) {
                    throw new IllegalTypeException("Invalid classname '" + fullclassname + "'");
                }
                Class cl = JavaObjectTypeDescription.loadClass(pkg, name);
                if (cl == null) {
                    return null;
                }
                if (cl.isEnum()) {
                    resultType = JavaEnumTypeDescription.create(name, cl);
                } else if (EnumType.class.isAssignableFrom(cl)) {
                    resultType = JavaEnumTypeDescription.createDeprecated(name, cl);
                } else {
                    JavaObjectTypeDescription otd = new JavaObjectTypeDescription(pkg, name, true);
                    if (((ObjectTypeDescription)otd).getJavaClass() != null) {
                        resultType = otd;
                    }
                }
                if (resultType != null) {
                    typescache.put(fullclassname, resultType);
                }
            }
            return resultType;
        }
    }

    public static ObjectTypeDescription forNameInternal(String fullclassname) {
        int index = fullclassname.lastIndexOf(".");
        String pkg = null;
        String name = fullclassname;
        if (index != -1) {
            pkg = fullclassname.substring(0, index);
            name = fullclassname.substring(index + 1);
        }
        return new JavaObjectTypeDescription(pkg, name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeCache() {
        Object object = classLock;
        synchronized (object) {
            typescache = new HashMap<String, ObjectTypeDescription>();
        }
    }

    @Override
    public void setAttributeValue(String signature, Object value, Object target) throws ComponentExecutionException {
        if (target instanceof Invokeable) {
            Invokeable object = (Invokeable)target;
            object.setAttributeValue(signature, value);
            return;
        }
        if (this.javaclass == null) {
            try {
                this.javaclass = JavaClass.forName(this.getJavaType());
            }
            catch (ClassNotFoundException e) {
                throw new ComponentExecutionException(e);
            }
        }
        this.javaclass.setAttributeValue(signature, value, target);
    }

    @Override
    public Object getAttributeValue(String signature, Object target) throws ComponentExecutionException {
        if (target instanceof Invokeable) {
            Invokeable object = (Invokeable)target;
            return object.getAttributeValue(signature);
        }
        if (this.javaclass == null) {
            try {
                this.javaclass = JavaClass.forName(this.getJavaType());
            }
            catch (ClassNotFoundException e) {
                throw new ComponentExecutionException(e);
            }
        }
        return this.javaclass.getAttributeValue(signature, target);
    }

    public void setConnectToRealClass(boolean connect) {
        this.connectToRealClass = connect;
        if (connect) {
            this.loadMembers();
        }
    }

    public void setDynamic(boolean dynamic) {
        this.setModifiers(Modifier.setDynamic(this.getModifiers(), dynamic));
    }

    @Override
    public Class getJavaClass() {
        if (this.javaclass == null) {
            boolean isPackage = "true".equals(this.getProperty("isPackage"));
            Class cl = isPackage ? Void.TYPE : JavaObjectTypeDescription.loadClass(this.getProperty("package"), this.getName());
            this.javaclass = cl != null ? JavaClass.fromClass(cl) : null;
        }
        return this.javaclass != null ? this.javaclass.getOriginalClass() : null;
    }

    @Override
    public String getJavaSignature() {
        return 'L' + this.getJavaType() + ';';
    }

    @Override
    public String getJavaType() {
        return this.getJavaPackage() + "." + this.getName();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setProperties(SortedMap<String, String> map) {
        String ifaces;
        super.setProperties(map);
        if (map != null && (ifaces = (String)map.get("implementedInterfaces")) != null) {
            StringTokenizer st = new StringTokenizer(ifaces, ";");
            while (st.hasMoreTokens()) {
                this.implementedInterfaces.add(st.nextToken());
            }
        }
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> hm = super.getProperties();
        Iterator it = this.implementedInterfaces.iterator();
        String ifaces = "";
        while (it.hasNext()) {
            ifaces = ifaces + (String)it.next();
            if (!it.hasNext()) continue;
            ifaces = ifaces + ";";
        }
        hm.put("implementedInterfaces", ifaces);
        return hm;
    }

    @Override
    public Object invokeMethod(String methodSignature, Object target, Object[] args) throws ComponentExecutionException {
        String errorMessage = "Attempting to invoke: class = " + this.getJavaType() + " method = " + methodSignature;
        try {
            if (target instanceof Invokeable) {
                return ((Invokeable)target).invoke(methodSignature, args);
            }
            if (this.javaclass == null) {
                this.javaclass = JavaClass.forName(this.getJavaType());
            }
            if (methodSignature.charAt(0) == 'K') {
                return this.javaclass.newInstance(methodSignature, args);
            }
            switch (methodSignature.charAt(0)) {
                case 'K': {
                    return this.javaclass.newInstance(methodSignature, args);
                }
                case 'A': {
                    if (args == null || args.length == 0) {
                        return this.javaclass.getAttributeValue(methodSignature, target);
                    }
                    this.javaclass.setAttributeValue(methodSignature, args[0], target);
                    return null;
                }
                case 'M': {
                    return this.javaclass.invokeMethod(target, methodSignature, new Object[0]);
                }
            }
            assert (false) : methodSignature;
            return null;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeExceptionShell(e, errorMessage);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeExceptionShell(e, errorMessage);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeExceptionShell(e, errorMessage);
        }
        catch (InvocationTargetException e) {
            throw new ComponentExecutionException(e, this.getJavaType(), methodSignature);
        }
        catch (Exception e) {
            throw new ComponentExecutionException(e);
        }
    }

    public void validate() throws ObjectTypeDescriptionException {
        Class cl = this.getJavaClass();
        if (cl == null) {
            throw new RealClassNotFoundException(this);
        }
    }

    @Override
    protected boolean isAssignableFromImpl(TypeDescription type) {
        if (type instanceof JavaObjectTypeDescription) {
            JavaObjectTypeDescription other = (JavaObjectTypeDescription)type;
            if (this.isInterface() && other.implementedInterfaces.contains(this.getJavaType())) {
                return true;
            }
        }
        return super.isAssignableFromImpl(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void loadMembers() {
        if (this.loaded) {
            return;
        }
        boolean isRemote = this.isRemote();
        this.setRemote(false);
        this.setDynamic(false);
        try {
            this.loaded = true;
            Class clazz = this.getJavaClass();
            if (clazz == null) {
                throw new RuntimeExceptionShell(new ClassNotFoundException(this.getJavaType()));
            }
            this.implementedInterfaces.clear();
            this.loadInterfaces(clazz);
            this.removeMembers();
        }
        finally {
            this.setRemote(isRemote);
            this.setDynamic(isRemote);
        }
    }

    static JavaObjectTypeDescription createObject() {
        return new JavaObjectTypeDescription();
    }

    private static Class loadClass(String pkg, String name) {
        try {
            return JavaClass.loadClass(pkg + "." + name);
        }
        catch (ClassNotFoundException exc) {
            return null;
        }
    }

    private void loadInterfaces(Class clazz) {
        for (Class<?> c : clazz.getInterfaces()) {
            this.implementedInterfaces.add(c.getName());
            for (Class<?> superIFace : c.getInterfaces()) {
                this.implementedInterfaces.add(superIFace.getName());
            }
        }
    }

    static {
        classLock = new Object();
    }
}

