/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import oracle.bpm.lang.AbstractTypeUUID;
import oracle.bpm.lang.XmlElementType;
import org.jetbrains.annotations.NotNull;

public class FaultUUID
extends AbstractTypeUUID {
    private String messageNamespace;
    private String messageName;

    private FaultUUID(@NotNull String namespace, @NotNull String name, @NotNull String messageNamespace, @NotNull String msgName) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/FaultUUID.<init> must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/FaultUUID.<init> must not be null");
        }
        if (messageNamespace == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/lang/FaultUUID.<init> must not be null");
        }
        if (msgName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/lang/FaultUUID.<init> must not be null");
        }
        super(namespace, name);
        this.messageNamespace = messageNamespace;
        this.messageName = msgName;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getId() {
        String string = this.getTypeId() + "|" + this.getNamespace() + "|" + this.getNativeName() + "|" + this.getMessageNamespace() + "|" + this.getMessageName();
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/FaultUUID.getId must not return null");
        }
        return string;
    }

    public String getMessageNamespace() {
        return this.messageNamespace;
    }

    public String getMessageName() {
        return this.messageName;
    }

    @Override
    protected char getTypeId() {
        return XmlElementType.FAULT.getCharCode();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    static FaultUUID parse(@NotNull String uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/FaultUUID.parse must not be null");
        }
        String[] strings = uuid.split("\\|");
        if (strings.length != 5) {
            throw new IllegalArgumentException("Invalid fault id: '" + uuid + "'");
        }
        String namespace = strings[1];
        String name = strings[2];
        String msgNamespace = strings[3];
        String msgName = strings[4];
        FaultUUID faultUUID = FaultUUID.create(namespace, name, msgNamespace, msgName);
        if (faultUUID == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/FaultUUID.parse must not return null");
        }
        return faultUUID;
    }

    static FaultUUID create(@NotNull String namespace, @NotNull String name, @NotNull String msgNamespace, @NotNull String msgName) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/FaultUUID.create must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/FaultUUID.create must not be null");
        }
        if (msgNamespace == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/lang/FaultUUID.create must not be null");
        }
        if (msgName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/lang/FaultUUID.create must not be null");
        }
        return new FaultUUID(namespace, name, msgNamespace, msgName);
    }
}

