/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.lang.Cache;
import oracle.bpm.log.Log;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.Repository;

public class BcelHelper {
    private Cache<String, JavaClass> cache;
    private ClassLoader cl;

    public BcelHelper(ClassLoader cl) {
        this.cl = cl;
        this.cache = new JavaClassCache(100);
    }

    public static void main(String[] args) {
        BcelHelper helper = new BcelHelper(BcelHelper.class.getClassLoader());
        JavaClass map = helper.getJavaClass("java.util.Map");
        JavaClass cache = helper.getJavaClass("oracle.bpm.lang.BcelHelper$JavaClassCache");
        System.out.println(helper.isAssignableFrom(map, cache));
        JavaClass bh = helper.getJavaClass("oracle.bpm.lang.BcelHelper");
        System.out.println(helper.isAssignableFrom(map, bh));
    }

    public boolean isAssignableFrom(JavaClass source, JavaClass target) {
        boolean result;
        String targetClassName = target.getClassName();
        if (source.getClassName().equals(targetClassName)) {
            result = true;
        } else {
            JavaClass superclass = target.getSuperClass();
            boolean bl = result = superclass != null && this.isAssignableFrom(source, superclass);
            if (!result) {
                JavaClass[] ifaces;
                for (JavaClass iface : ifaces = target.getInterfaces()) {
                    boolean bl2 = result = iface != null && this.isAssignableFrom(source, iface);
                    if (result) break;
                }
            }
        }
        return result;
    }

    public boolean hasField(JavaClass cl, String name) {
        Field[] fields;
        for (Field field : fields = cl.getFields()) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public JavaClass getJavaClass(String name) {
        return this.cache.get(name);
    }

    public boolean isAssignableFrom(Class<?> source, JavaClass cl) {
        return this.isAssignableFrom(this.getJavaClass(source.getName()), cl);
    }

    public <A extends Annotation> A getAnnotation(JavaClass cl, Class<A> annotation) {
        return null;
    }

    public String getSignature(Field field) {
        return null;
    }

    public String getSignature(Method field) {
        return null;
    }

    public String getJavaType(Type fieldClass) {
        return null;
    }

    public boolean isAssignableFrom(Class<?> aClass, Type type) {
        return false;
    }

    public Object getAnnotation(FieldOrMethod element, Class<Exclude> annotation) {
        return null;
    }

    public boolean containsMethod(JavaClass object, String signature) {
        return false;
    }

    private static boolean nullOrEmpty(String string) {
        return string == null || string.equals("");
    }

    private JavaClass loadClass(String name) throws IOException {
        InputStream is = this.loadByteCode(name);
        ClassParser parser = new ClassParser(is, name);
        return parser.parse();
    }

    private InputStream loadByteCode(String name) throws FileNotFoundException {
        InputStream is = this.cl.getResourceAsStream(name.replace('.', '/') + ".class");
        if (is == null) {
            throw new FileNotFoundException(name);
        }
        return is;
    }

    public class JavaClassCache
    extends Cache<String, JavaClass>
    implements Repository {
        private static final long serialVersionUID = -126354491541993036L;

        public JavaClassCache(int capacity) {
            super(capacity);
        }

        public JavaClass loadClass(Class aClass) throws ClassNotFoundException {
            throw new UnsupportedOperationException();
        }

        public JavaClass loadClass(String string) throws ClassNotFoundException {
            return (JavaClass)this.get(string);
        }

        public JavaClass findClass(String string) {
            return (JavaClass)this.get(string);
        }

        public void removeClass(JavaClass javaClass) {
            throw new UnsupportedOperationException();
        }

        public void storeClass(JavaClass javaClass) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected JavaClass load(String key) {
            JavaClass javaClass;
            block2: {
                javaClass = null;
                try {
                    javaClass = BcelHelper.this.loadClass(key);
                    javaClass.setRepository((Repository)this);
                }
                catch (IOException e) {
                    if (!Log.isDebugging()) break block2;
                    Log.logDebug(e);
                }
            }
            return javaClass;
        }
    }
}

