/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.bpm.lang.ArrayDelegate;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.CollectionTypeDescription;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.IllegalTypeException;
import oracle.bpm.lang.Initialization;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.util.DefaultValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayTypeDescription
extends CollectionTypeDescription {
    @Nullable
    private ObjectTypeDescription objectType;
    private static final Class SORTED_MAP = SortedMap.class;
    private static final Class<TreeMap> SORTED_MAP_IMPL = TreeMap.class;
    private static final Class MAP = Map.class;
    private static final Class<LinkedHashMap> MAP_IMPL = LinkedHashMap.class;
    private static final Class<List> ARRAY = List.class;
    private static final Class<ArrayList> ARRAY_IMPL = ArrayList.class;
    private static final SourceCode EXTEND_REFACTOR = SourceCode.create("#Extend($parent)", "Compiler");
    private static final String LEGACY_GROUP_ARRAY = "oracle.bpm.util.LegacyGroupArray";
    private static final String GROUP_ARRAY = "oracle.bpm.xobject.GroupArray";

    public ArrayTypeDescription(@NotNull TypeRef el, TypeRef ix, boolean ord, boolean primitive, String javaType) {
        if (el == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/ArrayTypeDescription.<init> must not be null");
        }
        this(ix == null ? 12 : 13, ord, primitive || javaType != null && javaType.endsWith("[]"));
        assert (el != null) : "Null element type";
        this.setElementType(el);
        this.setIndexType(ix);
        this.javaType = javaType;
    }

    protected ArrayTypeDescription(TypeRef el, TypeRef ix, boolean ord) {
        this(el, ix, ord, false, null);
    }

    protected ArrayTypeDescription(TypeRef el, TypeRef ix, Class cl) {
        this(el, ix, SortedMap.class.isAssignableFrom(cl), false, cl.getName());
    }

    protected ArrayTypeDescription(int kind, String element, String index, String javaType, boolean ord, ComponentCatalog catalog) {
        this(kind, ord, javaType != null && javaType.endsWith("[]"));
        this.elementText = element;
        this.indexText = index;
        this.catalog = catalog;
        this.setJavaType(javaType);
    }

    private ArrayTypeDescription(int kind, boolean ord, boolean primitive) {
        super(kind);
        this.isOrdered = ord;
        this.setPrimitive(primitive);
    }

    public static ArrayTypeDescription valueOf(String indexSpec, String elementSpec, String javaType, ComponentCatalog catalog, boolean lazy, TypeDescription context) throws IllegalTypeException {
        indexSpec = indexSpec.trim();
        boolean ordered = false;
        int kind = 12;
        if (!"".equals(indexSpec)) {
            kind = 13;
            ordered = indexSpec.startsWith("ordered ");
            if (ordered) {
                indexSpec = indexSpec.substring("ordered".length() + 1);
            }
        } else {
            indexSpec = null;
        }
        if (lazy) {
            return new ArrayTypeDescription(kind, elementSpec, indexSpec, javaType, ordered, catalog);
        }
        TypeRef elementType = TypeFactory.forName(elementSpec, catalog, javaType, context);
        TypeRef indexType = null;
        if (kind == 13) {
            indexType = TypeFactory.forName(indexSpec, catalog, null, context);
        }
        return new ArrayTypeDescription(elementType, indexType, ordered);
    }

    @Override
    public void setElementType(TypeRef el) {
        assert (!(el instanceof TypeDescription) || !el.get().isVoid()) : "Invalid element type: " + el;
        this.objectType = null;
        super.setElementType(el);
    }

    @Override
    public void setIndexType(TypeRef ixType) {
        assert (!(ixType instanceof TypeDescription) || !ixType.get().isVoid()) : "Invalid element type: " + ixType;
        this.objectType = null;
        super.setIndexType(ixType);
    }

    @Override
    public Class getJavaClass() {
        if (this.getKind() == 13) {
            return this.isOrdered() ? SORTED_MAP : MAP;
        }
        if (!this.isPrimitive()) {
            return ARRAY;
        }
        Class<?> elClass = this.getElementType().getJavaClass();
        return elClass != null ? ArrayUtils.arrayOf(elClass) : null;
    }

    public void setJavaType(String javaType) {
        this.objectType = null;
        this.javaType = javaType;
    }

    public void setOrdered(boolean ordered) {
        this.objectType = null;
        this.isOrdered = ordered;
    }

    @Override
    public TypeDescription setReferenceType(boolean v) {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public final String getText() {
        String element;
        String string = element = this.elementText != null ? this.elementText : this.getElementType().getText();
        String index = this.indexText != null ? this.indexText : (this.getIndexType() != null ? this.getIndexType().getText() : "");
        String string2 = element + "[" + (this.isOrdered ? "ordered " : "") + index + "]";
        if (string2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/ArrayTypeDescription.getText must not return null");
        }
        return string2;
    }

    @Override
    public String getImplementationType() {
        if (this.getKind() == 13) {
            return this.isOrdered() ? SORTED_MAP_IMPL.getName() : MAP_IMPL.getName();
        }
        if (!this.isPrimitive()) {
            return ARRAY_IMPL.getName();
        }
        return this.getElementType().getJavaType() + "[]";
    }

    @Override
    public Initialization getInitialization() {
        return this.getKind() == 13 || !this.isPrimitive() ? Initialization.DEFAULT_CONSTRUCTOR : Initialization.EMPTY_ARRAY;
    }

    @Override
    public String getJavaSignature() {
        if (this.javaType == null && this.isPrimitive() && !this.isMap()) {
            return "[" + this.getElementType().getJavaSignature();
        }
        return 'L' + this.getJavaType() + ';';
    }

    @Override
    public String getJavaType() {
        if (this.javaType != null) {
            return this.javaType;
        }
        if (this.getKind() == 13) {
            return this.isOrdered() ? SORTED_MAP.getName() : MAP.getName();
        }
        if (!this.isPrimitive()) {
            return ARRAY.getName();
        }
        return this.getElementType().getJavaType() + "[]";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ObjectTypeDescription asObject() {
        ObjectTypeDescription type = this.objectType;
        if (type == null) {
            if (this.getKind() != 12) {
                type = new MapObjectTypeDescription(this.getText());
                type.addSyntheticMethods();
            } else if (this.isPrimitive()) {
                type = this.primitiveArray();
            } else {
                type = new ArrayObjectTypeDescription(this.getText());
                type.addSyntheticMethods();
            }
            type.setSuperTypes(SuperType.getAnySuperTypeList());
            if (!this.getElementType().isBpmObject()) {
                this.objectType = type;
            }
        }
        ObjectTypeDescription objectTypeDescription = type;
        if (objectTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/ArrayTypeDescription.asObject must not return null");
        }
        return objectTypeDescription;
    }

    @Override
    public boolean equality(TypeDescription b) {
        return b.getKind() == 9 || this.getKind() == b.getKind() && this.getElementType().equality(b.getElementType()) && (this.getIndexType() == null || this.getIndexType().equality(b.getIndexType()));
    }

    @Override
    public boolean equals(Object value) {
        if (this == value) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (!(value instanceof ArrayTypeDescription)) {
            return false;
        }
        ArrayTypeDescription type = (ArrayTypeDescription)value;
        return this.getKind() == type.getKind() && this.getElementTypeRef().equals(type.getElementTypeRef()) && (this.getIndexType() == null || this.getIndexType().equals(type.getIndexType())) && this.isOrdered == type.isOrdered() && this.isPrimitive() == type.isPrimitive();
    }

    @Override
    public boolean equivalent(TypeDescription b) {
        return this.getKind() == b.getKind() && this.getElementType().equivalent(b.getElementType()) && (this.getIndexType() == null || this.getIndexType().equivalent(b.getIndexType())) && this.isOrdered == b.isOrdered() && this.isPrimitive() == b.isPrimitive();
    }

    @Override
    public Object newInstance() throws ComponentExecutionException {
        Class cl = this.getJavaClass();
        return DefaultValue.forClass(cl);
    }

    @Override
    public TypeDescription primitiveEquivalent(boolean prim) {
        ArrayTypeDescription result;
        int kind = this.getKind();
        if (super.isPrimitive() == prim || kind == 13) {
            result = this;
        } else if (this.indexType != null || this.elementText != null) {
            ArrayTypeDescription array = new ArrayTypeDescription(kind, this.isOrdered(), prim);
            array.elementText = this.elementText;
            array.elementType = this.elementType;
            array.indexText = this.indexText;
            array.indexType = this.indexType;
            array.javaType = this.javaType;
            array.catalog = this.catalog;
            result = array;
        } else {
            result = new ArrayTypeDescription(this.getElementType(), this.getIndexType(), this.isOrdered, prim, null);
        }
        return result;
    }

    @Override
    public TypeDescription promoteImpl(TypeDescription b) {
        if (b.getKind() != this.getKind()) {
            return TypeFactory.getAny();
        }
        TypeDescription bet = b.getElementType();
        TypeDescription net = null;
        if (!this.getElementType().equals(bet)) {
            net = this.getElementType().promote(bet);
        }
        if (this.getKind() == 12) {
            if (net == null) {
                return b;
            }
            return new ArrayTypeDescription((TypeRef)net, null, false);
        }
        if (net == null) {
            if (this.getIndexType().equals(b.getIndexType())) {
                return this.isOrdered ? this : b;
            }
            net = bet;
        }
        TypeDescription ix = this.getIndexType().promote(b.getIndexType());
        return new ArrayTypeDescription((TypeRef)net, (TypeRef)ix, this.isOrdered || b.isOrdered());
    }

    @Override
    protected boolean isAssignableFromImpl(TypeDescription b) {
        if (!(b instanceof ArrayTypeDescription)) {
            return false;
        }
        if (b.getElementType().getKind() == 9) {
            return true;
        }
        ArrayTypeDescription atd = (ArrayTypeDescription)b;
        if (!this.getElementType().isAssignableFrom(atd.getElementType())) {
            return false;
        }
        if (this.getKind() == 12 && atd.getKind() == 12) {
            return true;
        }
        return this.getKind() == 13 && atd.getKind() == 13 && this.getIndexType().isAssignableFrom(atd.getIndexType());
    }

    @Override
    protected String getElementJavaType(String jtype) {
        if (jtype == null) {
            return null;
        }
        int brackets = jtype.lastIndexOf("[]");
        return brackets != -1 ? jtype.substring(0, brackets) : null;
    }

    private static void addAttribute(ObjectTypeDescription type, String name, TypeDescription resulType, String signature) {
        AttributeTypeDescription method = new AttributeTypeDescription(name, resulType);
        method.setModifiers(0x808808L);
        method.setSignature(signature);
        type.addMember(method);
    }

    private static void addFunction(ObjectTypeDescription type, String name, TypeDescription resulType, String signature) {
        MethodTypeDescription method = new MethodTypeDescription(name);
        method.setModifiers(0x800000L);
        if (!resulType.isVoid()) {
            method.setResultType(resulType);
            method.getResultArgument().setModifiers(2064L);
        }
        method.setSignature(signature);
        type.addMember(method);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private ObjectTypeDescription primitiveArray() {
        PrimitiveArrayTypeDescription type = new PrimitiveArrayTypeDescription();
        MethodTypeDescription method = new MethodTypeDescription("length");
        method.setModifiers(0x800000L);
        method.setResultType(TypeFactory.getPrimitiveInt(32));
        String delegated = "Loracle.bpm.lang.ArrayDelegate;";
        method.setSignature("Loracle.bpm.lang.ArrayDelegate;Mlength(Ljava.lang.Object;)I");
        type.addMember(method);
        PrimitiveArrayTypeDescription primitiveArrayTypeDescription = type;
        if (primitiveArrayTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/ArrayTypeDescription.primitiveArray must not return null");
        }
        return primitiveArrayTypeDescription;
    }

    private class PrimitiveArrayTypeDescription
    extends ObjectTypeDescription {
        public PrimitiveArrayTypeDescription() {
            super(ArrayTypeDescription.this.getText(), ArrayTypeDescription.this.getKind(), ArrayTypeDescription.this.isPrimitive());
        }

        @Override
        public Object invokeMethod(String methodSignature, Object target, Object[] args) {
            assert (args != null && args.length == 1) : "Array must be the first argument";
            return ArrayDelegate.length(args[0]);
        }

        @Override
        public Class getJavaClass() {
            return ArrayTypeDescription.this.getJavaClass();
        }

        @Override
        public String getJavaType() {
            return "oracle.bpm.lang.ArrayDelegate";
        }
    }

    private class MapObjectTypeDescription
    extends ObjectTypeDescription {
        public MapObjectTypeDescription(String text) {
            super(text, 11, false);
        }

        @Override
        public Class getJavaClass() {
            return ArrayTypeDescription.this.getJavaClass();
        }

        @Override
        public String getJavaType() {
            return this.getJavaClass().getName();
        }

        @Override
        public Object invokeMethod(String methodSignature, Object target, Object[] args) throws ComponentExecutionException {
            String methodName;
            Map map = (Map)target;
            String delegated = null;
            if (methodSignature.charAt(0) == 'L') {
                int index = methodSignature.indexOf(";");
                delegated = methodSignature.substring(0, index);
                methodSignature = methodSignature.substring(index + 1);
            }
            if ("remove".equals(methodName = JavaClass.getMethodNameFromSignature(methodSignature))) {
                return map.remove(args[0]);
            }
            if (delegated != null) {
                Class<ArrayDelegate> cl = ArrayDelegate.class;
                Class[] argTypes = new Class[]{Map.class};
                try {
                    Method m = cl.getMethod(methodName, argTypes);
                    return m.invoke(null, args);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeExceptionShell(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeExceptionShell(e);
                }
                catch (InvocationTargetException e) {
                    throw new ComponentExecutionException(e, cl, methodName);
                }
            }
            throw new RuntimeException("No such method: " + methodSignature);
        }

        @Override
        protected boolean isAssignableFromImpl(TypeDescription source) {
            boolean assignable;
            block4: {
                assignable = super.isAssignableFromImpl(source);
                if (!assignable && this.isAnyToAny(ArrayTypeDescription.this) && source.isObject()) {
                    try {
                        ComponentCatalog catalog = source.asObject().getCatalog();
                        if (catalog != null) {
                            TypeRef mapType = catalog.find("Java.Util.Map");
                            assignable = mapType != null && mapType.get().isAssignableFrom(source);
                        }
                    }
                    catch (AmbiguousTypeNameException e) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError((Object)e);
                    }
                }
            }
            return assignable;
        }

        @Override
        protected void addSyntheticMethods() {
            TypeDescription indexType = ArrayTypeDescription.this.getIndexType();
            MethodTypeDescription method = new MethodTypeDescription("delete");
            method.setResultType(TypeFactory.getAny());
            method.setSignature("Mremove(Ljava.lang.Object;)Ljava.lang.Object;");
            method.addArgument(new Argument("index", indexType, 1L));
            this.addMember(method);
            method = new MethodTypeDescription("length");
            method.setModifiers(0x800000L);
            method.setResultType(TypeFactory.getPrimitiveInt(32));
            String delegated = "Loracle.bpm.lang.ArrayDelegate;";
            method.setSignature("Loracle.bpm.lang.ArrayDelegate;Mlength(Ljava.util.Map;)I");
            this.addMember(method);
            ArrayTypeDescription.addAttribute(this, "keys", TypeFactory.getSet(indexType), "Loracle.bpm.lang.ArrayDelegate;Mkeys(Ljava.util.Map;)Ljava.util.Set;");
            this.addMember(this.createClearMethod("Loracle.bpm.lang.ArrayDelegate;"));
        }

        private boolean isAnyToAny(ArrayTypeDescription type) {
            return type.getElementType().isAny() && type.getIndexType().isAny();
        }

        private MethodTypeDescription createClearMethod(String delegated) {
            MethodTypeDescription method = new MethodTypeDescription("clear");
            method.setModifiers(0x800000L);
            method.setResultType(TypeFactory.getVoid());
            method.setSignature(delegated + "Mclear(Ljava.util.Map;)V");
            return method;
        }
    }

    private class ArrayObjectTypeDescription
    extends ObjectTypeDescription {
        ArrayObjectTypeDescription(String text) {
            if (text == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/ArrayTypeDescription$ArrayObjectTypeDescription.<init> must not be null");
            }
            super(text, 11, false);
        }

        @Override
        public Class getJavaClass() {
            return ArrayTypeDescription.this.getJavaClass();
        }

        @Override
        public String getJavaType() {
            return this.getJavaClass().getName();
        }

        @Override
        public void addSyntheticMethods() {
            boolean addExtendMethod;
            this.addMember(this.createDeleteMethod());
            this.addMember(this.createInsertMethod());
            TypeDescription elem = ArrayTypeDescription.this.getElementType();
            boolean isGroup = elem.isBpmObject() && elem.isInnerType();
            boolean bl = addExtendMethod = !isGroup || this.isGroupArray(ArrayTypeDescription.this);
            if (addExtendMethod) {
                MethodTypeDescription constructor = elem.findMember(elem.getName());
                if (constructor != null) {
                    while (constructor != null) {
                        this.addMember(this.createExtend(elem, constructor));
                        constructor = constructor.getNextMethod();
                    }
                } else if (isGroup) {
                    this.addMember(this.createExtend(elem, null));
                }
            }
            String delegated = "Loracle.bpm.lang.ArrayDelegate;";
            this.addMember(this.createCountMethod("Loracle.bpm.lang.ArrayDelegate;"));
            this.addMember(this.createLengthMethod("Loracle.bpm.lang.ArrayDelegate;"));
            this.addMember(this.createClearMethod("Loracle.bpm.lang.ArrayDelegate;"));
            this.addMember(this.createIndexOfMethod("Loracle.bpm.lang.ArrayDelegate;"));
            this.addMember(this.createLastIndexOfMethod("Loracle.bpm.lang.ArrayDelegate;"));
            ArrayTypeDescription.addAttribute(this, "first", elem, "Loracle.bpm.lang.ArrayDelegate;Mfirst(Ljava.util.List;)Ljava.lang.Object;");
            ArrayTypeDescription.addAttribute(this, "last", elem, "Loracle.bpm.lang.ArrayDelegate;Mlast(Ljava.util.List;)Ljava.lang.Object;");
            if (ArrayTypeDescription.this.getKind() == 12 && elem.isComparable(elem)) {
                ArrayTypeDescription.addFunction(this, "max", elem, "Loracle.bpm.lang.ArrayDelegate;Mmax(Ljava.util.List;)Ljava.lang.Object;");
                ArrayTypeDescription.addFunction(this, "min", elem, "Loracle.bpm.lang.ArrayDelegate;Mmin(Ljava.util.List;)Ljava.lang.Object;");
                ArrayTypeDescription.addFunction(this, "sort", TypeFactory.getVoid(), "Loracle.bpm.lang.ArrayDelegate;Msort(Ljava.util.List;)V");
            }
            if (ArrayTypeDescription.this.getKind() == 12 && (elem.isNumber() || elem.getKind() == 7)) {
                TypeDescription resulType = elem.isInt() ? TypeFactory.getPrimitiveInt(64) : (elem.isReal() ? TypeFactory.getPrimitiveReal(64) : elem);
                String javaSignature = resulType.getJavaSignature();
                String thisName = resulType.getName();
                ArrayTypeDescription.addFunction(this, "sum", resulType, "Loracle.bpm.lang.ArrayDelegate;Msum" + thisName + "(Ljava.util.List;)" + javaSignature);
                ArrayTypeDescription.addFunction(this, "avg", resulType, "Loracle.bpm.lang.ArrayDelegate;Mavg" + thisName + "(Ljava.util.List;)" + javaSignature);
            }
        }

        @Override
        public Object invokeMethod(String methodSignature, Object target, Object[] args) throws ComponentExecutionException {
            List list = (List)target;
            String delegated = null;
            if (methodSignature.charAt(0) == 'L') {
                int index = methodSignature.indexOf(";");
                delegated = methodSignature.substring(0, index);
                methodSignature = methodSignature.substring(index + 1);
            }
            String methodName = JavaClass.getMethodNameFromSignature(methodSignature);
            if (delegated != null) {
                Class[] argTypes = new Class[]{List.class};
                if (methodName.endsWith("Of")) {
                    argTypes = new Class[]{List.class, Object.class};
                }
                Class<ArrayDelegate> cl = ArrayDelegate.class;
                try {
                    Method m = cl.getMethod(methodName, argTypes);
                    return m.invoke(null, args);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeExceptionShell(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeExceptionShell(e);
                }
                catch (InvocationTargetException e) {
                    throw new ComponentExecutionException(e, cl, methodName);
                }
            }
            if ("remove".equals(methodName)) {
                return list.remove(((Number)args[0]).intValue());
            }
            if ("add".equals(methodName)) {
                list.add(((Number)args[0]).intValue(), args[1]);
                return null;
            }
            throw new RuntimeException("No such method: " + methodName);
        }

        boolean isGroupArray(TypeDescription type) {
            String javaType = type.getJavaType();
            return type.isArray() && (ArrayTypeDescription.LEGACY_GROUP_ARRAY.equals(javaType) || ArrayTypeDescription.GROUP_ARRAY.equals(javaType));
        }

        private List<MethodTypeDescription> addMembers(TypeDescription type, Set<String> namesSet, List<MethodTypeDescription> members) {
            int count = type.getMemberCount();
            for (int i = 0; i < count; ++i) {
                boolean isVisible;
                MethodTypeDescription member = type.getMemberType(i);
                String nm = member.getName();
                boolean isWriteable = member.isAttribute() && Modifier.hasSetter(member.getModifiers());
                boolean bl = isVisible = member.isVisible() && !Modifier.isDeprecated(member.getModifiers());
                if (!isWriteable || !isVisible || !namesSet.isEmpty() && namesSet.contains(nm)) continue;
                members.add(member);
                namesSet.add(nm);
            }
            for (SuperType superType : type.getSuperTypes()) {
                TypeDescription baseType = superType.getType();
                if (superType.isHidden() || superType.isInterface()) continue;
                this.addMembers(baseType, namesSet, members);
            }
            return members;
        }

        private MethodTypeDescription createClearMethod(String delegated) {
            MethodTypeDescription method = new MethodTypeDescription("clear");
            method.setModifiers(0x800000L);
            method.setResultType(TypeFactory.getVoid());
            method.setSignature(delegated + "Mclear(Ljava.util.List;)V");
            return method;
        }

        private MethodTypeDescription createCountMethod(String delegated) {
            MethodTypeDescription method = new MethodTypeDescription("count");
            method.setModifiers(0x800000L);
            method.setResultType(TypeFactory.getPrimitiveInt(32));
            method.setSignature(delegated + "Mcount(Ljava.util.List;)I");
            return method;
        }

        private MethodTypeDescription createDeleteMethod() {
            MethodTypeDescription method = new MethodTypeDescription("delete");
            method.setResultType(TypeFactory.getAny());
            method.setSignature("Mremove(I)Ljava.lang.Object;");
            Argument arg = new Argument("index", TypeFactory.getPrimitiveInt(32), 1L);
            method.addArgument(arg);
            return method;
        }

        private MethodTypeDescription createExtend(TypeDescription type, MethodTypeDescription constr) {
            MethodTypeDescription extend = new MethodTypeDescription("extend", 32768L);
            HashSet<String> namesSet = new HashSet<String>();
            if (constr != null) {
                for (Argument arg : constr.getArguments()) {
                    extend.addArgument(arg.copy());
                    namesSet.add(arg.getName());
                }
            }
            ArrayList<MethodTypeDescription> members = new ArrayList<MethodTypeDescription>();
            this.addMembers(type, namesSet, members);
            Collections.sort(members, ATTRIBUTE_BY_POSITION_COMPARATOR);
            long flags = 0x80000001L;
            for (MethodTypeDescription member : members) {
                extend.addArgument(new Argument(member.getName(), member.getResultType(), 0x80000001L));
            }
            extend.addModifiers(0x8000000000L);
            extend.setCode(EXTEND_REFACTOR);
            return extend;
        }

        private MethodTypeDescription createIndexOfMethod(String delegated) {
            MethodTypeDescription method = new MethodTypeDescription("indexOf");
            method.setModifiers(0x800000L);
            method.setResultType(TypeFactory.getPrimitiveInt(32));
            method.addArgument(new Argument("element", TypeFactory.getAny(), 1L));
            method.setSignature(delegated + "MindexOf(Ljava.util.List;Ljava.lang.Object;)I");
            return method;
        }

        private MethodTypeDescription createInsertMethod() {
            MethodTypeDescription method = new MethodTypeDescription("insert");
            method.setResultType(TypeFactory.getVoid());
            method.setSignature("Madd(ILjava.lang.Object;)V");
            Argument arg = new Argument("int", TypeFactory.getPrimitiveInt(32), 1L);
            method.addArgument(arg);
            method.addArgument(new Argument("value", ArrayTypeDescription.this.getElementType(), 1L));
            return method;
        }

        private MethodTypeDescription createLastIndexOfMethod(String delegated) {
            MethodTypeDescription method = new MethodTypeDescription("lastIndexOf");
            method.setModifiers(0x800000L);
            method.setResultType(TypeFactory.getPrimitiveInt(32));
            method.addArgument(new Argument("element", TypeFactory.getAny(), 1L));
            method.setSignature(delegated + "MlastIndexOf(Ljava.util.List;Ljava.lang.Object;)I");
            return method;
        }

        private MethodTypeDescription createLengthMethod(String delegated) {
            MethodTypeDescription method = new MethodTypeDescription("length");
            method.setModifiers(0x800000L);
            method.setResultType(TypeFactory.getPrimitiveInt(32));
            method.setSignature(delegated + "Mlength(Ljava.util.List;)I");
            return method;
        }
    }
}

