/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.lang.Interval;
import oracle.bpm.util.ArrayUtils;

public final class ArrayDelegate {
    private ArrayDelegate() {
    }

    public static BigDecimal avgDecimal(List list) {
        int length = ArrayDelegate.count(list);
        return length != 0 ? ArrayDelegate.sumDecimal(list).divide(BigDecimal.valueOf(length), 4) : BigDecimal.valueOf(0L);
    }

    public static long avgInt(List list) {
        int length = ArrayDelegate.count(list);
        return length != 0 ? ArrayDelegate.sumInt(list) / (long)length : 0L;
    }

    public static Interval avgInterval(List list) {
        ArrayDelegate.count(list);
        return null;
    }

    public static double avgReal(List list) {
        int length = ArrayDelegate.count(list);
        return length != 0 ? ArrayDelegate.sumReal(list) / (double)length : 0.0;
    }

    public static void clear(List list) {
        if (list != null) {
            list.clear();
        }
    }

    public static void clear(Set set) {
        if (set != null) {
            set.clear();
        }
    }

    public static void clear(Map map) {
        if (map != null) {
            map.clear();
        }
    }

    public static int count(List list) {
        if (list == null) {
            return 0;
        }
        int length = list.size();
        int count = 0;
        for (int i = 0; i < length; ++i) {
            if (list.get(i) == null) continue;
            ++count;
        }
        return count;
    }

    public static Object first(List list) {
        return list == null || list.size() < 1 ? null : list.get(0);
    }

    public static int indexOf(List list, Object element) {
        return list != null ? list.indexOf(element) : -1;
    }

    public static Set keys(Map map) {
        return map != null ? map.keySet() : null;
    }

    public static Object last(List list) {
        return list == null || list.size() < 1 ? null : list.get(list.size() - 1);
    }

    public static int lastIndexOf(List list, Object element) {
        return list != null ? list.lastIndexOf(element) : -1;
    }

    public static int length(Map map) {
        return map != null ? map.size() : 0;
    }

    public static int length(Object array) {
        return ArrayUtils.length(array);
    }

    public static int length(List list) {
        return list != null ? list.size() : 0;
    }

    public static int length(Set set) {
        return set != null ? set.size() : 0;
    }

    public static Object max(List list) {
        int length = ArrayUtils.length(list);
        Comparable max = null;
        for (int i = 0; i < length; ++i) {
            Comparable element = (Comparable)list.get(i);
            if (max == null) {
                max = element;
                continue;
            }
            if (element == null || element.compareTo(max) <= 0) continue;
            max = element;
        }
        return max;
    }

    public static Object min(List<Comparable> list) {
        int length = ArrayUtils.length(list);
        Comparable min = null;
        for (int i = 0; i < length; ++i) {
            Comparable element = list.get(i);
            if (min == null) {
                min = element;
                continue;
            }
            if (element == null || element.compareTo(min) >= 0) continue;
            min = element;
        }
        return min;
    }

    public static void sort(List list) {
        Collections.sort(list);
    }

    public static BigDecimal sumDecimal(List list) {
        BigDecimal result = BigDecimal.ZERO;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                BigDecimal element = (BigDecimal)list.get(i);
                if (element == null) continue;
                result = result.add(element);
            }
        }
        return result;
    }

    public static long sumInt(List list) {
        long result = 0L;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Number element = (Number)list.get(i);
                if (element == null) continue;
                result += element.longValue();
            }
        }
        return result;
    }

    public static Interval sumInterval(List list) {
        Interval result = new Interval();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Interval element = (Interval)list.get(i);
                if (element == null) continue;
                result = result.add(element);
            }
        }
        return result;
    }

    public static double sumReal(List list) {
        double result = 0.0;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Number element = (Number)list.get(i);
                if (element == null) continue;
                result += element.doubleValue();
            }
        }
        return result;
    }
}

