/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import oracle.bpm.connector.impl.StatementHolder;
import oracle.bpm.jdbc.DatabaseManager;
import oracle.bpm.jdbc.FaultTolerantConnection;
import oracle.bpm.jdbc.FaultTolerantResource;
import oracle.bpm.jdbc.FaultTolerantResultSet;
import oracle.bpm.lang.AbortedException;
import oracle.bpm.lang.TimeoutException;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.util.ExecutionContext;
import oracle.bpm.util.ExecutionContextAccessor;

class FaultTolerantStatement
extends FaultTolerantResource
implements Statement {
    protected Statement statement;
    private FaultTolerantConnection connection;

    FaultTolerantStatement(Statement stmt, FaultTolerantConnection connection) {
        super(connection.canRetry());
        this.statement = stmt;
        this.connection = connection;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public void setCursorName(String s) throws SQLException {
        this.statement.setCursorName(s);
    }

    @Override
    public void setEscapeProcessing(boolean b) throws SQLException {
        this.statement.setEscapeProcessing(b);
    }

    @Override
    public void setFetchDirection(int i) throws SQLException {
        this.statement.setFetchDirection(i);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.statement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int i) throws SQLException {
        this.statement.setFetchSize(i);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.statement.getGeneratedKeys();
    }

    @Override
    public void setMaxFieldSize(int i) throws SQLException {
        this.statement.setMaxFieldSize(i);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    @Override
    public void setMaxRows(int i) throws SQLException {
        this.statement.setMaxRows(i);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    @Override
    public boolean getMoreResults(int i) throws SQLException {
        return this.statement.getMoreResults(i);
    }

    @Override
    public void setQueryTimeout(int i) throws SQLException {
        if (this.getFaultTolerantConnection().getJDBCConnector().supports(2048L)) {
            this.statement.setQueryTimeout(i);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.statement.getResultSet();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.statement.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    @Override
    public void addBatch(String s) throws SQLException {
        this.statement.addBatch(s);
    }

    @Override
    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.statement.clearBatch();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.statement.close();
    }

    @Override
    public boolean execute(String stmt) throws SQLException {
        SQLException originalException = null;
        this.setQueryTimeout();
        for (int i = 0; i < FaultTolerantStatement.getRetryTimes(); ++i) {
            try {
                boolean result = this.getStatement().execute(stmt);
                this.getFaultTolerantConnection().setDirty();
                StatementHolder.getInstance().statementExecuted(stmt);
                return result;
            }
            catch (SQLException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public boolean execute(String stmt, int i) throws SQLException {
        SQLException originalException = null;
        this.setQueryTimeout();
        for (int j = 0; j < FaultTolerantStatement.getRetryTimes(); ++j) {
            try {
                boolean result = this.getStatement().execute(stmt, i);
                this.getFaultTolerantConnection().setDirty();
                StatementHolder.getInstance().statementExecuted(stmt);
                return result;
            }
            catch (SQLException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, j);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public boolean execute(String stmt, int[] i) throws SQLException {
        SQLException originalException = null;
        this.setQueryTimeout();
        for (int j = 0; j < FaultTolerantStatement.getRetryTimes(); ++j) {
            try {
                boolean result = this.getStatement().execute(stmt, i);
                this.getFaultTolerantConnection().setDirty();
                StatementHolder.getInstance().statementExecuted(stmt);
                return result;
            }
            catch (SQLException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, j);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public boolean execute(String stmt, String[] i) throws SQLException {
        SQLException originalException = null;
        this.setQueryTimeout();
        for (int j = 0; j < FaultTolerantStatement.getRetryTimes(); ++j) {
            try {
                boolean result = this.getStatement().execute(stmt, i);
                this.getFaultTolerantConnection().setDirty();
                StatementHolder.getInstance().statementExecuted(stmt);
                return result;
            }
            catch (SQLException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, j);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        SQLException originalException = null;
        this.setQueryTimeout();
        for (int j = 0; j < FaultTolerantStatement.getRetryTimes(); ++j) {
            try {
                int[] result = this.getStatement().executeBatch();
                this.getFaultTolerantConnection().setDirty();
                return result;
            }
            catch (SQLException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, 1);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public ResultSet executeQuery(String s) throws SQLException {
        SQLException originalException = null;
        this.setQueryTimeout();
        for (int j = 0; j < FaultTolerantStatement.getRetryTimes(); ++j) {
            try {
                FaultTolerantResultSet result = new FaultTolerantResultSet(this, this.getStatement().executeQuery(s));
                this.getFaultTolerantConnection().setDirty();
                StatementHolder.getInstance().statementExecuted(s);
                return result;
            }
            catch (SQLException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, j);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public int executeUpdate(String s) throws SQLException {
        SQLException originalException = null;
        this.setQueryTimeout();
        for (int j = 0; j < FaultTolerantStatement.getRetryTimes(); ++j) {
            try {
                int result = this.getStatement().executeUpdate(s);
                this.getFaultTolerantConnection().setDirty();
                StatementHolder.getInstance().statementExecuted(s);
                return result;
            }
            catch (SQLException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, j);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public int executeUpdate(String s, int i) throws SQLException {
        SQLException originalException = null;
        this.setQueryTimeout();
        for (int j = 0; j < FaultTolerantStatement.getRetryTimes(); ++j) {
            try {
                int result = this.getStatement().executeUpdate(s, i);
                this.getFaultTolerantConnection().setDirty();
                StatementHolder.getInstance().statementExecuted(s);
                return result;
            }
            catch (SQLException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, j);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public int executeUpdate(String s, int[] i) throws SQLException {
        SQLException originalException = null;
        this.setQueryTimeout();
        for (int j = 0; j < FaultTolerantStatement.getRetryTimes(); ++j) {
            try {
                int result = this.getStatement().executeUpdate(s, i);
                this.getFaultTolerantConnection().setDirty();
                StatementHolder.getInstance().statementExecuted(s);
                return result;
            }
            catch (SQLException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, j);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public int executeUpdate(String s, String[] i) throws SQLException {
        SQLException originalException = null;
        this.setQueryTimeout();
        for (int j = 0; j < FaultTolerantStatement.getRetryTimes(); ++j) {
            try {
                int result = this.getStatement().executeUpdate(s, i);
                this.getFaultTolerantConnection().setDirty();
                StatementHolder.getInstance().statementExecuted(s);
                return result;
            }
            catch (SQLException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, j);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.statement.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.statement.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.statement.isPoolable();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.statement.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.statement.isWrapperFor(iface);
    }

    @Override
    protected DatabaseManager getDatabaseManager() {
        return this.getFaultTolerantConnection().getDatabaseManager();
    }

    protected FaultTolerantConnection getFaultTolerantConnection() {
        return this.connection;
    }

    protected void setQueryTimeout() {
        ExecutionContext ctx = ExecutionContextAccessor.getContext();
        if (ctx != null) {
            int timeOut;
            try {
                timeOut = (int)ctx.getTimeToLive();
                timeOut = timeOut > 0 && timeOut <= 1000 ? 1 : timeOut / 1000;
            }
            catch (TimeoutException e) {
                timeOut = 1;
            }
            catch (AbortedException e) {
                timeOut = 1;
            }
            try {
                this.setQueryTimeout(timeOut);
            }
            catch (SQLException e) {
                Log.logInfo(LibMsg.UNSUPPORTED_SET_TIMEOUT(e.getMessage()));
            }
        }
    }

    @Override
    protected String getResourceName() {
        return this.getFaultTolerantConnection().getResourceName();
    }

    protected Statement getStatement() {
        return this.statement;
    }

    @Override
    protected boolean isUnderlyingConnectionDirty() {
        return this.getFaultTolerantConnection().isUnderlyingConnectionDirty();
    }

    @Override
    protected void cleanUnderlyingConnection() {
        this.getFaultTolerantConnection().cleanUnderlyingConnection();
    }

    @Override
    protected void recreateConnection(int attempt) throws SQLException {
        if (this.getStatement() != null) {
            try {
                this.getStatement().close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.statement = null;
        }
        this.getFaultTolerantConnection().recreateConnection(attempt);
        this.statement = this.getFaultTolerantConnection().getConnection().createStatement();
    }
}

