/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import oracle.bpm.connector.impl.BaseJDBCConnector;
import oracle.bpm.connector.spi.JDBCConnectorInterface;
import oracle.bpm.jdbc.DatabaseManager;
import oracle.bpm.jdbc.FaultTolerantCallableStatement;
import oracle.bpm.jdbc.FaultTolerantPreparedStatement;
import oracle.bpm.jdbc.FaultTolerantResource;
import oracle.bpm.jdbc.FaultTolerantStatement;
import oracle.bpm.jdbc.LRUStatementCache;
import oracle.bpm.jdbc.PoolableStatement;
import oracle.bpm.jdbc.StatementCacheSizeExceededException;
import oracle.bpm.pool.Cache;

public class FaultTolerantConnection
extends FaultTolerantResource
implements Connection {
    protected Connection connection_d;
    protected JDBCConnectorInterface jdbcConnector_d;
    protected LRUStatementCache preparedStatementCache;
    private Properties authenticationProperties;
    private boolean autoReopen_d;
    private boolean canBeClosed;
    private boolean isCachingStatements;
    private boolean isDirty = false;
    private Cache pool;
    protected static final int MAX_RETRY_DEFAULT = 3;
    protected static final int ELAPSE_TIME = 12000;
    protected static int retryTimes_sd = 3;

    public FaultTolerantConnection(JDBCConnectorInterface connector, Connection connection, Properties statementCacheProperties, boolean retry, boolean canBeClosed, Cache pool, Properties authenticationProperties) {
        super(retry);
        this.jdbcConnector_d = connector;
        this.connection_d = connection;
        this.autoReopen_d = false;
        this.isCachingStatements = statementCacheProperties != null;
        this.canBeClosed = canBeClosed;
        this.pool = pool;
        if (this.isCachingStatements) {
            this.preparedStatementCache = LRUStatementCache.create(statementCacheProperties);
        }
        this.authenticationProperties = authenticationProperties;
    }

    protected FaultTolerantConnection(JDBCConnectorInterface connector, Properties statementCacheProperties, boolean retry, boolean canBeClosed, Cache pool, Properties authenticationProperties) {
        super(retry);
        this.jdbcConnector_d = connector;
        this.isCachingStatements = statementCacheProperties != null;
        this.autoReopen_d = true;
        if (this.isCachingStatements) {
            this.preparedStatementCache = LRUStatementCache.create(statementCacheProperties);
        }
        this.canBeClosed = canBeClosed;
        this.pool = pool;
        this.authenticationProperties = authenticationProperties;
    }

    public static FaultTolerantConnection create(JDBCConnectorInterface connector, Properties statementCacheProperties, boolean retry, boolean canBeClosed, Cache pool, Properties authenticationProperties) {
        return new FaultTolerantConnection(connector, statementCacheProperties, retry, canBeClosed, pool, authenticationProperties);
    }

    public static FaultTolerantConnection wrap(JDBCConnectorInterface connector, Connection connection) {
        return new FaultTolerantConnection(connector, connection, null, false, true, null, null);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.getConnection().setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.getConnection().getAutoCommit();
    }

    public boolean isCachingStatements() {
        return this.isCachingStatements;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.getConnection().setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.getConnection().getCatalog();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.getConnection().isClosed();
    }

    public void setDirty() {
        this.isDirty = true;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.getConnection().setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.getConnection().getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        SQLException originalException = null;
        for (int i = 0; i < FaultTolerantConnection.getRetryTimes(); ++i) {
            try {
                DatabaseMetaData metaData = this.getConnection().getMetaData();
                return metaData;
            }
            catch (SQLException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    public Cache getPool() {
        return this.pool;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.getConnection().setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.getConnection().isReadOnly();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.getConnection().setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.getConnection().setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.getConnection().setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.getConnection().getTransactionIsolation();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.getConnection().setTypeMap(map);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.getConnection().getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.getConnection().getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.getConnection().clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        if (this.canBeClosed && this.connection_d != null) {
            this.connection_d.close();
        }
    }

    public void close(Object sender) throws SQLException {
        if (this.jdbcConnector_d == sender) {
            if (this.isCachingStatements) {
                this.preparedStatementCache.clear(true);
            }
            if (this.connection_d != null) {
                this.connection_d.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Object sender) throws SQLException {
        this.isDirty = false;
        try {
            if (this.jdbcConnector_d == sender && this.connection_d != null) {
                this.connection_d.commit();
            }
        }
        finally {
            this.unlockStatements();
        }
    }

    @Override
    public void commit() throws SQLException {
    }

    public void setTransactionTimeStamp(long timestamp) {
        if (this.preparedStatementCache != null) {
            this.preparedStatementCache.setTimeStamp(timestamp);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        SQLException originalException = null;
        for (int i = 0; i < FaultTolerantConnection.getRetryTimes(); ++i) {
            try {
                FaultTolerantStatement stmt = new FaultTolerantStatement(this.getConnection().createStatement(), this);
                return stmt;
            }
            catch (SQLException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        SQLException originalException = null;
        for (int i = 0; i < FaultTolerantConnection.getRetryTimes(); ++i) {
            try {
                FaultTolerantStatement stmt = new FaultTolerantStatement(this.getConnection().createStatement(resultSetType, resultSetConcurrency), this);
                return stmt;
            }
            catch (SQLException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        SQLException originalException = null;
        for (int i = 0; i < FaultTolerantConnection.getRetryTimes(); ++i) {
            try {
                FaultTolerantStatement stmt = new FaultTolerantStatement(this.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this);
                return stmt;
            }
            catch (SQLException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.getConnection().nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        PoolableStatement statement = null;
        if (this.isCachingStatements) {
            statement = this.preparedStatementCache.get(sql);
        }
        SQLException originalException = null;
        try {
            for (int i = 0; i < FaultTolerantConnection.getRetryTimes(); ++i) {
                try {
                    if (statement == null) {
                        statement = new FaultTolerantCallableStatement(this.getConnection().prepareCall(sql), sql, this);
                        if (this.isCachingStatements) {
                            this.preparedStatementCache.put(sql, statement);
                        }
                    } else if (!(statement instanceof CallableStatement)) {
                        statement = new FaultTolerantCallableStatement(this.getConnection().prepareCall(sql), sql, this);
                        this.preparedStatementCache.put(sql, statement);
                    }
                    return (CallableStatement)((Object)statement);
                }
                catch (SQLException ex) {
                    originalException = originalException == null ? ex : originalException;
                    this.handleExceptions(ex, i);
                    continue;
                }
            }
        }
        catch (StatementCacheSizeExceededException moce) {
            throw new SQLException(moce.getMessage());
        }
        throw originalException;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PoolableStatement statement = null;
        if (this.isCachingStatements) {
            statement = this.preparedStatementCache.get(sql);
        }
        SQLException originalException = null;
        try {
            for (int i = 0; i < FaultTolerantConnection.getRetryTimes(); ++i) {
                try {
                    if (statement == null) {
                        statement = new FaultTolerantCallableStatement(this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency), sql, this);
                        if (this.isCachingStatements) {
                            this.preparedStatementCache.put(sql, statement);
                        }
                    } else if (!(statement instanceof CallableStatement)) {
                        statement = new FaultTolerantCallableStatement(this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency), sql, this);
                        this.preparedStatementCache.put(sql, statement);
                    }
                    return (CallableStatement)((Object)statement);
                }
                catch (SQLException ex) {
                    originalException = originalException == null ? ex : originalException;
                    this.handleExceptions(ex, i);
                    continue;
                }
            }
        }
        catch (StatementCacheSizeExceededException moce) {
            throw new SQLException(moce.getMessage());
        }
        throw originalException;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PoolableStatement statement = null;
        if (this.isCachingStatements) {
            statement = this.preparedStatementCache.get(sql);
        }
        SQLException originalException = null;
        try {
            for (int i = 0; i < FaultTolerantConnection.getRetryTimes(); ++i) {
                try {
                    if (statement == null) {
                        statement = new FaultTolerantCallableStatement(this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql, this);
                        if (this.isCachingStatements) {
                            this.preparedStatementCache.put(sql, statement);
                        }
                    } else if (!(statement instanceof CallableStatement)) {
                        statement = new FaultTolerantCallableStatement(this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql, this);
                        this.preparedStatementCache.put(sql, statement);
                    }
                    return (CallableStatement)((Object)statement);
                }
                catch (SQLException ex) {
                    originalException = originalException == null ? ex : originalException;
                    this.handleExceptions(ex, i);
                    continue;
                }
            }
        }
        catch (StatementCacheSizeExceededException moce) {
            throw new SQLException(moce.getMessage());
        }
        throw originalException;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PoolableStatement statement = null;
        if (this.isCachingStatements) {
            statement = this.preparedStatementCache.get(sql);
        }
        SQLException originalException = null;
        try {
            for (int i = 0; i < FaultTolerantConnection.getRetryTimes(); ++i) {
                try {
                    if (statement == null) {
                        statement = new FaultTolerantPreparedStatement(this.getConnection().prepareStatement(sql), sql, this);
                        if (this.isCachingStatements) {
                            this.preparedStatementCache.put(sql, statement);
                        }
                    } else if (!(statement instanceof PreparedStatement)) {
                        statement = new FaultTolerantPreparedStatement(this.getConnection().prepareStatement(sql), sql, this);
                        this.preparedStatementCache.put(sql, statement);
                    }
                    return (PreparedStatement)((Object)statement);
                }
                catch (SQLException ex) {
                    originalException = originalException == null ? ex : originalException;
                    this.handleExceptions(ex, i);
                    continue;
                }
            }
        }
        catch (StatementCacheSizeExceededException moce) {
            throw (SQLException)new SQLException(moce.getMessage()).initCause(moce);
        }
        throw originalException;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PoolableStatement statement = null;
        if (this.isCachingStatements) {
            statement = this.preparedStatementCache.get(sql);
        }
        SQLException originalException = null;
        try {
            for (int i = 0; i < FaultTolerantConnection.getRetryTimes(); ++i) {
                try {
                    if (statement == null) {
                        statement = new FaultTolerantPreparedStatement(this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency), sql, this);
                        if (this.isCachingStatements) {
                            this.preparedStatementCache.put(sql, statement);
                        }
                    } else if (!(statement instanceof PreparedStatement)) {
                        statement = new FaultTolerantPreparedStatement(this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency), sql, this);
                        this.preparedStatementCache.put(sql, statement);
                    }
                    return (PreparedStatement)((Object)statement);
                }
                catch (SQLException ex) {
                    originalException = originalException == null ? ex : originalException;
                    this.handleExceptions(ex, i);
                    continue;
                }
            }
        }
        catch (StatementCacheSizeExceededException moce) {
            throw new SQLException(moce.getMessage());
        }
        throw originalException;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PoolableStatement statement = null;
        if (this.isCachingStatements) {
            statement = this.preparedStatementCache.get(sql);
        }
        SQLException originalException = null;
        try {
            for (int i = 0; i < FaultTolerantConnection.getRetryTimes(); ++i) {
                try {
                    if (statement == null) {
                        statement = new FaultTolerantPreparedStatement(this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql, this);
                        if (this.isCachingStatements) {
                            this.preparedStatementCache.put(sql, statement);
                        }
                    } else if (!(statement instanceof PreparedStatement)) {
                        statement = new FaultTolerantPreparedStatement(this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql, this);
                        this.preparedStatementCache.put(sql, statement);
                    }
                    return (PreparedStatement)((Object)statement);
                }
                catch (SQLException ex) {
                    originalException = originalException == null ? ex : originalException;
                    this.handleExceptions(ex, i);
                    continue;
                }
            }
        }
        catch (StatementCacheSizeExceededException moce) {
            throw new SQLException(moce.getMessage());
        }
        throw originalException;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PoolableStatement statement = null;
        if (this.isCachingStatements) {
            statement = this.preparedStatementCache.get(sql);
        }
        SQLException originalException = null;
        try {
            for (int i = 0; i < FaultTolerantConnection.getRetryTimes(); ++i) {
                try {
                    if (statement == null) {
                        statement = new FaultTolerantPreparedStatement(this.getConnection().prepareStatement(sql, autoGeneratedKeys), sql, this);
                        if (this.isCachingStatements) {
                            this.preparedStatementCache.put(sql, statement);
                        }
                    } else if (!(statement instanceof PreparedStatement)) {
                        statement = new FaultTolerantPreparedStatement(this.getConnection().prepareStatement(sql, autoGeneratedKeys), sql, this);
                        this.preparedStatementCache.put(sql, statement);
                    }
                    return (PreparedStatement)((Object)statement);
                }
                catch (SQLException ex) {
                    originalException = originalException == null ? ex : originalException;
                    this.handleExceptions(ex, i);
                    continue;
                }
            }
        }
        catch (StatementCacheSizeExceededException moce) {
            throw new SQLException(moce.getMessage());
        }
        throw originalException;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PoolableStatement statement = null;
        if (this.isCachingStatements) {
            statement = this.preparedStatementCache.get(sql);
        }
        SQLException originalException = null;
        try {
            for (int i = 0; i < FaultTolerantConnection.getRetryTimes(); ++i) {
                try {
                    if (statement == null) {
                        statement = new FaultTolerantPreparedStatement(this.getConnection().prepareStatement(sql, columnIndexes), sql, this);
                        if (this.isCachingStatements) {
                            this.preparedStatementCache.put(sql, statement);
                        }
                    } else if (!(statement instanceof PreparedStatement)) {
                        statement = new FaultTolerantPreparedStatement(this.getConnection().prepareStatement(sql, columnIndexes), sql, this);
                        this.preparedStatementCache.put(sql, statement);
                    }
                    return (PreparedStatement)((Object)statement);
                }
                catch (SQLException ex) {
                    originalException = originalException == null ? ex : originalException;
                    this.handleExceptions(ex, i);
                    continue;
                }
            }
        }
        catch (StatementCacheSizeExceededException moce) {
            throw new SQLException(moce.getMessage());
        }
        throw originalException;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PoolableStatement statement = null;
        if (this.isCachingStatements) {
            statement = this.preparedStatementCache.get(sql);
        }
        SQLException originalException = null;
        try {
            for (int i = 0; i < FaultTolerantConnection.getRetryTimes(); ++i) {
                try {
                    if (statement == null) {
                        statement = new FaultTolerantPreparedStatement(this.getConnection().prepareStatement(sql, columnNames), sql, this);
                        if (this.isCachingStatements) {
                            this.preparedStatementCache.put(sql, statement);
                        }
                    } else if (!(statement instanceof PreparedStatement)) {
                        statement = new FaultTolerantPreparedStatement(this.getConnection().prepareStatement(sql, columnNames), sql, this);
                        this.preparedStatementCache.put(sql, statement);
                    }
                    return (PreparedStatement)((Object)statement);
                }
                catch (SQLException ex) {
                    originalException = originalException == null ? ex : originalException;
                    this.handleExceptions(ex, i);
                    continue;
                }
            }
        }
        catch (StatementCacheSizeExceededException moce) {
            throw new SQLException(moce.getMessage());
        }
        throw originalException;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.getConnection().releaseSavepoint(savepoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Object sender) throws SQLException {
        this.isDirty = false;
        try {
            if (this.jdbcConnector_d == sender && this.connection_d != null) {
                this.connection_d.rollback();
            }
        }
        finally {
            this.unlockStatements();
        }
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.getConnection().createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.getConnection().createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.getConnection().createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.getConnection().createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.getConnection().isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.getConnection().setClientInfo(name, value);
        }
        catch (SQLException e) {
            throw new SQLClientInfoException();
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.getConnection().setClientInfo(properties);
        }
        catch (SQLException e) {
            throw new SQLClientInfoException();
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.getConnection().getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.getConnection().getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.getConnection().createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.getConnection().createStruct(typeName, attributes);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getConnection().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getConnection().isWrapperFor(iface);
    }

    @Override
    protected DatabaseManager getDatabaseManager() {
        return this.getJDBCConnector().getDatabaseManager();
    }

    protected Connection getConnection() throws SQLException {
        if (this.connection_d == null) {
            if (this.autoReopen_d) {
                this.connection_d = this.createConnection();
            } else assert (false) : "trying to get connection when it is already closed";
        }
        return this.connection_d;
    }

    protected JDBCConnectorInterface getJDBCConnector() {
        return this.jdbcConnector_d;
    }

    @Override
    protected String getResourceName() {
        return this.getJDBCConnector().getName();
    }

    @Override
    protected boolean isUnderlyingConnectionDirty() {
        return this.isDirty;
    }

    @Override
    protected void cleanUnderlyingConnection() {
        this.isDirty = false;
    }

    protected Connection createConnection() throws SQLException {
        if (!(this.jdbcConnector_d instanceof BaseJDBCConnector)) {
            throw new UnsupportedOperationException("Can not recreate connection (needed information is missing)");
        }
        BaseJDBCConnector baseJDBCConnector = (BaseJDBCConnector)this.jdbcConnector_d;
        Connection connection = baseJDBCConnector.createJDBConnection(this.getAuthenticationProperties());
        this.isDirty = false;
        return connection;
    }

    protected Properties getAuthenticationProperties() {
        return this.authenticationProperties;
    }

    @Override
    protected void recreateConnection(int attempt) throws SQLException {
        if (!this.isDirty) {
            this.connection_d = null;
            this.autoReopen_d = true;
            this.connection_d = this.createConnection();
            if (this.isCachingStatements()) {
                this.getPreparedStatementCache().clear(true);
            }
        }
    }

    LRUStatementCache getPreparedStatementCache() {
        return this.preparedStatementCache;
    }

    private void unlockStatements() {
        if (this.isCachingStatements) {
            this.preparedStatementCache.unlockAll();
        }
    }
}

