/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class StoppableInputStream
extends FilterInputStream {
    private boolean stopPerformed = false;

    public StoppableInputStream(InputStream stream) {
        super(stream);
    }

    @Override
    public int read() throws IOException {
        if (this.stopPerformed) {
            return -1;
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.stopPerformed) {
            return -1;
        }
        return this.in.read(b, off, len);
    }

    public void stop() {
        this.stopPerformed = true;
    }

    public boolean stopPerformed() {
        return this.stopPerformed;
    }
}

