/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import oracle.bpm.io.BlockWriter;
import oracle.bpm.io.TransmissionAbortedException;
import oracle.bpm.io.TransportBlock;
import oracle.bpm.util.Latch;

public class RemoteInputBlockWriter
extends BlockWriter {
    protected Latch hasMore_d = null;
    protected Latch wantsMore_d = new Latch(true);

    public RemoteInputBlockWriter() {
        this.hasMore_d = new Latch(true);
    }

    @Override
    public void abort() {
        if (this.wantsMore_d == null) {
            throw new IllegalStateException("Invalid Operation on a closed writer");
        }
        this.hasMore_d.put(new InterruptedIOException());
        this.wantsMore_d.put(new TransmissionAbortedException());
    }

    @Override
    public void close() {
        if (this.wantsMore_d != null) {
            this.wantsMore_d = null;
            this.hasMore_d = null;
        }
    }

    public void raiseException(RuntimeException e) throws IOException {
        if (this.wantsMore_d == null) {
            throw new IOException("Invalid Operation on a closed writer");
        }
        this.wantsMore_d.put(e);
    }

    public TransportBlock readBlock() throws IOException {
        if (this.wantsMore_d == null) {
            throw new IOException("Invalid Operation on a closed writer");
        }
        this.wantsMore_d.put("MORE");
        Object result = this.hasMore_d.get();
        if (result instanceof IOException) {
            throw (IOException)result;
        }
        return (TransportBlock)result;
    }

    public void sendResponse() throws IOException {
        if (this.wantsMore_d == null) {
            throw new IOException("Invalid Operation on a closed writer");
        }
        this.wantsMore_d.put("EOF");
    }

    public void waitResponse() throws IOException {
        if (this.wantsMore_d == null) {
            throw new IOException("Invalid Operation on a closed writer");
        }
        Object result = this.wantsMore_d.get();
        if (result instanceof RuntimeException) {
            throw (RuntimeException)result;
        }
    }

    @Override
    public void write(TransportBlock block) throws IOException {
        if (this.wantsMore_d == null) {
            throw new IOException("Invalid Operation on a closed writer");
        }
        if (block.index != this.index_d) {
            throw new IOException("BlockWriter and TransportBlock Index mismatch!");
        }
        this.hasMore_d.put(block);
        this.waitResponse();
    }

    @Override
    protected void finalize() throws Exception {
        if (this.wantsMore_d != null) {
            this.close();
        }
    }
}

