/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.IdentityHashMap;
import oracle.bpm.io.ClassResolver;
import oracle.bpm.io.ReferenceManager;
import oracle.bpm.util.CatalogLoaderMgr;

public class ReferenceInputStream
extends ObjectInputStream {
    private ReferenceManager manager;
    private IdentityHashMap<Object, Object> replacements;
    private static ClassResolver classResolver;

    public ReferenceInputStream(InputStream in, ReferenceManager manager) throws IOException {
        super(in);
        this.manager = manager;
        this.replacements = new IdentityHashMap();
        this.enableResolveObject(true);
    }

    public static void setClassResolver(ClassResolver resolver) {
        classResolver = resolver;
    }

    @Override
    public void close() throws IOException {
        this.manager.replace(this.replacements);
        super.close();
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        Class<?> aClass = null;
        try {
            aClass = CatalogLoaderMgr.resolveClass(this, desc);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (aClass == null && classResolver != null) {
            aClass = classResolver.resolveClass(desc);
        }
        if (aClass == null) {
            aClass = super.resolveClass(desc);
        }
        return aClass;
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        return this.manager.processRead(this.replacements, obj);
    }
}

