/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public final class PreGeneratedOutput {
    private int current_d = 0;
    private String encoding_d = "utf-8";
    private int length_d = 10;
    private byte[][] output_d = new byte[10][];
    private static final byte[] PARAMETER = null;

    public static void main(String[] args) throws IOException {
        PreGeneratedOutput output = new PreGeneratedOutput();
        output.setEncoding("utf-8");
        output.write("<SOAP-ENV:Envelope xmlns:SOAP=\"http://schemas.xmlsoap.org/soap/envelope/\"\n");
        output.write("SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"/>\n");
        output.write("<SOAP-ENV:Header></SOAP-ENV:Header>\n");
        output.write("<SOAP-ENV:Body>\n");
        output.write("<m:GetLastTracePrice xmlns:m=\"Some-URI\">\n");
        output.write("<symbol>");
        output.writeParameter();
        output.write("</symbol>\n");
        output.write("</m:GetLastTracePrice>\n");
        output.write("</SOAP-ENV:Body>\n");
        output.write("</SOAP-ENV:Envelope>\n");
        long start1 = System.currentTimeMillis();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (int i = 0; i < 100; ++i) {
            output.writeTo(os, new String[]{"123" + i});
        }
        System.out.println("Elapsed time: " + (System.currentTimeMillis() - start1) + " ms");
        OutputStreamWriter o = new OutputStreamWriter(new ByteArrayOutputStream());
        long start2 = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            o.write("<SOAP-ENV:Envelope xmlns:SOAP=\"http://schemas.xmlsoap.org/soap/envelope/\"\n");
            o.write("SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"/>\n");
            o.write("<SOAP-ENV:Header></SOAP-ENV:Header>\n");
            o.write("<SOAP-ENV:Body>\n");
            o.write("<m:GetLastTracePrice xmlns:m=\"Some-URI\">\n");
            o.write("<symbol>");
            o.write("123" + i);
            o.write("</symbol>\n");
            o.write("</m:GetLastTracePrice>\n");
            o.write("</SOAP-ENV:Body>\n");
            o.write("</SOAP-ENV:Envelope>\n");
        }
        System.out.println("Elapsed time: " + (System.currentTimeMillis() - start2) + " ms");
    }

    public void setEncoding(String encoding) {
        this.encoding_d = encoding;
    }

    public void write(String data) {
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null");
        }
        byte[] encodedData = this.encode(data);
        this.append(encodedData);
    }

    public void writeParameter() {
        this.append(PARAMETER);
    }

    public void writeTo(OutputStream out, String[] args) throws IOException {
        int n = 0;
        for (int i = 0; i < this.current_d; ++i) {
            if (this.output_d[i] != PARAMETER) {
                out.write(this.output_d[i]);
                continue;
            }
            out.write(this.encode(args[n++]));
        }
        if (n < args.length) {
            throw new IllegalArgumentException("Too many arguments");
        }
    }

    private void append(byte[] data) {
        if (this.current_d >= this.length_d && (this.output_d[this.current_d - 1] == PARAMETER || data == PARAMETER)) {
            byte[][] array = new byte[this.length_d + 10][];
            System.arraycopy(this.output_d, 0, array, 0, this.length_d);
            this.length_d += 10;
            this.output_d = array;
        }
        if (this.current_d > 0 && data != PARAMETER && this.output_d[this.current_d - 1] != PARAMETER) {
            byte[] prev = this.output_d[this.current_d - 1];
            byte[] array = new byte[prev.length + data.length];
            System.arraycopy(prev, 0, array, 0, prev.length);
            System.arraycopy(data, 0, array, prev.length, data.length);
            this.output_d[this.current_d - 1] = array;
        } else {
            this.output_d[this.current_d++] = data;
        }
    }

    private byte[] encode(String data) {
        try {
            return data.getBytes(this.encoding_d);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

