/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.Socket;

abstract class InetProtocolClient {
    public boolean connected = false;
    public transient boolean debug = false;
    public int port;
    public String server;
    protected transient BufferedReader inStream;
    protected boolean multiline = false;
    protected transient DataOutputStream outStream;
    protected int rc_length = 3;
    protected transient Socket servSock;

    protected InetProtocolClient() {
        this(null, 0);
    }

    protected InetProtocolClient(int i) {
        this(null, i);
    }

    protected InetProtocolClient(String s, int i) {
        this.server = s;
        this.port = i;
    }

    protected String getReply() throws IOException {
        String s = "";
        String s1 = "";
        while (true) {
            String s2 = this.inStream.readLine();
            if (this.debug) {
                System.out.println("Inside INetProtocolClient:: " + s2);
            }
            if (s2.length() < this.rc_length) {
                throw new IOException("Bad server response: " + s);
            }
            s = s + s2 + "\n";
            if (!this.multiline) {
                return s;
            }
            if (s2.charAt(3) == '-') {
                s1 = s2.substring(0, 3);
                if (!this.debug) continue;
                System.out.println("Reply Code is: " + s1);
                continue;
            }
            if (!s1.equals("") && s2.startsWith(s1) && s2.indexOf(32) == s1.length() || s1.equals("") && s2.charAt(3) != '-' || s1.equals("") && s2.length() == 3) break;
        }
        return s;
    }

    protected void checkReply(String s, String s1) throws IOException {
        if (!s.startsWith(s1)) {
            throw new IOException(s);
        }
    }

    protected void close() throws IOException {
        if (this.inStream != null) {
            this.inStream.close();
        }
        if (this.outStream != null) {
            this.outStream.close();
        }
        if (this.servSock != null) {
            this.servSock.close();
        }
        this.connected = false;
    }

    protected String connect() throws IOException, ConnectException {
        this.connected = false;
        this.servSock = new Socket(this.server, this.port);
        this.inStream = new BufferedReader(new InputStreamReader(this.servSock.getInputStream()));
        this.outStream = new DataOutputStream(this.servSock.getOutputStream());
        this.connected = true;
        return this.getReply();
    }

    protected String sendCommand(String s) throws IOException {
        if (this.debug) {
            System.out.println(s);
        }
        this.outStream.writeBytes(s + "\n");
        return this.getReply();
    }
}

