/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.http;

import java.io.IOException;
import java.io.PrintStream;
import oracle.bpm.http.AbstractHttpCommand;
import oracle.bpm.http.Cookie;
import oracle.bpm.http.HttpCommand;
import oracle.bpm.http.HttpRequest;
import oracle.bpm.http.HttpResponse;
import oracle.bpm.lang.TimedCache;

public class AuthenticatedCommand
extends AbstractHttpCommand {
    private HttpCommand command;
    private static TimedCache sessions_sd = new TimedCache(10, 900);

    public AuthenticatedCommand(HttpCommand command) {
        super(command.getName(), command.getDescription(), command.getGroup());
        this.command = command;
    }

    @Override
    public void process(HttpRequest request, HttpResponse response) throws IOException {
        Cookie cookie = Cookie.parse(request);
        String sessionId = null;
        if (cookie != null) {
            sessionId = cookie.getAttribute("sessionId");
        }
        if (sessionId == null) {
            this.login(request, response.getPrintStream());
            return;
        }
        if (!sessions_sd.containsKey(sessionId)) {
            this.relogin(request, response.getPrintStream());
            return;
        }
    }

    private void login(HttpRequest request, PrintStream out) throws IOException {
        out.println(this.loginForm(request.getPath()));
    }

    private String loginForm(String file) {
        StringBuffer form = new StringBuffer();
        form.append("<form action=/login method=get>\n");
        form.append("<input type=password name=password size=12>");
        form.append("<input type=submit value=Login name=login>");
        form.append("<input type=hidden value=" + file + " name=file>");
        form.append("</form>\n");
        return form.toString();
    }

    private void relogin(HttpRequest request, PrintStream out) throws IOException {
        out.println(this.loginForm(request.getPath()));
    }
}

