/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.holidays;

import java.util.Locale;
import oracle.bpm.holidays.EasterBasedHoliday;
import oracle.bpm.holidays.FixedHoliday;
import oracle.bpm.holidays.Holiday;
import oracle.bpm.holidays.MondayMobileHoliday;
import oracle.bpm.holidays.WeekDayBasedHoliday;
import oracle.bpm.holidays.YearApplicableHoliday;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum HolidayType implements I18nProvider
{
    FIXED(LibMsg.HT_FIXED, "SameDayEveryYear"){

        @Override
        public Holiday createItem(String text) {
            return FixedHoliday.create(text);
        }
    }
    ,
    YEAR_APPLICABLE(LibMsg.HT_YEAR_APPLICABLE, "OnlyForCurrentYear"){

        @Override
        public Holiday createItem(String text) {
            return YearApplicableHoliday.create(text);
        }
    }
    ,
    WEEK_DAY_BASED(LibMsg.HT_WEEK_DAY_BASED, "NthWeekDayOfMonth"){

        @Override
        public Holiday createItem(String text) {
            return WeekDayBasedHoliday.create(text);
        }
    }
    ,
    EASTER(LibMsg.HT_EASTER, "NthDayOfRefHoliday"){

        @Override
        public Holiday createItem(String text) {
            return EasterBasedHoliday.create(text);
        }
    }
    ,
    MONDAY_MOBILE(LibMsg.HT_MONDAY_MOBILE, "ClosestWeekDay"){

        @Override
        public Holiday createItem(String text) {
            return MondayMobileHoliday.create(text);
        }
    };

    private transient Msg msg;
    private String value;

    private HolidayType(Msg msg, String value) {
        this.msg = msg;
        this.value = value;
    }

    @Override
    public String getString() {
        return this.msg.getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.msg.getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }

    public Holiday createItem(String text) {
        return null;
    }

    public String getValue() {
        return this.value;
    }

    public static HolidayType fromValue(String value) {
        for (HolidayType holidayType : HolidayType.values()) {
            if (!holidayType.getValue().equals(value)) continue;
            return holidayType;
        }
        return null;
    }
}

