/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.data;

import java.util.Locale;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Labeled;
import oracle.bpm.resources.Msg;

public enum WaitType implements I18nProvider,
Labeled
{
    PARENT(LibMsg.PARENT),
    CHILD(LibMsg.CHILD),
    EXTERNAL(LibMsg.EXTERNAL),
    INTERNAL(LibMsg.INTERNAL);

    private transient Msg msg;

    private WaitType(Msg msg) {
        this.msg = msg;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }

    @Override
    public Msg getLabel() {
        return this.getMsg();
    }

    public int getIn() {
        return this.ordinal();
    }

    public static WaitType migrate(String value) {
        int wt = Integer.parseInt(value);
        WaitType[] types = WaitType.values();
        return wt >= 0 && wt < types.length ? types[wt] : null;
    }
}

