/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.data;

import fuego.directory.msg.DirectoryMsg;
import oracle.bpm.lang.EnumType;
import oracle.bpm.log.Log;

public class InternalInstanceState
implements EnumType {
    public static final int RUNNING = 1;
    public static final int SUSPENDED = 2;
    public static final int GRABBED = 4;
    public static final int JOIN_WAITING = 8;
    public static final int EXCEPTION = 16;
    public static final int COMPLETED = 32;
    public static final int ABORTED = 64;
    public static final int ACTIVITY_COMPLETED = 128;
    public static final int ABORTING = 256;
    public static final int AUTOMATIC_RESUME = 512;
    public static final int SHARING_VARIABLES = 1024;
    public static final int STICKY_PARTICIPANT = 2048;
    public static final int IN_RELAY = 4096;
    public static final int SELECTED_FOR_EXECUTION = 8192;
    public static final int SHARING_PREDEFINED_VARIABLES = 16384;
    static final int[][] STATES = new int[][]{new int[0], {1, 9}, {17, 145}, {2, 514}, {5, 133}, {32}, {64, 256, 257, 258}, {129}};
    private static final String[] names_sd = new String[]{"RUNNING", "SUSPENDED", "GRABBED", "JOIN_WAITING", "EXCEPTION", "COMPLETED", "ABORTED", "ACTIVITY_COMPLETED", "ABORTING", "AUTOMATIC_RESUME", "SHARING_VARIABLES", "STICKY_PARTICIPANT", "IN_REALY", "SELECTED_FOR_EXECUTION", "SHARING_PREDEFINED_VARIABLES"};
    private static int[] values_sd = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384};
    private static int[] flagValues = new int[]{512, 1024, 2048, 4096, 8192, 16384};
    private static InternalInstanceState instance_sd = new InternalInstanceState();

    public static int[] getInstanceStateValues(int val) {
        return STATES[val];
    }

    public static int getProcessInstanceState(int val) {
        int target = val & 0xFFFF81F7;
        for (int i = 0; i < STATES.length; ++i) {
            for (int ii = 0; ii < STATES[i].length; ++ii) {
                if (STATES[i][ii] != target) continue;
                return i;
            }
        }
        if (Log.isDebugging()) {
            Log.logDebug(DirectoryMsg.INVALID_INSTANCE_STATE(val, Integer.toHexString(target)));
        }
        return 0;
    }

    public static int[] getStatesForProcessInstanceState(int processInstanceState) {
        if (processInstanceState > 0 && processInstanceState < STATES.length) {
            return STATES[processInstanceState];
        }
        return new int[0];
    }

    public static int getFilteredState(int val) {
        if (((val &= 0xFFFF83FF) & 0x10) != 0) {
            val = 16;
        } else if ((val & 1) != 0) {
            if ((val &= 0xFFFFFF7F) != 1) {
                val &= 0xFFFFFFFE;
            }
        } else if ((val & 2) != 0) {
            val &= 0xFFFFFDFF;
        }
        return val;
    }

    public static String getId(int val) {
        val = InternalInstanceState.getIndex(val);
        return names_sd[val];
    }

    public static String getName(int val) {
        int filteredVal = InternalInstanceState.getFilteredState(val);
        return InternalInstanceState.getId(filteredVal);
    }

    public static boolean hasState(int state, int mask) {
        return (state & mask) != 0;
    }

    public static int valueOf(String id) {
        int result = -1;
        for (int i = 0; i < names_sd.length; ++i) {
            if (!names_sd[i].equalsIgnoreCase(id)) continue;
            result = i;
            break;
        }
        return values_sd[result];
    }

    public static int[] getFlagMasks() {
        int size = (int)Math.pow(2.0, flagValues.length);
        int[] values = new int[size];
        for (int i = 0; i < size; ++i) {
            values[i] = 0;
            for (int j = 0; j < flagValues.length; ++j) {
                if ((i & 1 << j) == 0) continue;
                int n = i;
                values[n] = values[n] | flagValues[j];
            }
        }
        return values;
    }

    private static int getIndex(int val) {
        for (int i = 0; i < values_sd.length; ++i) {
            int k = values_sd[i];
            if (k != val) continue;
            return i;
        }
        assert (false) : "Value not in table:" + val;
        return 0;
    }
}

