/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.spi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.configuration.Configuration;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.spi.ConnectorInterface;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.ConnectorFactoryMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.log.Log;

public abstract class ConnectorFactory {
    private static Map<ConfigType, ConnectorFactory> factories;
    protected static final long NO_FEATURES = 0L;

    public abstract ConfigType getConfigType();

    public abstract ConnectorInterface createConnector(ConnectorService var1, String var2, Properties var3);

    public static final ConnectorFactory getFactory(Configuration entry) throws ConnectorException {
        return ConnectorFactory.getFactory(entry.getConfigType());
    }

    public static final ConnectorFactory getFactory(ConfigType configType) throws ConnectorException {
        ConnectorFactory result = null;
        for (ConfigType current = configType; result == null && current != null; current = current.getParent()) {
            result = ConnectorFactory.getFactories().get(current);
        }
        if (result == null) {
            throw ConnectorException.factoryNotFound(configType);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<ConfigType, ConnectorFactory> getFactories() {
        if (factories != null) return factories;
        Class<ConnectorFactory> clazz = ConnectorFactory.class;
        synchronized (ConnectorFactory.class) {
            if (factories != null) return factories;
            HashMap<ConfigType, ConnectorFactory> map = new HashMap<ConfigType, ConnectorFactory>();
            ExtensionService service = Platform.getExtensionService();
            List<Extension<ConnectorFactoryMetadata>> extensions = service.getExtensionsByPoint(ConnectorFactoryMetadata.class);
            for (Extension<ConnectorFactoryMetadata> extension : extensions) {
                try {
                    ConnectorFactory factory = extension.instantiateAs(ConnectorFactory.class);
                    ConfigType configType = factory.getConfigType();
                    assert (configType != null) : "Factory with null config type: " + factory;
                    map.put(configType, factory);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    Log.logSevere(e);
                }
            }
            factories = map;
            // ** MonitorExit[var0] (shouldn't be in output)
            return factories;
        }
    }

    public static void register(ConnectorFactory factory) {
        ConnectorFactory.getFactories().put(factory.getConfigType(), factory);
    }
}

